package com.stonecrusher.delete;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class DeleteBoulderInward extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5973736614943901363L;
	private SessionMap<String,Object> sessionMap;  
	private String fromDate;
	private String toDate;
	private String key;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
				
				String entryId = keyDetails[0];
				String inwardDate = keyDetails[1];
				String vehicleId= keyDetails[2];
				
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "DELETE FROM "
							+ "boulder_inward_details "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "inward_date = STR_TO_DATE(?,'%d-%m-%Y') "
							+ "AND "
							+ "vehicle_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, inwardDate);
					preparedStatement.setString(3, vehicleId);
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
					int k = preparedStatement.executeUpdate();
					
					if(k > 0)
					{
						result = SUCCESS;
						addActionMessage("Inward entry deleted successfully!");
					}
					else
					{
						result = ERROR;
						addActionError("Inward entry deleted not successfully! Please try again!");
					}
					
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	
	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



