package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class SupplierListInfo extends ActionSupport{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2342659923589029492L;

	private  HttpSession session;

	private String term;
	private Map<String, String> supplierList = new HashMap<String, String>();

	
public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result= "login";  
	        }  
	        else
	        {
	        
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				sql = "SELECT "
						+ "supplier_id,"
						+ "supplier_name,"
						+ "contact_number "
						+ "FROM "
						+ "crusher_supplier_master "
						+ "where "
						+ "(supplier_name like '%"+term+"%' "
						+ "or "
						+ "contact_number like '%"+term+"%') "
						+ "AND "
					    + "crusher_id = ? "
					    + "AND "
					    + "crusher_code = ?";
       			
				
								
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				resultSet.last();
				int rows=resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rows>0)
				{
					while(resultSet.next())
					{
					supplierList.put(resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(3), 
							resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(3));
					
					}
				}
				else
				{
					supplierList.put("Supplier_Not_Found", "Supplier Not Found");
				}
				
			} catch (SQLException e) {
				//e.printStackTrace();
				
			} catch (IOException e) {
			
				//e.printStackTrace();
			}finally
			{
				if(resultSet != null)
   				{
   					try {resultSet.close();}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {
						preparedStatement.close();
					} catch (SQLException e) {
						
					}
				}
				
				if(connection != null)
				{
					try {
						connection.close();
					} catch (SQLException e) {
						
					}
				}
				
				
			}
			
			result = "success";
	        }
	        
	        return result;
}

public String getTerm() {
	return term;
}

public void setTerm(String term) {
	this.term = term;
}

public Map<String, String> getSupplierList() {
	return supplierList;
}

public void setSupplierList(Map<String, String> supplierList) {
	this.supplierList = supplierList;
}



}
