package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerInfoDAO;
import com.stonecrusher.DAO.SupplierInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class SearchSupplierInfo extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6756358979030980171L;
	private String key;
	private String searchOption;
	
	private HttpSession session;	
	
	private List<SupplierInfoDAO> supplierInfoList = new ArrayList<SupplierInfoDAO>();
	
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
           result =  "login";  
        }  
        else
        {
        	String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       	
       		String actualKey = this.getKey().trim();
       		     
       		String sql = "";
	       		if(this.getSearchOption().equals("BYNAME"))
	       		{	
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "supplier_name,"
	       					+ "contact_number,"
	       					+ "supplier_address "
	       					+ "FROM "
	       					+ "crusher_supplier_master "
	       					+ "WHERE "
	       					+ "supplier_name LIKE '%"+actualKey+"%'"
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
	       		}
	       		else if(this.getSearchOption().equals("BYMOBILE"))
	       		{
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "supplier_name,"
	       					+ "contact_number,"
	       					+ "supplier_address "
	       					+ "FROM "
	       					+ "crusher_supplier_master "
	       					+ "WHERE "
	       					+ "contact_number LIKE '%"+actualKey+"%'"
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ?";
	       		}
	       		else if(this.getSearchOption().equals("BYADDRESS"))
	       		{
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "supplier_name,"
	       					+ "contact_number,"
	       					+ "supplier_address "
	       					+ "FROM "
	       					+ "crusher_supplier_master "
	       					+ "WHERE "
	       					+ "supplier_address LIKE '%"+actualKey+"%'"
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ?";
	       		}
	       		
	       		
	       		
	       		String db = (String) session.getAttribute("db");
			       	try{
			       			
			       		
							connection = GetDBConnection.getDBConnection(db);
			       			
			       			preparedStatement = connection.prepareStatement(sql);
			       			preparedStatement.setString(1, crusherId);
							preparedStatement.setString(2, crusherCode);
							
			       			resultSet = preparedStatement.executeQuery();      			
			       			resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							
							if(rowCount>0)
							{
								while(resultSet.next())
								{
									
									SupplierInfoDAO infoDAO = new SupplierInfoDAO();
									
									PreparedStatement getOpeningBalPSMT = null;
				       				ResultSet getOpeningBalRs = null;
				       				String getOpeningBalSQL = "SELECT "
				       						+ "opening_balance "
				       						+ "FROM "
				       						+ "crusher_supplier_close_open_bal_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ?";
				       				
				       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
				       				
				       				getOpeningBalPSMT.setString(1, resultSet.getString(1));
				       				getOpeningBalPSMT.setString(2, crusherId);
				       				getOpeningBalPSMT.setString(3, crusherCode);
									
				       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
				       				
				       				if(getOpeningBalRs.next())
				       				{
				       					infoDAO.setSupplierOpeningBal(getOpeningBalRs.getFloat(1));
				       				}
				       				else
				       				{
				       					infoDAO.setSupplierOpeningBal(0.0F);
				       				}
				       				
				       				
				       				if(getOpeningBalRs != null)
				       				{
				       					getOpeningBalRs.close();
				       					getOpeningBalRs = null;
				       				}
				       				if(getOpeningBalPSMT != null)
				       				{
				       					getOpeningBalPSMT.close();
				       					getOpeningBalPSMT = null;
				       				}

									
									infoDAO.setSupplierId(resultSet.getString(1));
									infoDAO.setSupplierName(resultSet.getString(2));
									infoDAO.setSupplierMobile(resultSet.getString(3));
									infoDAO.setSupplierAddress(resultSet.getString(4));
									infoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
									
									float floatTotalPurchaseAmt = 0.0F;
				       				float floatTotalAmountPaid = 0.0F;
				       				float floatTotalBalanceAmt = 0.0F;
				       				
				       				
				       				PreparedStatement getTotalPurchasePSMT = null;
				       				ResultSet getTotalPurchaseRS = null;
				       				
				       				String getTotalPurchaseSQL = "SELECT "
				       						+ "SUM(purchase_total_amount),"
				       						+ "SUM(purchase_amount_paid) "
				       						+ "FROM "
				       						+ "crusher_purchase_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ? "
					    					+ "GROUP BY supplier_id";
				       				
				       				getTotalPurchasePSMT = connection.prepareStatement(getTotalPurchaseSQL);
				       				
				       				getTotalPurchasePSMT.setString(1, resultSet.getString(1));
				       				getTotalPurchasePSMT.setString(2, crusherId);
				       				getTotalPurchasePSMT.setString(3, crusherCode);
									
				       				getTotalPurchaseRS = getTotalPurchasePSMT.executeQuery();
				       				
				       				if(getTotalPurchaseRS.next())
				       				{
				       					floatTotalPurchaseAmt = getTotalPurchaseRS.getFloat(1);
				       					floatTotalAmountPaid = getTotalPurchaseRS.getFloat(2);
				       					
				       					
				       				}
				       				
				       				
				       				PreparedStatement getSuppAmtPaidPSMT = null;
				       				ResultSet getSuppAmtPaidRS = null;
				       				String getSuppAmtPaidSQL = "SELECT "
				       						+ "SUM(amount) "
				       						+ "FROM "
				       						+ "crusher_supplier_payment_details_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ? "
					    					+ "GROUP BY supplier_id";
				       				
				       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
				       				
				       				
				       				
				       				getSuppAmtPaidPSMT.setString(1, resultSet.getString(1));
				       				getSuppAmtPaidPSMT.setString(2, crusherId);
				       				getSuppAmtPaidPSMT.setString(3, crusherCode);
									
				       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
				       				
				       				
				       				
				       				if(getSuppAmtPaidRS.next())
				       				{
				       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
				       				}
				       				
				       				floatTotalBalanceAmt = floatTotalPurchaseAmt - floatTotalAmountPaid;
				       				
				       				infoDAO.setTotalPurchase(""+floatTotalPurchaseAmt);
				       				infoDAO.setDebtAmount(floatTotalBalanceAmt+infoDAO.getSupplierOpeningBal());
				       				
				       	
				       				if(getSuppAmtPaidRS != null)
				       				{
				       					getSuppAmtPaidRS.close();
				       					getSuppAmtPaidRS = null;
				       				}
				       				
				       				if(getSuppAmtPaidPSMT != null)
				       				{
				       					getSuppAmtPaidPSMT.close();
				       					getSuppAmtPaidPSMT = null;
				       				}
				       				
				       				
				       				
				       				if(getTotalPurchaseRS != null)
				       				{
				       					getTotalPurchaseRS.close();
				       					getTotalPurchaseRS = null;
				       				}
				       				
				       				if(getTotalPurchasePSMT != null)
				       				{
				       					getTotalPurchasePSMT.close();
				       					getTotalPurchasePSMT = null;
				       				}
				       				
									
									this.getSupplierInfoList().add(infoDAO);
								}
								
							}
							
							Collections.sort(supplierInfoList, new Comparator<SupplierInfoDAO>() {
						        @Override
						        public int compare(SupplierInfoDAO c1, SupplierInfoDAO c2) {
						            return c1.getSupplierId().compareTo(c2.getSupplierId());
						        }
						    });
							
			       		}
	       				catch (SQLException e) {
	       					e.printStackTrace();
	       				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
						} catch (IOException e) {
							//e.printStackTrace();
							addActionMessage(e.getMessage()+"|| SOME ERROR");
						}	
						finally
						{
							if(resultSet != null)
							{
								try{resultSet.close();resultSet=null;}catch(SQLException sqe){}   					
							}
							if(preparedStatement != null)
							{
								try {preparedStatement.close();preparedStatement=null;} catch (SQLException e) {}
							}
							if(connection != null)
							{
								try {connection.close();connection=null;} catch (SQLException e) {}
							}
							
						}
        	}
			
       result = "success";
		
		return result;
	}
		
		



	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getSearchOption() {
		return searchOption;
	}


	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}


	


	public List<SupplierInfoDAO> getSupplierInfoList() {
		return supplierInfoList;
	}


	public void setSupplierInfoList(List<SupplierInfoDAO> supplierInfoList) {
		this.supplierInfoList = supplierInfoList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
}
