package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;


public class SearchProductInfo extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8486455428421982535L;
	
	private String key;
	
	private  HttpSession session;
	private ArrayList<ProductInfoDAO> searchProductInfo =  new ArrayList<ProductInfoDAO>();
	
	
	@Override
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            return "login";  
        }  
        else
        {
        	
        	String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       		
       		String sql = "";
       		String db = (String) session.getAttribute("db");
       		try {
   				
       			
       			sql = "SELECT "
       					+ "DATE_FORMAT(add_date, '%d-%M-%Y'),"
       					+ "pr.product_name_eng,"
       					+ "pr.product_name_mar,"
       					+ "pr.product_alias,"
       					+ "pr.purchase_rate,"
       					+ "pr.customer_sales_price,"
       					+ "tx.tax_percentage,"
       					+ "pr.product_id "
       					+ "FROM "
       					+ "crusher_product_master as pr "
       					+ "INNER JOIN "
       					+ "crusher_tax_table as tx "
       					+ "on "
       					+ "pr.tax_id = tx.tax_id "
       					+ "where "
       					+ "(pr.product_name_eng "
       					+ "like '%"+key.trim()+"%' "
       					+ "or "
       					+ "pr.product_alias "
       					+ "like '%"+key.trim()+"%') "
       					+ "AND "
       					+ "pr.crusher_id = ? "
       					+ "AND "
       					+ "pr.crusher_code = ? "
       					+ "AND "
       					+ "tx.crusher_id = ? "
       					+ "AND "
       					+ "tx.crusher_code = ? ";
       			
       			
				connection = GetDBConnection.getDBConnection(db);
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				resultSet.last();
				int rowCount = resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rowCount>0)
				{
					while(resultSet.next())
					{
						result =  "success";
						
						
						ProductInfoDAO productInfoDAO = new ProductInfoDAO();
						
						productInfoDAO.setAddDate(resultSet.getString(1));
						productInfoDAO.setProductName(resultSet.getString(2));
						productInfoDAO.setMarathiName(resultSet.getString(3));
						productInfoDAO.setAlias(resultSet.getString(4));
						productInfoDAO.setPurchaseRate(resultSet.getString(5));
						productInfoDAO.setSalesRate(resultSet.getString(6));
						productInfoDAO.setTax(resultSet.getString(7));
						productInfoDAO.setProductId(resultSet.getString(8));
						searchProductInfo.add(productInfoDAO);
						
					}
				}
				else
				{
					addActionMessage("Records Not Found !!!");
				}
       		
			} catch (SQLException e) {
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		}
    	
    	
    	return result;
	}
	
	
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public ArrayList<ProductInfoDAO> getSearchProductInfo() {
		return searchProductInfo;
	}
	public void setSearchProductInfo(ArrayList<ProductInfoDAO> searchProductInfo) {
		this.searchProductInfo = searchProductInfo;
	}
	
	
	
	

}
