package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.QuotationInformationDAO;
import com.stonecrusher.db.GetDBConnection;

public class QuotationInfoJSON extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3828289564696834998L;
	
	private String key;
	private String searchOption;
	
	private HttpSession session;	

	
	private List<QuotationInformationDAO> quotationInfoList = new ArrayList<QuotationInformationDAO>();
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            result = "login";  
        }  
        else
        {
        	String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
       	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       	String actualKey = this.getKey().trim();
       		
       		String sql = "";
       		if(this.getSearchOption().equals("BYNAME"))
       		{	
       		 sql = "SELECT  "
       				+ "customer_id "
       				+ "FROM "
       				+ "crusher_customer_master "
       				+ "WHERE "
       				+ "customer_name LIKE '%"+actualKey+"%' "
       				+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
       			
       		}
       		else if(this.getSearchOption().equals("BYMOBILE"))
       		{
       			sql = "SELECT  "
       					+ "customer_id "
           				+ "FROM "
           				+ "crusher_customer_master "
           				+ "WHERE "
           				+ "mobile_number LIKE '%"+actualKey+"%' "
           				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
           				
       		}
       		else if(this.getSearchOption().equals("BYADDRESS"))
       		{
       			sql = "SELECT  "
       					+ "customer_id "
           				+ "FROM "
           				+ "crusher_customer_master "
           				+ "WHERE "
           				+ "billing_address LIKE '%"+actualKey+"%' "
           				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       		}
       		else
       		{
       		 sql = "SELECT  "
	       				+ "customer_id "
	       				+ "FROM "
        				+ "crusher_customer_master "
        				+ "WHERE "
        				+ "customer_name LIKE '%"+actualKey+"%' "
        				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       				
       			
       		}
       		
       		String db = (String) session.getAttribute("db");
       		try {
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
       			resultSet = preparedStatement.executeQuery();      			
       			resultSet.last();
				int rowCount = resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rowCount>0)
				{
       			 	
					if (rowCount > 0) {
					    while (resultSet.next()) {
					        String customerId = resultSet.getString(1); 

					       
					        String quotationQuery = "SELECT "
					                + "quotationnumber, "
					                + "quotationdate, "
					                + "customername, "
					                + "quotationtotalamount, "
					                + "quotation_by "
					                + "FROM quotation_info "
					                + "WHERE custid = ? "
					                + "AND crusher_id = ? "
					                + "AND crusher_code = ?";

					        try (PreparedStatement quotationStatement = connection.prepareStatement(quotationQuery)) {
					            quotationStatement.setString(1, customerId);
					            quotationStatement.setString(2, crusherId);
					            quotationStatement.setString(3, crusherCode);

					            try (ResultSet quotationResultSet = quotationStatement.executeQuery()) {
					                while (quotationResultSet.next()) {
					                    QuotationInformationDAO quotationInfoDAO = new QuotationInformationDAO();

					                    quotationInfoDAO.setQuotationNumber(quotationResultSet.getString("quotationnumber"));
					                    quotationInfoDAO.setQuotationDate(quotationResultSet.getString("quotationdate"));
					                    quotationInfoDAO.setCustomerName(quotationResultSet.getString("customername"));
					                    quotationInfoDAO.setQuotationAmount(quotationResultSet.getString("quotationtotalamount"));
					                    quotationInfoDAO.setQuotationBy(quotationResultSet.getString("quotation_by"));

					                    quotationInfoList.add(quotationInfoDAO);
					                }
					            }
					        }
					    }
					}

				}	
       		}	 catch (SQLException e) {
   				//e.printStackTrace();
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				//e.printStackTrace();
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try{resultSet.close();resultSet = null;}catch(SQLException sqe){}   					
   				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		}
    	result = "success";
    	return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	

	


	public List<QuotationInformationDAO> getQuotationInfoList() {
		return quotationInfoList;
	}

	public void setQuotationInfoList(List<QuotationInformationDAO> quotationInfoList) {
		this.quotationInfoList = quotationInfoList;
	}

	public String getSearchOption() {
		return searchOption;
	}

	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}

		

	
	
}
