package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class ProductListInfo extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5586134054420169376L;

	private  HttpSession session;

	private String term;
	private Map<String, String> productList = new HashMap<String, String>();
	private SessionMap<String,Object> sessionMap;  
	
    public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result= "login";  
	        }  
	        else
	        {
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			try {
			
				connection = GetDBConnection.getDBConnection(db);
				
				sql = "SELECT "
						+ "product_id,product_alias,product_name_eng,product_name_mar "
						+ "FROM "
						+ "crusher_product_master "
						+ "where "						
						+ "product_name_eng LIKE '%"+term+"%' "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
				
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
						
				resultSet = preparedStatement.executeQuery();
				resultSet.last();
				int rows=resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rows>0)
				{
					while(resultSet.next())
					{
						productList.put(resultSet.getString(1)+"-"+resultSet.getString(3), 
							resultSet.getString(2)+"|"+resultSet.getString(3)+"|"+resultSet.getString(4));
					
					}
				}
				else
				{
					productList.put("Product_Not_Found", "Product Not Found");
				}
				
			} catch (SQLException e) {
				//e.printStackTrace();
				
			} catch (IOException e) {
			
				//e.printStackTrace();
			}finally
			{
				{
					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
			
			result = "success";
	        }
	        
	        return result;
}

public String getTerm() {
	return term;
}

public void setTerm(String term) {
	this.term = term;
}

public Map<String, String> getProductList() {
	return productList;
}

public void setProductList(Map<String, String> productList) {
	this.productList = productList;
}

@Override
public void setSession(Map<String, Object> arg0) {
	// TODO Auto-generated method stub
	sessionMap=(SessionMap<String, Object>)arg0;
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}




}

