package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetPurchaseProductDetails extends ActionSupport{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4526288239167750659L;
	private HttpSession session;
	private String purchaseUnit;
	private String purchaseRate;
	private String tax;
	private String productFullName;
	private String aliasValue;
	
	
	public String execute(){
		
		
		 
		String result = "login";;
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
					try
					{
					
						connection = GetDBConnection.getDBConnection(db);
						
						try
						{
							if(this.getAliasValue().contains("-"))
							{
								this.setAliasValue(this.getAliasValue().split("-")[1]);
							}
						}catch (Exception e) {}
						
						sql = "SELECT product_id,product_name_eng,purchase_rate,purchase_unit,tax_id "
								+ "FROM "
								+ "crusher_product_master "
								+ "where "
								+ "(product_alias = '"+getAliasValue()+"' "
								+ "or "
								+ "product_name_eng='"+getAliasValue()+"') "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
					
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						resultSet.last();
						int rowCount = resultSet.getRow();
						resultSet.beforeFirst();
						if(rowCount>0)
						{
						while(resultSet.next())
						{
							setProductFullName(resultSet.getString(1)+"-"+resultSet.getString(2));
							setPurchaseRate(resultSet.getString(3));
							setPurchaseUnit(resultSet.getString(4));								
							setTax(resultSet.getString(5));
							
						}
							result = "success";
						}
						else
						{
							result = "error";
						}
						
					}catch (SQLException e) {
						
					//e.printStackTrace();
					} catch (IOException e) {
						
					//e.printStackTrace();
					}finally {
						if(resultSet !=null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();
							 connection = null;
							}catch (SQLException e) {}
						}
						
					}
	        }
	
	return result;
}


	public String getPurchaseUnit() {
		return purchaseUnit;
	}


	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}


	public String getPurchaseRate() {
		return purchaseRate;
	}


	public void setPurchaseRate(String purchaseRate) {
		this.purchaseRate = purchaseRate;
	}


	public String getTax() {
		return tax;
	}


	public void setTax(String tax) {
		this.tax = tax;
	}


	public String getProductFullName() {
		return productFullName;
	}


	public void setProductFullName(String productFullName) {
		this.productFullName = productFullName;
	}


	public String getAliasValue() {
		return aliasValue;
	}


	public void setAliasValue(String aliasValue) {
		this.aliasValue = aliasValue;
	}
	
	
	
	
	
	

}
