package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetPresentyDetailsOfLabor extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8937804814301899819L;
	private SessionMap<String,Object> sessionMap;
	private String LaborIdName;
	private String fromDate;
	private String toDate;
	private Integer noOfDaysAbsentDays;
	private Integer noOfOverTime;
	private Integer noOfHalfDays;
	private Integer noOfDaysInMonth;
	private Integer noOfFullDays;
	public String execute() {
		 
		String result = "login";
	      if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					String [] laborDetails = this.getLaborIdName().split("-");
					
					String laborId = laborDetails[0];
					
					this.setNoOfDaysAbsentDays(0);
					this.setNoOfOverTime(0);
					this.setNoOfHalfDays(0);
					
					
					SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
					

					int noOfDays = 0;
					try {
					    Date date1 = myFormat.parse(this.getFromDate());
					    Date date2 = myFormat.parse(this.getToDate());
					    long diff = date2.getTime() - date1.getTime();
					    noOfDays = (int) TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) +1;
					} catch (ParseException e) {}
				
					this.setNoOfDaysInMonth(noOfDays);
					sql = "SELECT "
							+ "type_of_marking "
							+ "FROM "
							+ "crusher_employee_presenty_details "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
							+ "(marking_date BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y'))"
							+ "AND "
						    + "crusher_id = ? "
						    + "AND "
						    + "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, this.getFromDate());
					preparedStatement.setString(3, this.getToDate());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						if(resultSet.getString(1).equals("ABSENT"))
						{
							this.setNoOfDaysAbsentDays(this.getNoOfDaysAbsentDays() + 1);
						}
						if(resultSet.getString(1).equals("HALFDAY"))
						{
							this.setNoOfHalfDays(this.getNoOfHalfDays() + 1);
						}
						if(resultSet.getString(1).equals("OVERTIME"))
						{
							this.setNoOfOverTime(this.getNoOfOverTime() + 1);
						}
						
					}
					
					
					this.setNoOfFullDays(this.getNoOfDaysInMonth()-(this.getNoOfDaysAbsentDays()+this.getNoOfHalfDays()));
					
					result = SUCCESS;
					
				}catch (SQLException e) {
					e.printStackTrace();
				} catch (IOException e) {
					//e.printStackTrace();
				}finally {
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
				}
				
	        }
	      
	      return result;
	}
	
	

	public String getLaborIdName() {
		return LaborIdName;
	}



	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public Integer getNoOfDaysAbsentDays() {
		return noOfDaysAbsentDays;
	}



	public void setNoOfDaysAbsentDays(Integer noOfDaysAbsentDays) {
		this.noOfDaysAbsentDays = noOfDaysAbsentDays;
	}



	public Integer getNoOfOverTime() {
		return noOfOverTime;
	}



	public void setNoOfOverTime(Integer noOfOverTime) {
		this.noOfOverTime = noOfOverTime;
	}





	public Integer getNoOfHalfDays() {
		return noOfHalfDays;
	}



	public void setNoOfHalfDays(Integer noOfHalfDays) {
		this.noOfHalfDays = noOfHalfDays;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public Integer getNoOfDaysInMonth() {
		return noOfDaysInMonth;
	}



	public void setNoOfDaysInMonth(Integer noOfDaysInMonth) {
		this.noOfDaysInMonth = noOfDaysInMonth;
	}



	public Integer getNoOfFullDays() {
		return noOfFullDays;
	}



	public void setNoOfFullDays(Integer noOfFullDays) {
		this.noOfFullDays = noOfFullDays;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

}
