package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ChequeNumberDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetBankBranchChequeList extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -5996149241724978742L;

	private HttpSession session;	
	private String bankName;
	private String branchName;
	private SessionMap<String,Object> sessionMap;  
	
	private List<ChequeNumberDAO> chequeNumberList = new ArrayList<ChequeNumberDAO>();
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            result = "login";  
        }  
        else
        {
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	
        	//System.out.println("hello");
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       		
       		String sql ="";
       		String db = (String) session.getAttribute("db");
       		try {
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			sql = "SELECT "
       					+ "cheque_number "
       					+ "FROM "
       					+ "cheque_book_details_master "
       					+ "WHERE "
       					+ "cheque_book_bank_name = ? "
       					+ "AND "
       					+ "cheque_book_branch_name = ? "
       					+ "AND "
       					+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "AND "
						+ "cheque_status = 'ACTIVE'";
       					
       			
       			
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, this.getBankName());
       			preparedStatement.setString(2, this.getBranchName());
       			preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				
       			resultSet = preparedStatement.executeQuery();
       			
       			
       			ChequeNumberDAO dao1 = new ChequeNumberDAO();
       			
       			dao1.setChequeNumber("----- SELECT CHEQUE -----");
       			dao1.setValue("");
       			chequeNumberList.add(dao1);
       			
       			while(resultSet.next())
       			{
       				ChequeNumberDAO dao = new ChequeNumberDAO();
       				dao.setChequeNumber(resultSet.getString(1));
       				dao.setValue(resultSet.getString(1));
       				
       				chequeNumberList.add(dao);
       			}
       			
       			result = "success";
       			
       		}	 catch (SQLException e) {
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
   				
   			}
       		
        }
		
		return result;
	}

	

	public List<ChequeNumberDAO> getChequeNumberList() {
		return chequeNumberList;
	}



	public void setChequeNumberList(List<ChequeNumberDAO> chequeNumberList) {
		this.chequeNumberList = chequeNumberList;
	}



	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}



	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}



	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}



	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	
	

}
