package com.stonecrusher.ajax;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;


public class BoulderSupplierListInfo extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -9159316799238640125L;

	private  HttpSession session;

	private String term;
	private Map<String, String> boulderSuppList = new HashMap<String, String>();
	private SessionMap<String,Object> sessionMap;  
	
	public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result= "login";  
	        }  
	        else
	        {
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				sql = "SELECT "
						+ "boulder_supplier_id,"
						+ "boulder_supplier_name,"
						+ "boulder_supplier_mobile_number,"
						+ "boulder_supplier_address "
						+ "FROM "
						+ "crusher_boulder_supplier_master "
						+ "WHERE "
						+ "("
					    + "UPPER(boulder_supplier_name) LIKE '%" + this.getTerm().toUpperCase() + "%' "
					    + "OR "
					    + "CAST(boulder_supplier_id AS CHAR) LIKE '%" + this.getTerm() + "%' "
					    + ") ";
				
				
				/*
				 * sql = "select " + "customer_id," + "customer_name," + "mobile_number," +
				 * "billing_address " + " FROM " +
				 * "crusher_customer_master where match(customer_name) against ('%"+term+"%') "
				 * + "AND " + "crusher_id = ? " + "AND " + "crusher_code = ? ";
				 */
				
				
				preparedStatement = connection.prepareStatement(sql);
			//	System.out.println(preparedStatement.toString());
						
				
				resultSet = preparedStatement.executeQuery();
				resultSet.last();
				int rows=resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rows>0)
				{
					while(resultSet.next())
					{
					this.getBoulderSuppList().put(resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(3), 
							resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(4));
					
					}
				}
				else
				{
					this.getBoulderSuppList().put("Boulder_Supplier_Not_Found", "Boulder Supplier Not Found");
				}
				
				
				result = SUCCESS;
			} catch (SQLException e) {
				e.printStackTrace();
				
			} catch (Exception e) {
			
				e.printStackTrace();
			}finally
			{
				if(resultSet != null)
   				{
   					try {resultSet.close();resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {
						preparedStatement.close();preparedStatement = null;
					} catch (SQLException e) {
						
					}
				}
				
				if(connection != null)
				{
					try {
						connection.close();connection=null;
					} catch (SQLException e) {
						
					}
				}
				
				
			}
			
			
	   }
	        
	        return result;
}

public String getTerm() {
	return term;
}

public void setTerm(String term) {
	this.term = term;
}


public Map<String, String> getBoulderSuppList() {
	return boulderSuppList;
}

public void setBoulderSuppList(Map<String, String> boulderSuppList) {
	this.boulderSuppList = boulderSuppList;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

@Override
public void setSession(Map<String, Object> arg0) {
	// TODO Auto-generated method stub
	sessionMap=(SessionMap<String, Object>)arg0;
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}



}

