package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.itextpdf.text.log.SysoCounter;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.bulksmsgateway.AddBulkSMSGatewayResponseToDB;
import com.stonecrusher.bulksmsgateway.SendBulkSMSGatewayMessage;
import com.stonecrusher.cipher.EncryptionDecryptionType2;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.infrawhatsappmsg.CheckBalance;
import com.stonecrusher.infrawhatsappmsg.SendWhatsAppMessage;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetCustomerTotalCreditAmountById;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.MaintainCloseingBalUtil;


public class SaveRMCBillAndPrint extends ActionSupport implements SessionAware{
	
	/**
	 * 
	 */     
	private static final long serialVersionUID = -4205886934505595095L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private BillInformationDAO billInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;	
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String billNumber;
	private String billDateTime;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private String chalanNumber;
	private String totalPaybleAmount;
	private Float amountPaid;
	private Float transportCharge;
	private String returnAmount;
	private String alternateMobileNumber;
	private boolean sendSMS;
	
	private boolean billSaved;
	
	
	private List<String> paymentTypeList2 = new ArrayList<String>();
	private String modeOfPayment1;
	private String accountId1;
	private Float amountPaid1;
	private String totalAmount;
	
	
	private String modeOfPayment2;
	private String accountId2;
	private Float amountPaid2;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String addSideBarJs;

	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
    private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	
	
	@SuppressWarnings("unchecked")
	public String execute() {
		
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
		    	
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

				
	        	String ownerMessageCustName = "";
	        	String ownerMessageProductName = "";
	        	String ownerMessageProductNameMarathi = "";
	        	String ownerMessageProductQty = "";
	        	String ownerMessageProductRate = "";
	        	String ownerMessageTotalAmt = "";
	        	String messageProductDetailsLine = "";
	        	String messageProductDetailsLineMar = "";
	        	String ownerMessageCustBal = "";
	        	String ownerMessageDestination = "";
	        	String ownerMessageVehicleMake = "";
	        	String ownerMessageVehicleNumber = "";
	        	
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String billedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		billedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		billedBy =fullUserName;
	        	}
	        	
	        	
	        	if((getAmountPaid() == null || getAmountPaid().equals("")) && (getReturnAmount() == null || getReturnAmount().equals("")))
	        	{
	        		
	        		
	        		this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("RMCProductList"));		        	
		        	this.setBillInfoDAO((BillInformationDAO) this.getSessionMap().get("RMCBillInformation"));
		        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("RMCBillvehicleinfo"));
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	this.setCustomerName(this.getBillInfoDAO().getCustomerName());
		        	this.setBillNumber(this.getBillInfoDAO().getBillNumber());
		        	this.setBillType(this.getBillInfoDAO().getBillType());
	        		
		        	this.setTotalAmount(""+floatTotalAmount);	        	
		        	this.setTotalDiscount(""+floatTotalDiscount);
		        	this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()));
		        
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	this.setDefaultValue(this.getBillInfoDAO().getPaymentType());
		        	

		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	
		        	
		        	addActionError(this.getText("message.error.plzProvideAmountPaidAndAmountReturn"));
	        		
	        		this.getSessionMap().put("RMCBillInformation", this.getBillInfoDAO());
	        		this.getSessionMap().put("RMCProductList", this.getProductInfoList());
	        		result = "error";
		        	
	        	}
	        	else
	        	{
	        		
	        		String billDateTime = "";
	        		
	        		billDateTime = this.getBillInfoDAO().getBillDate();
	        		
	        		if(billDateTime == null || billDateTime == "" )
	        		{
	        			Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			        	billDateTime = dateFormat.format(d);
	        			
			        	
			        	
	        		}
	        		
	        	
	        		
		        	
		        Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("RMCProductList"));
	        	
	        	this.setBillInfoDAO((BillInformationDAO) this.getSessionMap().get("RMCBillInformation"));
	        	
	        	//System.out.print("Is Bill Saved : "+this.getBillInfoDAO().isBillSaved());
	        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("RMCBillvehicleinfo"));
	        	
	        	if(!this.getBillInfoDAO().isBillSaved())	        	
	        	{
	        		/*System.out.println("In Save Bill");
	        		
		        	Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");*/
		        	//String billDateTime = dateFormat.format(d);	        	
		        	
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	String materialNameForTripEntry = "";
		        	float materialQuantityForTripEntry = 0.0F;
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		materialNameForTripEntry = infoDAO.getProductName();
		        		materialQuantityForTripEntry = infoDAO.getQuantity();
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	ownerMessageTotalAmt = ""+floatTotalAmtAfterDiscount;
	        	try
	        	{
	        		
	        		  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	connection.setAutoCommit(false);
	        	
	        	String [] custData = new String [5];
        		
        		String custId = "NA";
        		
        		
        		try
        		{
        			custData = this.getBillInfoDAO().getCustomerName().split("-");
        			custId = custData[0];
        		}
        		catch(Exception e)
        		{
        			//e.printStackTrace();
        			custId = "NA";
        		}
        		
        		if(this.getBillInfoDAO().getBillNumber().equalsIgnoreCase("NA"))
				{
			        		
								
			        			String fy = "24/25";
								
			        			ArrayList <Integer> billNumbers = new ArrayList<Integer>();
			
			        			if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
			        			{
			        				sql = "SELECT "
			    							+ "bill_number "
			    							+ "FROM "
			    							+ "crusher_rmc_billinfo "
			    							+ "WHERE "
			    							+ "bill_type = 'TAX-INVOICE' "
			    							+ "AND "
			    							+ "bill_date >= '2024-04-01' "
			    							+ "AND crusher_id = ? "
			    						    + "AND crusher_code = ?";
			        				
			        				
			        				
			        			}else
			        			{
			        			
									sql = "SELECT "
											+ "bill_number "
											+ "FROM "
											+ "crusher_rmc_billinfo "
											+ "WHERE "
											+ "bill_type <> 'TAX-INVOICE' "
											+ "AND "
											+ "bill_date >= '2024-04-01' "
											+ "AND crusher_id = ? "
			    						    + "AND crusher_code = ?";
			        				
								}
								
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crusherId); 
							preparedStatement.setString(2, crusherCode); 

						//	System.out.print(preparedStatement.toString());
							
							resultSet = preparedStatement.executeQuery();
							int newBillNumber = 0;
							while(resultSet.next())
							{
								billNumbers.add(Integer.parseInt(resultSet.getString(1).split("-")[1]));						
							}
							
							
							 Collections.sort(billNumbers);
							 
							 
								/*
								 * System.out.println("Actual : "+billNumbers.get(billNumbers.size()-1));
								 */
							if(billNumbers.size() > 0)
							{
								
								
								 
							//	 System.out.println(billNumbers.size());
								 
								 newBillNumber = billNumbers.get(billNumbers.size()-1);
								 
							
								/*try{
									
								 billNum = resultSet.getString(1).split("-")[1];
								}catch (Exception e) {
									e.printStackTrace();
									billNum = resultSet.getString(1);
								}
								
								newBillNumber = Integer.parseInt(billNum);
								*/
								
								this.getBillInfoDAO().setBillNumber("RMC"+fy+"-"+(newBillNumber+1));
							}
							else
							{
								newBillNumber = 1;
								this.getBillInfoDAO().setBillNumber("RMC"+fy+"-"+(newBillNumber));
							
								
							}
				}
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		
        		
	        	if(getReturnAmount() == null || getReturnAmount().equals(""))
	        	{
	        		
	        		float amountPaid = 0.0F;
	        		try
	        		{
	        			amountPaid =this.getAmountPaid();
	        			
	        			
	        			this.setReturnAmount(""+(floatTotalAmtAfterDiscount-amountPaid));
	        		}
	        		catch(Exception e)
	        		{}
	        		
	        	}
	        	int countBillInfoInserted = 0;
	        	int countBillInfoUpdated = 0;
	        	
	        	int vehicleDetailsInserted = 0;
	        	int vehicleDetailsUpdated = 0;
	        	
	        	String vehicleOwnerName = "";
				String ownerMobileNumber = "";
				String vehicleDriverName = "";
				String driverMobileNumber = "";
				
	        	float transportChargeFloat = 0.0F;
	        	

        		String user = (String) this.getSessionMap().get("userFullName");
	        	String shortName = "";
	        	String [] customerDetails = new String[5];
				String customerId = "";
				String customerName = "";
				
				try
				{
					customerDetails = this.getCustomerName().split("-");
					customerId = customerDetails[0];
					customerName = customerDetails[1];
					
				}catch(Exception e)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCustomerIdAndName"));
				}
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
	        	if(!this.getBillInfoDAO().isBillInformationInserted())
	        	{
	        		
	        		
	        		
	        		try{
	        			transportChargeFloat = this.getBillInfoDAO().getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		
	        	sql = "INSERT INTO "
	        			+ "crusher_rmc_billinfo"
	        			+ "( "
	        			+ "bill_number,"	        			
	        			+ "crusher_id,"
	        			+ "crusher_code,"
	        			+ "bill_time,"
	        			+ "bill_date,"
	        			+ "payment_type,"
	        			+ "bill_type,"
	        			+ "customer_name,"
	        			+ "transport_charges,"
	        			+ "comments,"
	        			+ "bill_total_amount,"
	        			+ "bill_amount_received,"
	        			+ "amount_return,"
	        			+ "customer_id, "
	        			+ "billed_by,"
	        			+ "chalan_number,"
	        			+ "vehicle_id,"
	        			+ "discount_type,"
	        			+ "pumpAmount,"
	        			+ "labourAmount) "
    					+ "VALUES "
    					+ "(?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	String [] custNameDetails= this.getBillInfoDAO().getCustomerName().split("-");
	        	ownerMessageCustName = custNameDetails[1]+"-"+custNameDetails[2];
	        	
	        	preparedStatement.setString(1,this.getBillInfoDAO().getBillNumber());
	        	preparedStatement.setString(2,crusherId);
	        	preparedStatement.setString(3,crusherCode);
	           	preparedStatement.setTime(4, time);
	        	preparedStatement.setString(5,this.getBillInfoDAO().getBillDate());
	        	preparedStatement.setString(6,this.getBillInfoDAO().getPaymentType());
	        	preparedStatement.setString(7,this.getBillInfoDAO().getBillType());
	        	preparedStatement.setString(8,this.getBillInfoDAO().getCustomerName());
	        	preparedStatement.setFloat(9,this.getBillInfoDAO().getTransportCharge());
	        	preparedStatement.setString(10,this.getBillInfoDAO().getComments());
	        	preparedStatement.setString(11,""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()+this.getBillInfoDAO().getPumpAmount()+this.getBillInfoDAO().getLabourAmount()));
	        	preparedStatement.setFloat(12,this.getAmountPaid());
	        	preparedStatement.setString(13,this.getReturnAmount());
	        	preparedStatement.setString(14,custId);
	        	preparedStatement.setString(15,billedBy);
	        	preparedStatement.setString(16, this.getBillInfoDAO().getChalanNumber());
	        	preparedStatement.setString(17, this.getBillVehicleInfoDAO().getVehicleId());
	        	preparedStatement.setString(18, this.getBillInfoDAO().getDiscountType());
	        	preparedStatement.setFloat(19, this.getBillInfoDAO().getPumpAmount());
	        	preparedStatement.setFloat(20, this.getBillInfoDAO().getLabourAmount());
	        	
	        	countBillInfoInserted = preparedStatement.executeUpdate();
	        	
					        	
				
					        
				    			
				    			if(preparedStatement != null)
				    			{
				    				preparedStatement.close();
				    				preparedStatement = null;
				    				
				    			}
				    			
				    			
				
								sql = "SELECT "
										+ "trip_id "
										+ "FROM "
										+ "crusher_rmc_vehicle_trip_master "
										+ "WHERE "
								        + "crusher_id = ? "
								        + "AND crusher_code = ? "
								        + "ORDER BY "
										+ "trip_id "
										+ "DESC LIMIT 1;";
								
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crusherId); 
							preparedStatement.setString(2, crusherCode); 

							resultSet = preparedStatement.executeQuery();
						
							int newTripId = 0;
							if(resultSet.next())
							{
								if(!(resultSet.getString(1) == null))
								{
									newTripId = Integer.parseInt(resultSet.getString(1));
									
									
									newTripId= newTripId+1;
								}
								else
								{
									newTripId =1;
									
								}
							}
							else
							{	
								newTripId =1;						
							}
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							
							
						
							
						
							
								
							
							sql = "SELECT "
									+ "vehicle_make,"
									+ "vehicle_registration_number,"
									+ "owner_name,"
									+ "owner_mobile_number,"
									+ "driver_name,"
									+ "driver_mobile_number "
									+ "FROM "
									+ "crusher_vehicle_details_master "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND crusher_id = ? "
	    						    + "AND crusher_code = ?";
							
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, this.getBillVehicleInfoDAO().getVehicleId());
							preparedStatement.setString(2, crusherId); 
							preparedStatement.setString(3, crusherCode); 

							resultSet = preparedStatement.executeQuery();
							
							if(resultSet.next())
							{
								ownerMessageVehicleMake = resultSet.getString(1);
								ownerMessageVehicleNumber = resultSet.getString(2);
								vehicleOwnerName = resultSet.getString(3);
								ownerMobileNumber = resultSet.getString(4);
								vehicleDriverName = resultSet.getString(5);
								driverMobileNumber = resultSet.getString(6);
							}
									
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
								int rowAdded = 0;
								
								sql = "INSERT "
										+ "INTO "
										+ "crusher_rmc_vehicle_trip_master "
										+ "("
										+ "trip_id,"
										+ "crusher_id,"
										+ "crusher_code,"
										+ "trip_date,"
										+ "bill_number,"
										+ "trip_vehicle_id,"
										+ "customer_id,"
										+ "customer_name,"
										+ "material_name,"
										+ "material_volume,"
										+ "vehicle_km_start,"
										+ "vehicle_km_end,"
										+ "trip_total_km,"
										+ "trip_from,"
										+ "trip_to,"
										+ "total_trips,"
										+ "vehicle_diesel_quantity,"
										+ "vehicle_diesel_amount,"
										+ "total_transportataion_charges,"
										+ "trip_entry_by,"
										+ "maintenance_amount,"
										+ "maintenance_description,"
										+ "trip_driver_name,"
										+ "trip_driver_mobile_number,"
										+ "bill_type) "
										+ "VALUES "
										+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setInt(1, newTripId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								preparedStatement.setString(4, this.getBillInfoDAO().getBillDate());
								preparedStatement.setString(5,this.getBillInfoDAO().getBillNumber());
								preparedStatement.setString(6, this.getBillVehicleInfoDAO().getVehicleId());
								preparedStatement.setString(7, customerId);
								preparedStatement.setString(8, customerName);
								preparedStatement.setString(9, materialNameForTripEntry);
								preparedStatement.setFloat(10, materialQuantityForTripEntry);
								preparedStatement.setFloat(11, this.getBillVehicleInfoDAO().getKmStart());
								preparedStatement.setFloat(12, this.getBillVehicleInfoDAO().getKmEnd());
								preparedStatement.setFloat(13, this.getBillVehicleInfoDAO().getTotalKM());
								preparedStatement.setString(14, this.getBillVehicleInfoDAO().getTripFrom());
								preparedStatement.setString(15, this.getBillVehicleInfoDAO().getTripTo());
								preparedStatement.setFloat(16, this.getBillVehicleInfoDAO().getTotalTrips());
								preparedStatement.setFloat(17, 0.0F);
								preparedStatement.setFloat(18, 0.0F);
								preparedStatement.setFloat(19, this.getBillInfoDAO().getTransportCharge());
								preparedStatement.setString(20, shortName);
								preparedStatement.setFloat(21, 0.0F);
								preparedStatement.setString(22, "NA");
								preparedStatement.setString(23, vehicleDriverName);
								preparedStatement.setString(24, driverMobileNumber);
								preparedStatement.setString(25, this.getBillInfoDAO().getBillType());
								vehicleDetailsInserted = preparedStatement.executeUpdate();
								
	        	
	        	}
	        	else
	        	{

	        		try{
	        			transportChargeFloat = this.getBillInfoDAO().getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		sql = "UPDATE "
	        				+ "crusher_rmc_billinfo "
	        				+ "SET "
	        				+ "bill_time=?,"
		        			+ "bill_date=STR_TO_DATE(?,'%d-%m-%Y'),"
		        			+ "payment_type=?,"
		        			+ "bill_type=?,"
		        			+ "customer_name=?,"
		        			+ "transport_charges=?,"
		        			+ "pumpAmount = ? ,"
		        			+ "labourAmount = ?,"
		        			+ "comments=?,"
		        			+ "bill_total_amount=?,"
		        			+ "bill_amount_received=?,"
		        			+ "amount_return=?,"
		        			+ "chalan_number=?,"
		        			+ "vehicle_id = ?,"		        			        			
		        			+ "discount_type=? "		        			        			
								 
								  
		        			+ "WHERE "
		        			+ "bill_number = ? "
		        			+ "AND "
		        			+ "customer_id = ? "
		        			+ "AND "
		        			+ "bill_type = ? "
		        			+ "AND crusher_id = ? "
		        		    + "AND crusher_code = ?";
	        		
	        		preparedStatement = connection.prepareStatement(sql);  	
		        	
		        	
		        	preparedStatement.setTime(1, time);
		        	preparedStatement.setString(2, this.getBillInfoDAO().getBillDate());
		        	preparedStatement.setString(3,this.getBillInfoDAO().getPaymentType());
		        	preparedStatement.setString(4,this.getBillInfoDAO().getBillType());
		        	preparedStatement.setString(5,this.getBillInfoDAO().getCustomerName());
		        	preparedStatement.setFloat(6,this.getBillInfoDAO().getTransportCharge());
		        	preparedStatement.setFloat(7, this.getBillInfoDAO().getPumpAmount());
		        	preparedStatement.setFloat(8, this.getBillInfoDAO().getLabourAmount());
		        	preparedStatement.setString(9,this.getBillInfoDAO().getComments());
		        	preparedStatement.setString(10,""+(floatTotalAmtAfterDiscount
		        			+this.getBillInfoDAO().getTransportCharge()
		        			+this.getBillInfoDAO().getPumpAmount()
		        			+this.getBillInfoDAO().getLabourAmount()));

		        	preparedStatement.setFloat(11,this.getAmountPaid());
		        	preparedStatement.setString(12,this.getReturnAmount());
		        	preparedStatement.setString(13, this.getBillInfoDAO().getChalanNumber());
		        	preparedStatement.setString(14, this.getBillVehicleInfoDAO().getVehicleId());
		        	preparedStatement.setString(15,this.getBillInfoDAO().getDiscountType());
																				 
																				   
		        	preparedStatement.setString(16,this.getBillInfoDAO().getBillNumber());
		        	preparedStatement.setString(17,custId);   
		        	preparedStatement.setString(18, this.getBillInfoDAO().getBillType());
		        	preparedStatement.setString(19, crusherId);
		        	preparedStatement.setString(20, crusherCode); 

		        	countBillInfoUpdated = preparedStatement.executeUpdate();
		        	
		        	

					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					
					
					sql = "UPDATE "
							+ "crusher_rmc_vehicle_trip_master "
							+ "SET "
							+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y'), "
							+ "trip_vehicle_id=?, "
							+ "material_name = ?, "
							+ "material_volume = ?, "
							+ "vehicle_km_start = ?, "
							+ "vehicle_km_end = ?,"
							+ "trip_total_km = ?,"
							+ "trip_from = ?,"
							+ "trip_to = ?, "
							+ "total_trips = ? ,"
							+ "total_transportataion_charges = ?, "							
							+ "trip_entry_by = ?, "
							+ "maintenance_amount = ?, "
							+ "maintenance_description = ?, "
							+ "trip_driver_name = ?, "
							+ "trip_driver_mobile_number = ? "
							+ "WHERE "
							+ "bill_number = ? "
							+ "AND "
							+ "bill_type = ? "
							+ "AND crusher_id = ? "
		        		    + "AND crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, this.getBillInfoDAO().getBillDate());
					preparedStatement.setString(2, this.getBillVehicleInfoDAO().getVehicleId());
					preparedStatement.setString(3, materialNameForTripEntry);
					preparedStatement.setFloat(4, materialQuantityForTripEntry);
					preparedStatement.setFloat(5, this.getBillVehicleInfoDAO().getKmStart());
					preparedStatement.setFloat(6, this.getBillVehicleInfoDAO().getKmEnd());
					preparedStatement.setFloat(7, this.getBillVehicleInfoDAO().getTotalKM());
					preparedStatement.setString(8, this.getBillVehicleInfoDAO().getTripFrom());
					preparedStatement.setString(9, this.getBillVehicleInfoDAO().getTripTo());
					preparedStatement.setInt(10, this.getBillVehicleInfoDAO().getTotalTrips());
					preparedStatement.setFloat(11, this.getBillInfoDAO().getTransportCharge());
					preparedStatement.setString(12, shortName);
					preparedStatement.setFloat(13, 0.0F);
					preparedStatement.setString(14, "NA");
					preparedStatement.setString(15, vehicleDriverName);
					preparedStatement.setString(16, driverMobileNumber);
					preparedStatement.setString(17, this.getBillInfoDAO().getBillNumber());
					preparedStatement.setString(18, this.getBillInfoDAO().getBillType());
					preparedStatement.setString(19, crusherId);
		        	preparedStatement.setString(20, crusherCode); 

					vehicleDetailsUpdated=preparedStatement.executeUpdate();
		        	
	        		
	        	}
	        	
	        	
	        	
	        	if((countBillInfoInserted>0 || countBillInfoUpdated > 0) && (vehicleDetailsInserted >0 || vehicleDetailsUpdated >0))
	        	{
	        		
	        		
	        		if(preparedStatement != null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
	        		sql = "SELECT "
	        				+ "bill_product_entry_id "
	        				+ "FROM "
	        				+ "crusher_rmc_productbillinfo "
	        				+ "WHERE "
	        				+ "bill_number = ? "
	        				+ "AND "
	        				+ "bill_type = ? "
	        				+ "AND crusher_id = ? "
	        		        + "AND crusher_code = ?";
	        		
	        		
	        		preparedStatement = connection.prepareStatement(sql);
	        		preparedStatement.setString(1, this.getBillNumber());
	        		preparedStatement.setString(2, this.getBillType());
	        		preparedStatement.setString(3, crusherId); 
	        		preparedStatement.setString(4, crusherCode); 

	        		resultSet = preparedStatement.executeQuery();
	        		
	        		resultSet.last();
	        		int rowCount = resultSet.getRow();
	        		resultSet.beforeFirst();
	        		
	        		
	        		if(rowCount > 0)
	        		{
	        			if(preparedStatement != null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
	        			
	        			sql = "DELETE FROM crusher_rmc_productbillinfo WHERE bill_number = ? "
	        					+ "AND "
	        					+ "bill_type = ? "
	        					+ "AND crusher_id = ? "
		        		        + "AND crusher_code = ?";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			preparedStatement.setString(1, this.getBillNumber());
		        		preparedStatement.setString(2, this.getBillType());
		        		preparedStatement.setString(3, crusherId); 
		        		preparedStatement.setString(4, crusherCode); 

	        			preparedStatement.executeUpdate(); 	        			
	        			
	        		
		   
	        		if(preparedStatement != null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		   
        			
        			
        			sql = "SELECT "
        					+ "10mm,"
        					+ "20mm,"
        					+ "crushsand,"
        					+ "washsand,"
        					+ "water,"
        					+ "addmixture,"
        					+ "cementopc,"
        					+ "cementppc "
        					+ "FROM "
        					+ "rmc_bill_ingredients_used_details_master "
        					+ "WHERE rmc_bill_number = ? "
        					+ "AND "
        					+ "bill_type = ? "
        					+ "AND crusher_id = ? "
	        		        + "AND crusher_code = ?";
        			
        			
        			

        			preparedStatement = connection.prepareStatement(sql);
        			preparedStatement.setString(1, this.getBillNumber());
	        		preparedStatement.setString(2, this.getBillType());
	        		preparedStatement.setString(3, crusherId); 
	        		preparedStatement.setString(4, crusherCode); 

        			ResultSet getRMCIngreQtyRS = preparedStatement.executeQuery();
        			
        			boolean stockAdded = false;
        			
        			HashMap<String,String> productMappList = GetListResource.getRMCIngreProductMappList(this.getSessionMap(), connection);
        			
        			
        			String tenmmProductIdName = productMappList.get("tenmm");
        			String twentymmProdcutIdName = productMappList.get("twentymm");
        			String crushsandProdcutIdName = productMappList.get("crushsand");
        			String washsandProductIdName = productMappList.get("washsand");
        			
        			String waterProductIdName = productMappList.get("water");
        			String addMixtureProductIdName = productMappList.get("addmixture");
	        		
        			String cementOPCProductIdName = productMappList.get("cementOPC");
        			String cementPPCProductIdName = productMappList.get("cementPPC");
        			
        			
        			if(getRMCIngreQtyRS.next())
        			{
        				stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), tenmmProductIdName.split("#")[0], tenmmProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(1));
			           if(stockAdded)
        				{
        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), twentymmProdcutIdName.split("#")[0], twentymmProdcutIdName.split("#")[1], getRMCIngreQtyRS.getFloat(2));
        				}
        				if(stockAdded)
        				{
        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), crushsandProdcutIdName.split("#")[0], crushsandProdcutIdName.split("#")[1], getRMCIngreQtyRS.getFloat(3));
        				}
        				
        				if(stockAdded)
        				{
        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), washsandProductIdName.split("#")[0], washsandProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(4));
        				}
        				
        				if(stockAdded)
        				{
        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), waterProductIdName.split("#")[0], waterProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(5));
        				}
        				if(stockAdded)
        				{
        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), addMixtureProductIdName.split("#")[0], addMixtureProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(6));
        				}
        				if(stockAdded)
        				{
        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), cementOPCProductIdName.split("#")[0], cementOPCProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(7));
        				}
        				if(stockAdded)
        				{
        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), cementPPCProductIdName.split("#")[0], cementPPCProductIdName.split("#")[1], getRMCIngreQtyRS.getFloat(8));
        				}
	        			
        			}
        			
		
        			int rmcIngreProdDeleted = 0;
			   
					
        			if(preparedStatement != null)
        			{
        				preparedStatement.close();
        				preparedStatement = null;
        			}
        			
        			if(stockAdded)
        			{
	        			sql = "DELETE FROM rmc_bill_ingredients_used_details_master WHERE rmc_bill_number = ? "
	        					+ "AND "
	        					+ "bill_type = ? "
	        					+ "AND crusher_id = ? "
		        		        + "AND crusher_code = ?";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
																			  
																		   
																   
																				
																		
																 
																 
	        			preparedStatement.setString(1, this.getBillNumber());
		        		preparedStatement.setString(2, this.getBillType());
		        		preparedStatement.setString(3, crusherId); 
		        		preparedStatement.setString(4, crusherCode); 

		        		rmcIngreProdDeleted = preparedStatement.executeUpdate(); 	
        			
        			}
        		
        			
	        	}												   
        			
        		
        		
	        		
	        			int productInserted = 0;
	        			int listSize = this.getProductInfoList().size();
	        			
	        			if(this.getProductInfoList().size() == 1)
	        			{
	        				for(BillProductInfoDAO productInfoDAO : this.getProductInfoList())
	        			
	        			{
	        				if(preparedStatement != null)
	    	        		{
	    	        			preparedStatement.close();
	    	        			preparedStatement = null;
	    	        		}
	        				
	        				DecimalFormat df= new DecimalFormat("##.##");
	        				ownerMessageProductName = productInfoDAO.getProductName();
	        				ownerMessageProductQty =  df.format(productInfoDAO.getQuantity());
	        				ownerMessageProductRate = df.format(productInfoDAO.getSalesRate());
	        				
	        				
	        				
	        			String marLine = productInfoDAO.getProductNameMarathi()+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			String s =	ownerMessageProductName+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			if(listSize==1)
	        			{
	        				messageProductDetailsLine = messageProductDetailsLine + s;        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine;
	        			}else
	        			{
		        			messageProductDetailsLine = messageProductDetailsLine + s + "\n";        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine + "\n";
	        			}
	        			
	        			
	        			sql = "INSERT INTO crusher_rmc_productbillinfo "
	        					+ "("
	        					+ "bill_number,"
	        					+ "crusher_id,"
	        					+ "crusher_code,"
	        					+ "product_id,"
	        					+ "product_name,"
	        					+ "sales_unit,"
	        					+ "tax_percentage,"
	        					+ "sales_rate,"
	        					+ "quanity,"
	        					+ "discount_percentage,"
	        					+ "discount_rupees,"
	        					+ "product_amount,"
	        					+ "product_amt_after_discount,"
	        					+ "gross_amount,"
	        					+ "igst,"
	        					+ "cgst,"
	        					+ "sgst,"
	        					+ "product_name_marathi,"
	        					+ "bill_type,"
	        					+ "rate_type) "
	        					+ "values "
	        					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, this.getBillInfoDAO().getBillNumber());
	        			preparedStatement.setString(2, crusherId);
	        			preparedStatement.setString(3, crusherCode);
	        			preparedStatement.setString(4, productInfoDAO.getProductId());
	        			preparedStatement.setString(5, productInfoDAO.getProductName());
	        			preparedStatement.setString(6, productInfoDAO.getSalesUnit());
	        			preparedStatement.setString(7, productInfoDAO.getTaxId());
	        			preparedStatement.setFloat(8, productInfoDAO.getSalesRate());
	        			preparedStatement.setFloat(9, productInfoDAO.getQuantity());
	        			preparedStatement.setFloat(10, productInfoDAO.getDiscountPecentage());
	        			preparedStatement.setFloat(11, productInfoDAO.getDiscountRupees());
	        			preparedStatement.setFloat(12, productInfoDAO.getAmount());
	        			preparedStatement.setFloat(13, productInfoDAO.getAmountAfterDiscount());
	        			preparedStatement.setFloat(14, productInfoDAO.getGrossAmount());
	        			preparedStatement.setFloat(15, productInfoDAO.getIgst());
	        			preparedStatement.setFloat(16, productInfoDAO.getCgst());
	        			preparedStatement.setFloat(17, productInfoDAO.getSgst());
	        			preparedStatement.setString(18, productInfoDAO.getProductNameMarathi());
	        			preparedStatement.setString(19, this.getBillInfoDAO().getBillType());
	        			preparedStatement.setString(20, productInfoDAO.getRateType());
	        			
	        			
	        			productInserted = productInserted +  preparedStatement.executeUpdate();
	        			
	        			ownerMessageProductNameMarathi = productInfoDAO.getProductNameMarathi();
	        			
	        			listSize--;
	        			
	        			
	        			HashMap<String,String> productMappList = GetListResource.getRMCIngreProductMappList(this.getSessionMap(), connection);
	        			
	        			/*for(String key:productMappList.keySet())
	        			{
	        				System.out.println("Key : "+key+","+productMappList.get(key));
	        			}*/
	        			
	        			String tenmmProductIdName = productMappList.get("tenmm");
	        			
	        			String twentymmProdcutIdName = productMappList.get("twentymm");
	        			String crushsandProdcutIdName = productMappList.get("crushsand");
	        			String washsandProductIdName = productMappList.get("washsand");
	        			
	        			String waterProductIdName = productMappList.get("water");
	        			String addMixtureProductIdName = productMappList.get("addmixture");				        		
	        			String cementOPCProductIdName = productMappList.get("cementOPC");
	        			String cementPPCProductIdName = productMappList.get("cementPPC");
	        			
	        			//System.out.println(tenmmProductIdName.split("#")[0]);
	        			//System.out.println(tenmmProductIdName.split("#")[1]);
	        			boolean stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), tenmmProductIdName.split("#")[0], tenmmProductIdName.split("#")[1], productInfoDAO.getTenmm());
		        				
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), twentymmProdcutIdName.split("#")[0], twentymmProdcutIdName.split("#")[1], productInfoDAO.getTwentymm());
		        				}
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), crushsandProdcutIdName.split("#")[0], crushsandProdcutIdName.split("#")[1], productInfoDAO.getCrushsand());
		        				}
		        				
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), washsandProductIdName.split("#")[0], washsandProductIdName.split("#")[1], productInfoDAO.getWashsand());
		        				}
		        				
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), waterProductIdName.split("#")[0], waterProductIdName.split("#")[1], productInfoDAO.getWater());
		        				}
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), addMixtureProductIdName.split("#")[0], addMixtureProductIdName.split("#")[1], productInfoDAO.getAddmixture());
		        				}
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), cementOPCProductIdName.split("#")[0], cementOPCProductIdName.split("#")[1], productInfoDAO.getCementOPC());
		        				}
		        				if(stockMinus)
		        				{
		        					stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), cementPPCProductIdName.split("#")[0], cementPPCProductIdName.split("#")[1], productInfoDAO.getCementPPC());
		        				}
		        				
		        				
		        		  
		        				
		        				sql = "INSERT INTO "
		        						+ "rmc_bill_ingredients_used_details_master "
		        						+ "("
		        						+ "crusher_id,"
		        						+ "crusher_code,"
		        						+ "rmc_bill_number,"
		        						+ "entry_date,"
		        						+ "entry_time,"
		        						+ "10mm,"
		        						+ "20mm,"
		        						+ "crushsand,"
		        						+ "washsand,"
		        						+ "water,"
		        						+ "addmixture,"
		        						+ "cementopc,"
		        						+ "cementppc,"
		        						+ "bill_type) "
		        						+ "VALUES "
		        						+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?)";
		        				
		        				PreparedStatement addUsedQtyRmcProPSMT = connection.prepareStatement(sql);
		        				
		        				addUsedQtyRmcProPSMT.setString(1, crusherId);
		        				addUsedQtyRmcProPSMT.setString(2, crusherCode);
		        				addUsedQtyRmcProPSMT.setString(3, this.getBillInfoDAO().getBillNumber());
		        				addUsedQtyRmcProPSMT.setString(4, billDateTime);
		        				addUsedQtyRmcProPSMT.setTime(5, time);
		        				addUsedQtyRmcProPSMT.setFloat(6, productInfoDAO.getTenmm());
		        				addUsedQtyRmcProPSMT.setFloat(7, productInfoDAO.getTwentymm());
		        				addUsedQtyRmcProPSMT.setFloat(8, productInfoDAO.getCrushsand());
		        				addUsedQtyRmcProPSMT.setFloat(9, productInfoDAO.getWashsand());
		        				addUsedQtyRmcProPSMT.setFloat(10, productInfoDAO.getWater());
		        				addUsedQtyRmcProPSMT.setFloat(11, productInfoDAO.getAddmixture());
		        				addUsedQtyRmcProPSMT.setFloat(12, productInfoDAO.getCementOPC());
		        				addUsedQtyRmcProPSMT.setFloat(13, productInfoDAO.getCementPPC());
		        				addUsedQtyRmcProPSMT.setString(14, this.getBillInfoDAO().getBillType());
		        				
		        				//System.out.println(addUsedQtyRmcProPSMT.toString());
		        				
		        				int addUsedQty = addUsedQtyRmcProPSMT.executeUpdate();
		        				
	        			
    			
	        			}
	        				
	        			}
	        			
	        			
	        			
	        			if(productInserted == this.getProductInfoList().size())
	        			{
	        				if(countBillInfoInserted > 0)
	        				{
	        					this.getBillInfoDAO().setBillInformationInserted(true);
	        				}
	        				
	        				
	    	        		this.getBillInfoDAO().setBillSaved(true);
	    	        		this.setBillSaved(true);
	    	        		this.setBillDateTime(this.getBillInfoDAO().getBillDate());
	    	        		this.setCustomerName(this.getBillInfoDAO().getCustomerName());
	    	        		this.setBillNumber(this.getBillInfoDAO().getBillNumber());
	    	        		this.setBillType(this.getBillInfoDAO().getBillType());
	    	        		this.setAlternateMobileNumber(this.getBillInfoDAO().getCustomerMobile());
	    	        		this.setSendSMS(this.getBillInfoDAO().isSendSMS());
	    	        		this.setTotalAmount(""+(floatTotalAmount+this.getBillInfoDAO().getTransportCharge()+this.getBillInfoDAO().getPumpAmount() +  this.getBillInfoDAO().getLabourAmount()));	        	
	    	        		this.setTotalDiscount(""+(floatTotalDiscount+this.getBillInfoDAO().getTransportCharge()));
	    	        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge() +this.getBillInfoDAO().getPumpAmount() +  this.getBillInfoDAO().getLabourAmount()));
	    		        	
	    	        		paymentTypeList.put("CASH","CASH");
	    		        	paymentTypeList.put("CREDIT","CREDIT");
	    		        	
	    		        	this.setDefaultValue(this.getBillInfoDAO().getPaymentType());
	    		        	

	    		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
	    		        	
	    		        	unitList = GetListResource.GetUnitList();
	    		        	billTypeList = GetListResource.GetBillTypeList();
	    		        	
	    		        	
	    	        		addActionMessage("RMC "+this.getText("message.success.billDetailsSavedSuccessfully"));
	    	        		
	    	        		this.getSessionMap().put("RMCBillInformation", this.getBillInfoDAO());
	    	        		this.getSessionMap().put("RMCProductList", this.getProductInfoList());
	    	        		
	    	        		
	    	        		
							sql = "SELECT "
									+ "account1_credit_debit_id,"
		  							+ "account2_credit_debit_id "
		  							+ "FROM "
		  							+ "crusher_rmc_billinfo "
		  							+ "WHERE "
				        			+ "bill_number = ? "
				        			+ "AND "
				        			+ "bill_type = ? "
				        			+ "AND "
				        			+ "customer_id = ? "
				        			+ "AND "
				        			+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
							
							preparedStatement = connection.prepareStatement(sql);
						
							preparedStatement.setString(1,this.getBillInfoDAO().getBillNumber());
							preparedStatement.setString(2,this.getBillInfoDAO().getBillType());
				        	preparedStatement.setString(3,custId);   
				        	preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							
							if(resultSet.next()){
								String acc1CrditDebitId = resultSet.getString(1);
								String acc2CrditDebitId = resultSet.getString(2);
								
								
								if(acc1CrditDebitId != null && !acc1CrditDebitId.equals("") )
								{
								
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
										
								sql = "SELECT "
										+ "entry_id,"
										+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, acc1CrditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);

								
								resultSet = preparedStatement.executeQuery();
								
								int m = 0;
								if(resultSet.next())
								{
									
									PreparedStatement  insertIntoDeletedPSMT = null;
									
									String inertDeletedSQL = "INSERT "
											+ "INTO "
											+ "bank_account_credit_debit_updated_entry_master "
											+ "("
											+ "entry_id,"
											+ "crusher_id,"
											+ "crusher_code,"
											+ "account_id,"
											+ "account_number,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "amount,"
											+ "payment_type,"
											+ "entry_by,"
											+ "entry_details,"
											+ "old_amount,"
											+ "updated_date,"
											+ "updated_time) "
											+ "VALUES "
											+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
									
									insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
									
									insertIntoDeletedPSMT.setString(1, acc1CrditDebitId);
									insertIntoDeletedPSMT.setString(2, crusherId);
									insertIntoDeletedPSMT.setString(3, crusherCode);
									insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
									insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
									insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
									insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
									insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
									insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
									insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
									insertIntoDeletedPSMT.setString(11, billedBy);
									insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
									insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
									insertIntoDeletedPSMT.setString(14, this.getBillInfoDAO().getBillDate());
									insertIntoDeletedPSMT.setTime(15,time);
									
									
									  m = insertIntoDeletedPSMT.executeUpdate();
									  
									  String paymentType = resultSet.getString(6);
									  
									  
									  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
										Date parsedDate = null;

										try {
										    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
										} catch (ParseException e) {
										    e.printStackTrace();  
										}

										if (parsedDate != null) {
										     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
										    String formattedDate = outputDateFormat.format(parsedDate); 
							
										    
									 
									    
									    
									  boolean isCloseingBalMaintained = false;
									  
									  if (paymentType.equals("CREDIT")) {
									   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
									  }else {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
										  
									  }
										}
									  
									if(insertIntoDeletedPSMT != null)
									{
										insertIntoDeletedPSMT.close();
										insertIntoDeletedPSMT = null;
									}
									
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
								
								if(m>0)
								{
									
									
								
								sql = "DELETE "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, acc1CrditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								int k = preparedStatement.executeUpdate();
								
								
								if(k > 0 )

								{
									
									sql = "UPDATE "
            	        					+ "crusher_rmc_billinfo "
            	        					+ "SET "
            	        					+ "account1_credit_debit_id = ? "
            	        					+ "WHERE "
            			        			+ "bill_number = ? "
            			        			+ "AND "
            			        			+ "bill_type = ? "
            			        			+ "AND "
            			        			+ "customer_id = ? "
            			        			+ "AND "
            			        			+ "crusher_id = ? "
            								+ "AND "
            								+ "crusher_code = ?";
            	        			
            	        			
    	    						preparedStatement = connection.prepareStatement(sql);
    	    						
    	    						preparedStatement.setString(1, null);
    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
    	    						preparedStatement.setString(3,this.getBillInfoDAO().getBillType());
    	    			        	preparedStatement.setString(4,custId);   
    	    			        	preparedStatement.setString(5, crusherId);
    	    						preparedStatement.setString(6, crusherCode);
    	    						
    	    						 preparedStatement.executeUpdate();
    	        				
    	    						
    	    						
    	    						
									
								}
				    		}
							}
								
								if(acc2CrditDebitId != null && !acc2CrditDebitId.equals("") )
								{
								
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
										
								sql = "SELECT "
										+ "entry_id,"
										+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, acc2CrditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);

								
								resultSet = preparedStatement.executeQuery();
								
								int m = 0;
								if(resultSet.next())
								{
									
									PreparedStatement  insertIntoDeletedPSMT = null;
									
									String inertDeletedSQL = "INSERT "
											+ "INTO "
											+ "bank_account_credit_debit_updated_entry_master "
											+ "("
											+ "entry_id,"
											+ "crusher_id,"
											+ "crusher_code,"
											+ "account_id,"
											+ "account_number,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "amount,"
											+ "payment_type,"
											+ "entry_by,"
											+ "entry_details,"
											+ "old_amount,"
											+ "updated_date,"
											+ "updated_time) "
											+ "VALUES "
											+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
									
									insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
									
									insertIntoDeletedPSMT.setString(1, acc2CrditDebitId);
									insertIntoDeletedPSMT.setString(2, crusherId);
									insertIntoDeletedPSMT.setString(3, crusherCode);
									insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
									insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
									insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
									insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
									insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
									
									if(this.getAmountPaid2() == null || this.getAmountPaid2().equals(""))
									{
										insertIntoDeletedPSMT.setString(9, "0");
									}else {
										insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid2());
									}
									insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
									insertIntoDeletedPSMT.setString(11, billedBy);
									insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
									insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
									insertIntoDeletedPSMT.setString(14, this.getBillInfoDAO().getBillDate());
									insertIntoDeletedPSMT.setTime(15,time);
									
									
									  m = insertIntoDeletedPSMT.executeUpdate();
									  
									  String paymentType = resultSet.getString(6);
									  
									  
									  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
										Date parsedDate = null;

										try {
										    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
										} catch (ParseException e) {
										    e.printStackTrace();  
										}

										if (parsedDate != null) {
										     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
										    String formattedDate = outputDateFormat.format(parsedDate); 
							
										    
									 
									    
									    
									  boolean isCloseingBalMaintained = false;
									  
									  if (paymentType.equals("CREDIT")) {
									   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
									  }else {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
										  
									  }
										}
									  
									if(insertIntoDeletedPSMT != null)
									{
										insertIntoDeletedPSMT.close();
										insertIntoDeletedPSMT = null;
									}
									
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
								
								if(m>0)
								{
									
									
								
								sql = "DELETE "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, acc2CrditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								int k = preparedStatement.executeUpdate();
								
								
								if(k > 0 )

								{
									
									sql = "UPDATE "
            	        					+ "crusher_rmc_billinfo "
            	        					+ "SET "
            	        					+ "account2_credit_debit_id = ? "
            	        					+ "WHERE "
            			        			+ "bill_number = ? "
            			        			+ "AND "
            			        			+ "bill_type = ? "
            			        			+ "AND "
            			        			+ "customer_id = ? "
            			        			+ "AND "
            			        			+ "crusher_id = ? "
            								+ "AND "
            								+ "crusher_code = ?";
            	        			
            	        			
    	    						preparedStatement = connection.prepareStatement(sql);
    	    						
    	    						preparedStatement.setString(1, null);
    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
    	    						preparedStatement.setString(3,this.getBillInfoDAO().getBillType());
    	    			        	preparedStatement.setString(4,custId);   
    	    			        	preparedStatement.setString(5, crusherId);
    	    						preparedStatement.setString(6, crusherCode);
    	    						
    	    						preparedStatement.executeUpdate();
    	        				
    	    						
    	    						
    	    						
									
								}
				    		}
							}
							}
	    	        		
							int rowCreditDebitIdInsetred = 0;
			        		
						if(this.getAmountPaid()>0 )
						{
	    							if(preparedStatement != null)
	    							{
	    								preparedStatement.close();
	    								preparedStatement = null;
	    							}
	    							
	    							if(this.getAccountId1() != null && !this.getAccountId1().equals("") && this.getModeOfPayment1() != null && !this.getModeOfPayment1().equals(""))
	    				    		{	
	    							sql = "SELECT "
	    									+ "entry_id "
	    									+ "FROM "
	    									+ "bank_account_credit_debit_master "
	    									+ "WHERE "
	    							        + "crusher_id = ? "
	    							        + "AND crusher_code = ? "
	    									+ "ORDER BY "
	    									+ "entry_id "
	    									+ "DESC LIMIT 1;";
	    							
	    						
	    						preparedStatement = connection.prepareStatement(sql);
	    						preparedStatement.setString(1, crusherId); 
	    						preparedStatement.setString(2, crusherCode); 

	    						resultSet = preparedStatement.executeQuery();
	    						
	    						int entryId = 1;
	    					
	    						if(resultSet.next())
	    						{
	    							if(!(resultSet.getString(1) == null))
	    							{
	    								entryId = Integer.parseInt(resultSet.getString(1));
	    								entryId = entryId + 1;
	    								
	    							}
	    							
	    						}
	    						else
	    						{	entryId =1;
	    							
	    						}
	    						
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		String accountNumber = "";
	    		        		sql = "SELECT "
	    		        				+ "account_number "
	    		        				+ "FROM "
	    		        				+ "crusher_bank_account "
	    		        				+ "WHERE "
	    		        				+ "account_id  = ? "
	    		        				+ "AND "
	    		        			    + "crusher_id = ? "
	    		        			    + "AND crusher_code = ?";
	    		        			
	    		        		preparedStatement = connection.prepareStatement(sql);
	    		        		
	    		        		preparedStatement.setString(1, this.getAccountId1());
	    		        		preparedStatement.setString(2, crusherId); 
	    		        		preparedStatement.setString(3, crusherCode); 

	    		        		resultSet = preparedStatement.executeQuery();
	    		        		if(resultSet.next())
	    		        		{
	    		        			accountNumber = resultSet.getString(1);
	    		        		}
	    		        		
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		
	    							sql = "INSERT "
	    									+ "INTO "
	    									+ "bank_account_credit_debit_master "
	    									+ "("
	    									+ "entry_id,"
	    									+ "crusher_id,"
	    									+ "crusher_code,"
	    									+ "account_id,"
	    									+ "account_number,"
	    									+ "entry_date,"
	    									+ "entry_time,"
	    									+ "entry_type,"
	    									+ "amount,"
	    									+ "payment_type,"
	    									+ "entry_by,"
	    									+ "entry_details,"
	    									+ "entry_source) "
	    									+ "VALUES "
	    									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
	    							
	    							preparedStatement = connection.prepareStatement(sql);
	    							
	    							preparedStatement.setInt(1, entryId);
	    							preparedStatement.setString(2, crusherId);
	    							preparedStatement.setString(3, crusherCode);
	    							preparedStatement.setString(4, this.getAccountId1());
	    							preparedStatement.setString(5, accountNumber);
	    							preparedStatement.setString(6, this.getBillDateTime());
	    							preparedStatement.setTime(7, time);
	    							preparedStatement.setString(8, "CREDIT");
	    							preparedStatement.setFloat(9, this.getAmountPaid1());
	    							preparedStatement.setString(10, this.getModeOfPayment1());
	    							preparedStatement.setString(11, billedBy);
	    							preparedStatement.setString(12, "PAID BY "+customerName+" AGAINST BILL No: "+this.getBillInfoDAO().getBillNumber());
	    							preparedStatement.setString(13, "ADD RMC BILL ");
	    							
	    							int rowInsetred = preparedStatement.executeUpdate();
	    							
	    							
	    							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId1(),"CREDIT", this.getBillDateTime(), this.getAmountPaid1(), billedBy, connection, this.getSessionMap());
	    							
	    						
	    							
	    							if(rowInsetred > 0 && isCloseingBalMaintained)
	    							{
	    								
	    								sql = "UPDATE "
	            	        					+ "crusher_rmc_billinfo "
	            	        					+ "SET "
	            	        					+ "account1_credit_debit_id = ? "
	            	        					+ "WHERE "
	            			        			+ "bill_number = ? "
	            			        			+ "AND "
	            			        			+ "customer_id = ? "
	            			        			+ "AND "
	            			        			+ "bill_type = ? "
	            			        			+ "AND "
	            			        			+ "crusher_id = ? "
	            								+ "AND "
	            								+ "crusher_code = ?";
	            	        			
	            	        			
	    	    						preparedStatement = connection.prepareStatement(sql);
	    	    						
	    	    						preparedStatement.setInt(1, entryId);
	    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
	    	    			        	preparedStatement.setString(3,custId);   
	    	    			        	preparedStatement.setString(4, this.getBillInfoDAO().getBillType());
	    	    			        	preparedStatement.setString(5, crusherId);
	    	    						preparedStatement.setString(6, crusherCode);
	    	    						
	    	    						rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	    	        				
	    							}
	    				    		}
	    							
	    							
	    							if(this.getAccountId2() != null && !this.getAccountId2().equals("") && this.getModeOfPayment2() != null && !this.getModeOfPayment2().equals(""))
	    				    		{	
	    							sql = "SELECT "
	    									+ "entry_id "
	    									+ "FROM "
	    									+ "bank_account_credit_debit_master "
	    									+ "WHERE "
	    							        + "crusher_id = ? "
	    							        + "AND crusher_code = ? "
	    									+ "ORDER BY "
	    									+ "entry_id "
	    									+ "DESC LIMIT 1;";
	    							
	    						
	    						preparedStatement = connection.prepareStatement(sql);
	    						preparedStatement.setString(1, crusherId); 
	    						preparedStatement.setString(2, crusherCode); 

	    						resultSet = preparedStatement.executeQuery();
	    						
	    						int entryId = 1;
	    					
	    						if(resultSet.next())
	    						{
	    							if(!(resultSet.getString(1) == null))
	    							{
	    								entryId = Integer.parseInt(resultSet.getString(1));
	    								entryId = entryId + 1;
	    								
	    							}
	    							
	    						}
	    						else
	    						{	entryId =1;
	    							
	    						}
	    						
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		String accountNumber = "";
	    		        		sql = "SELECT "
	    		        				+ "account_number "
	    		        				+ "FROM "
	    		        				+ "crusher_bank_account "
	    		        				+ "WHERE "
	    		        				+ "account_id  = ? "
	    		        				+ "AND "
	    		        			    + "crusher_id = ? "
	    		        			    + "AND crusher_code = ?";
	    		        			
	    		        		preparedStatement = connection.prepareStatement(sql);
	    		        		
	    		        		preparedStatement.setString(1, this.getAccountId2());
	    		        		preparedStatement.setString(2, crusherId); 
	    		        		preparedStatement.setString(3, crusherCode); 

	    		        		resultSet = preparedStatement.executeQuery();
	    		        		if(resultSet.next())
	    		        		{
	    		        			accountNumber = resultSet.getString(1);
	    		        		}
	    		        		
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		
	    							sql = "INSERT "
	    									+ "INTO "
	    									+ "bank_account_credit_debit_master "
	    									+ "("
	    									+ "entry_id,"
	    									+ "crusher_id,"
	    									+ "crusher_code,"
	    									+ "account_id,"
	    									+ "account_number,"
	    									+ "entry_date,"
	    									+ "entry_time,"
	    									+ "entry_type,"
	    									+ "amount,"
	    									+ "payment_type,"
	    									+ "entry_by,"
	    									+ "entry_details,"
	    									+ "entry_source) "
	    									+ "VALUES "
	    									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
	    							
	    							preparedStatement = connection.prepareStatement(sql);
	    							
	    							preparedStatement.setInt(1, entryId);
	    							preparedStatement.setString(2, crusherId);
	    							preparedStatement.setString(3, crusherCode);
	    							preparedStatement.setString(4, this.getAccountId2());
	    							preparedStatement.setString(5, accountNumber);
	    							preparedStatement.setString(6, this.getBillDateTime());
	    							preparedStatement.setTime(7, time);
	    							preparedStatement.setString(8, "CREDIT");
	    							preparedStatement.setFloat(9, this.getAmountPaid2());
	    							preparedStatement.setString(10, this.getModeOfPayment2());
	    							preparedStatement.setString(11, billedBy);
	    							preparedStatement.setString(12, "PAID BY "+customerName+" AGAINST BILL No: "+this.getBillInfoDAO().getBillNumber());
	    							preparedStatement.setString(13, "ADD RMC BILL ");
	    							
	    							int rowInsetred = preparedStatement.executeUpdate();
	    							
	    							
	    							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId2(),"CREDIT", this.getBillDateTime(), this.getAmountPaid2(), billedBy, connection, this.getSessionMap());
	    							
	    						
	    							
	    							if(rowInsetred > 0 && isCloseingBalMaintained)
	    							{
	    								
	    								sql = "UPDATE "
	            	        					+ "crusher_rmc_billinfo "
	            	        					+ "SET "
	            	        					+ "account2_credit_debit_id = ? "
	            	        					+ "WHERE "
	            			        			+ "bill_number = ? "
	            			        			+ "AND "
	            			        			+ "customer_id = ? "
	            			        			+ "AND "
	            			        			+ "bill_type = ? "
	            			        			+ "AND "
	            			        			+ "crusher_id = ? "
	            								+ "AND "
	            								+ "crusher_code = ?";
	            	        			
	            	        			
	    	    						preparedStatement = connection.prepareStatement(sql);
	    	    						
	    	    						preparedStatement.setInt(1, entryId);
	    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
	    	    			        	preparedStatement.setString(3,custId);   
	    	    			        	preparedStatement.setString(4, this.getBillInfoDAO().getBillType());
	    	    			        	preparedStatement.setString(5, crusherId);
	    	    						preparedStatement.setString(6, crusherCode);
	    	    						
	    	    						rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	    	        				
	    							}
	    				    		}
	    							
	    	    						
	    	    						if(rowCreditDebitIdInsetred > 0 )
	    	    						{
	    								
	    								connection.commit();
	    	    						result = SUCCESS;
	    	    						}
	    							
	    							else
	    							{
	    								connection.rollback();
	    								result = ERROR;
	    							}
	    						}
								else
								{
									connection.commit();
		    						result = "success";
								}
	    						
	    						
	    						
								    				if(result.equals("success"))
								    				{
								    					
							    						
								    					boolean sendWhatsAppMessage = false; 
								    					
								    								if(this.getSessionMap().get("sendWhatsAppMessage").equals("TRUE"))
	    								    						{
	    								    							sendWhatsAppMessage = true;
	    								    						}
	    								    						
	    								    						
	    								    							
	    								    						String defaultMessageLang = "MARATHI";
	    								    						
	    								    						if(sendWhatsAppMessage && this.getBillInfoDAO().isSendSMS())
	    								    						{
	    								    							String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
	    								    							String crusherNameEnglish = (String) this.getSessionMap().get("crushernameenglish");
	    																
	    																String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
	    																
	    																String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
	    																
	    																HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
	    																
	    																String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
	    																
	    																String [] tokenData = tokenNumberWithUsername.split("#");
	    																
	    																String userName = tokenData[0];
	    																String tokenNumber = tokenData[1];
	    																String balanceCheckTokenNumber = tokenData[2];
	    																
	    								    							String msg = "";
	    								    							
	    								    							String productDetailsMsg = "";
	    								    							
	    								    							for(BillProductInfoDAO dao : this.getProductInfoList())
	    								    							{
	    								    								productDetailsMsg += "\n"+dao.getProductNameMarathi()+":"+dao.getQuantity()
	    								    								+" "+dao.getSalesUnit()+" : दर - "+dao.getSalesRate()+" =  रक्कम : "+dao.getAmountAfterDiscount();
	    								    							}
	    								    							
	    								    						 float custBalanceAmount = GetCustomerTotalCreditAmountById.getCustomerTotalCreditAmountById(this.getBillInfoDAO().getCustId(), this.getSessionMap());
	    								    						 float totalBalanceAmt = 0.0f;
	    								    						 
	    								    						 
	    									    						 if(this.getBillType().equals("CASH"))
	    									    						 {
	    									    							 totalBalanceAmt = custBalanceAmount;
	    									    						 }
	    									    						 else
	    									    						 {
	    									    							 totalBalanceAmt = custBalanceAmount;
	    									    						 }
	    								    						 
	    								    							if(defaultMessageLang.equals("MARATHI"))
	    								    							{
	    								    								msg = "*"+crusherNameMarathi +"* मधून खरेदी केल्याबद्दल धन्यवाद!";
	    								    								msg += "\n*बिल तारीख* : "+this.getBillDateTime();
	    								    								msg += "\n*बिल नं.* : "+this.getBillNumber();
	    								    								msg += "\n*गाडी क्र.* : "+this.getBillVehicleInfoDAO().getVehicleRCNumber();
	    								    								msg += "\n*मटेरीअल अनलोडिंगचे ठिकाण* : "+this.getBillVehicleInfoDAO().getTripTo();
	    								    								msg += "\n*-: तपशील :-*";
	    								    								msg += productDetailsMsg;
	    								    								msg += "\n*वाहतूक रक्कम* : "+this.getBillInfoDAO().getTransportCharge();
	    								    								msg += "\n*एकूण बील रक्कम* : "+ (floatTotalAmtAfterDiscount + this.getBillInfoDAO().getTransportCharge());
	    								    								msg += "\n*एकूण येणे बाकी* : "+ totalBalanceAmt;
	    								    								msg += "\n*संपर्क* : "+customerCareNumber;
	    								    								
	    								    								String pageSize = "";
	    								    								
	    								    								if(this.getBillType().equals("BILL-OF-SUPPLY"))
	    								    								{
	    								    									pageSize = "A5";
	    								    								}
	    								    								else
	    								    								{
	    								    									pageSize = "A4";
	    								    									
	    								    								}
	    								    								
	    								    								String key = EncryptionDecryptionType2.encrypt(this.getBillInfoDAO().getBillNumber()+"."+pageSize+".eng."+this.getBillType()+"."+crusherId+"."+crusherCode+".");
	    								    								
	    								    								//key = URLEncoder.encode(key,"UTF-8");
	    								    								String fileUrl = "https://easycrush.in/printBillWithOutSession?key="+key+"pdf";
	    								    								
	    								    								//System.out.println(fileUrl);
	    								    								
	    								    								String fileName = "खरेदी बील.pdf";
	    									    							
	    								    								String whatsAppResp = SendWhatsAppMessage.sendMessageWithFile(userName, this.getBillInfoDAO().getCustomerMobile(), msg, tokenNumber, fileUrl, fileName);
	    								    								
	    								    								
	    								    								int bal = CheckBalance.checkBal(userName, balanceCheckTokenNumber);
	    								    								
	    								    						
	    								    								//System.out.println(whatsAppResp);
	    								    								
	    								    								if(whatsAppResp.contains("success"))
	    								    								{
	    								    									addActionMessage("WhatsApp Message Sent Successfully! Remaining Message Balance : "+bal);
	    								    								}
	    								    								
	    								    							}
	    								    							
	    								    							
	    								    							
	    								    						}
	    														
	    				}
						
	    	        			
	    	        		
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.billNotSavedProperly"));
	        			}
	        			
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.sryBillDetailsNotSaved"));
	        	}
	        	
	        	
	        	
	        	
	        	
    			
	        		
	        	}
	        	catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					try {connection.rollback();} catch (SQLException e1) {}
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 "+this.getText("message.error.billDetailsNotSaveSuccessfully"));
				} catch (Exception e) {
					e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||2 "+this.getText("message.error.billDetailsNotSaveSuccessfully"));
				}finally {
					if(resultSet != null)
	   				{
	   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
					}
	        	}
	        	else
	        	{
	        		
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	
		        	
	        		this.getSessionMap().put("RMCProductList", this.getProductInfoList());
	        		
	        		setCustomerName(this.getBillInfoDAO().getCustomerName());
	        		setBillNumber(this.getBillInfoDAO().getBillNumber());
	        		setBillType(this.getBillInfoDAO().getBillType());
	        		setTransportCharge(this.getBillInfoDAO().getTransportCharge());
	        		//System.out.println(getAlternateMobileNumber());
	        		
	        		setAlternateMobileNumber(this.getBillInfoDAO().getCustomerMobile());
	        		setSendSMS(this.getBillInfoDAO().isSendSMS());
	        		float transportCharge = 0.0F;
	        		
		        	if(!this.getBillInfoDAO().getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = this.getBillInfoDAO().getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
		        		}
		        	}
		        	
		        	if(!hasActionErrors())
		        	{
		        		float totalBillAmt = floatTotalAmount + this.getBillInfoDAO().getTransportCharge() +  this.getBillInfoDAO().getPumpAmount() +  this.getBillInfoDAO().getLabourAmount();
			        	this.setTotalAmount(""+(totalBillAmt));	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	else
		        	{
		        		float totalBillAmt = floatTotalAmount + this.getBillInfoDAO().getTransportCharge() +  this.getBillInfoDAO().getPumpAmount() +  this.getBillInfoDAO().getLabourAmount();
			 		       
		        		this.setTotalAmount(""+(totalBillAmt));;	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	discountTypeList.put("", "Select Discount Type");
		  	      discountTypeList.put("By Quantity", "By Quantity");
		  	      discountTypeList.put("By Percentage", "By Percentage");
		  	      discountTypeList.put("By Direct Amount", "By Direct Amount");
		  			
		        	setDefaultValue(this.getBillInfoDAO().getPaymentType());
		        	

		        	
		        	
		        	
		        	
		        	
		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	this.getSessionMap().put("RMCBillInformation", this.getBillInfoDAO());
	        		this.getSessionMap().put("RMCProductList", this.getProductInfoList());
	        		result = "success";
	        		addActionError(this.getText("message.error.billAlreadySaved"));
	        	}
	        	}	
	        }
	       // System.out.print(result);
	        return result;
		
	}
	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		
		if(this.getAmountPaid() == null || this.getAmountPaid().equals(""))
		{
			addActionError(this.getText("message.error.amountPaidNullBillCannotSaved"));
		}
		
		if(!hasActionErrors())
		{
		if(this.getAmountPaid1() == null || this.getAmountPaid1().equals(""))
		{
			addActionError(this.getText("message.error.amountPaidNullBillCannotSaved")+1);
		}
		}
		
		if(!hasActionErrors())
		{
			if(this.getReturnAmount() == null || getReturnAmount().equals(""))
			{
				addActionError(this.getText("message.error.returnAmountNullBillCannotSaved"));
			}
		}
		
		if(!hasActionErrors())
		{
		if(this.getAmountPaid() > 0)
		{
			if(this.getAccountId1() == null || this.getAccountId1().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectAccountForCreditEntry"));
			}
			
		}
		}
		
		

		productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("RMCProductList");		        	
    	billInfoDAO = (BillInformationDAO) this.getSessionMap().get("RMCBillInformation");
    	
    	float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	for(BillProductInfoDAO infoDAO : productInfoList)
    	{
    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
    		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
    		
    	}
    	
    	setTransportCharge(this.getBillInfoDAO().getTransportCharge());
    	setCustomerName(this.getBillInfoDAO().getCustomerName());
		setBillNumber(this.getBillInfoDAO().getBillNumber());
		setBillType(this.getBillInfoDAO().getBillType());
		setBillDateTime(this.getBillInfoDAO().getBillDate());
		setChalanNumber(this.getBillInfoDAO().getChalanNumber());
		float laborCharges = 0.0F;
		float pumpCharges = 0.0F;
		if(!this.getBillInfoDAO().getTransportCharge().equals("")){
    		
    		try
    		{
    			transportCharge = this.getBillInfoDAO().getTransportCharge();
    		}catch(NumberFormatException nfe)
    		{
    			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
    		}
    	}
		
		
			if(!this.getBillInfoDAO().getPumpAmount().equals("")){
			    		
			    		try
			    		{
			    			pumpCharges = this.getBillInfoDAO().getPumpAmount();
			    		}catch(NumberFormatException nfe)
			    		{
			    			addActionError("Please Provide Correct Pump Amount !");
			    		}
			    	}
			
			if(!this.getBillInfoDAO().getLabourAmount().equals("")){
				
				try
				{
					laborCharges = this.getBillInfoDAO().getLabourAmount();
				}catch(NumberFormatException nfe)
				{
					addActionError("Please Provide Correct Labor Amount !");
				}
			}

		
		

		if(!hasActionErrors())
		{
		if(this.getBillInfoDAO().getPaymentType().equals("CASH") && this.getAmountPaid() > 0)
		{
			if(this.getAccountId1() == null || this.getAccountId1().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectAccountForCreditEntry"));
			}
			if(this.getModeOfPayment1() == null || this.getModeOfPayment1().equals(""))
			{
				addActionError("Please Select Mode Of Payment For Credit Entry !");
			}
			
			
		   if (this.getAccountId1() != null && !this.getAccountId1().equals("") && this.getAccountId2() != null && !this.getAccountId2().equals("") &&
			        this.getAccountId1().equals(this.getAccountId2())) {
			        
			        addActionError("Account 1 and Account 2 cannot be the same. Please select different accounts.");
			    }
			
			
			
			
			if(this.getAccountId2().trim() != null && !this.getAccountId2().trim().equals(""))
    		{
    			
    			if(this.getModeOfPayment2() == null || this.getModeOfPayment2().equals("")){
    				addActionError("Please Provide Mode Of Payment 2");
    			}
    			
    			if(this.getAmountPaid2() == null || this.getAmountPaid2().equals("")){
    				addActionError("Please Provide Amount Paid 2 !");
    			}
    		}
			
			
			   double amt1 = this.getAmountPaid1() != null ? this.getAmountPaid1() : 0;
			    double amt2 = this.getAmountPaid2() != null ? this.getAmountPaid2() : 0;
			    double totalAmt = this.getAmountPaid() != null ? this.getAmountPaid() : 0;

			    if ((amt1 + amt2) > totalAmt) {
			        addActionError("Amount Paid (Amount1 + Amount2) not greater than Total Amount Paid .");
			    }
			    
			    if ((amt1 + amt2) <= 0) {
			        addActionError("Amount Paid (Amount1 + Amount2) should not be '0' .");
			    }
			    
			    if ((amt1 + amt2) != totalAmt) {
			        addActionError("Amount Paid (Amount1 + Amount2) should be equal to Total Amount Paid .");
			    }
			
		}
		}
		
		if(!hasActionErrors())
		{
			if(this.getBillInfoDAO().getPaymentType().equals("CREDIT"))
			{
				if(this.getAmountPaid()>0)
				{
					addActionError(this.getText("message.error.ModeofpaymentIsCreditAmountPaidShouldBe0"));
				}
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getBillInfoDAO().getPaymentType().equals("CASH"))
			{
				if(this.getAmountPaid()<=0)
				{
					addActionError(this.getText("message.error.modeOfPaymentIsCashAmountPaidShouldNotBe0"));
				}
			}
			
			if(this.getBillInfoDAO().getPaymentType().equals("CASH"))
			{
				if(this.getAmountPaid() > Float.parseFloat(this.getTotalPaybleAmount()))
				{
					addActionError("mode Of Payment Is Cash Amount Paid Cannot be greater than Total Payble Amount !");
				}
			}
		}
		
		
    	
    	
        	setTotalAmount(""+(floatTotalAmount+transportCharge + laborCharges + pumpCharges));	        	
        	setTotalDiscount(""+floatTotalDiscount);
        	setTotalPaybleAmount(""+(floatTotalAmount+transportCharge + laborCharges + pumpCharges));
        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+transportCharge + laborCharges + pumpCharges));
        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
    	
    	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	setDefaultValue(this.getBillInfoDAO().getPaymentType());
    	

    	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
    	
    	unitList = GetListResource.GetUnitList();
    	billTypeList = GetListResource.GetBillTypeList();
    	
    	session=ServletActionContext.getRequest().getSession(false); 
    	
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
		
    	this.setPaymentTypeList2(GetTypeOfPaymentList.getPaymentTypeList());
    	

    	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    	this.setRateTyprDefaultValue("INCLUDINGGST");
    	
    	
		
		this.getSessionMap().put("RMCBillInformation", this.getBillInfoDAO());
		this.getSessionMap().put("RMCProductList", this.getProductInfoList());
	}
	
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}
	
	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	
	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public void setTotalPaybleAmount(String totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	
	


	public Float getAmountPaid() {
		return amountPaid;
	}
	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}
	public String getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}



	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}



	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	public boolean isBillSaved() {
		return billSaved;
	}
	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}
	public String getBillDateTime() {
		return billDateTime;
	}
	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getChalanNumber() {
		return chalanNumber;
	}
	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}
	public Float getTransportCharge() {
		return transportCharge;
	}
	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}

	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}
	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}
	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}
	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}
	 
	public String getModeOfPayment1() {
		return modeOfPayment1;
	}
	public void setModeOfPayment1(String modeOfPayment1) {
		this.modeOfPayment1 = modeOfPayment1;
	}
	public String getAccountId1() {
		return accountId1;
	}
	public void setAccountId1(String accountId1) {
		this.accountId1 = accountId1;
	}
	public Float getAmountPaid1() {
		return amountPaid1;
	}
	public void setAmountPaid1(Float amountPaid1) {
		this.amountPaid1 = amountPaid1;
	}
	public String getModeOfPayment2() {
		return modeOfPayment2;
	}
	public void setModeOfPayment2(String modeOfPayment2) {
		this.modeOfPayment2 = modeOfPayment2;
	}
	public String getAccountId2() {
		return accountId2;
	}
	public void setAccountId2(String accountId2) {
		this.accountId2 = accountId2;
	}
	public Float getAmountPaid2() {
		return amountPaid2;
	}
	public void setAmountPaid2(Float amountPaid2) {
		this.amountPaid2 = amountPaid2;
	}
	public Map<String, String> getAccountList() {
		return accountList;
	}
	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}
	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}
	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}
	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}
	public String getRateType() {
		return rateType;
	}
	public void setRateType(String rateType) {
		this.rateType = rateType;
	}
	public String getDiscountType() {
		return discountType;
	}
	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}
	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}
	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}
	public String getTotalAmount() {
		return totalAmount;
	}
	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}
	

	
}
