package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.PurchaseInvoiceInformationDAO;
import com.stonecrusher.DAO.PurchaseProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class SavePurchaseInvoiceDummy  extends ActionSupport implements SessionAware,Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3005109908698701102L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private String purchaseDateTime;
	private PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO = null;	
	private List<PurchaseProductInfoDAO> purchaseProductInfoList = null;
	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private String totalPurchaseAmount;
	private Float amountPaid;
	private String frightCharges;
	private String otherExpense;
	private File invoiceImage;
	private String comments;
	private DecimalFormat df;
	private String purchaseBy;
	private String totalNettAmount;
	private String totalCGST;
	private String totalSGST;
	private String totalIGST;
	
	
	private String productName;
	private String amount;
	private String quantity;
	private String purchaseUnit;
	private String purchaseRate;
	private String taxId;

	private String purchaseId;
	private String supplierName;
	private String invoiceNumber;

	private String invoiceImageContentType;
	private boolean addToStock;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String paymentType;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String paymentDefaultValue;
	
	@SuppressWarnings("unchecked")
	public String execute() {
			
			
			String result = "login";
			session=ServletActionContext.getRequest().getSession(false); 
			
		        if(session==null || session.getAttribute("login")==null){ 
		        	addActionMessage("Please Login First !!!");
		        	result = "login";
		        }  
		        else{
		        	paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        		
		        	
		        	this.setPaymentDefaultValue(this.getPaymentDefaultValue());
		        	

					customerSearchOptionList.put("BYNAME", "BY NAME");
					customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
					customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
					setDefaultValue("BYNAME");
					setCustomerSearchOption("BYNAME");
					
		        	 df = new DecimalFormat("0.00");
		        	
		        	 purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
		        	purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
		        	Connection connection = null;
					PreparedStatement preparedStatement= null;
					ResultSet resultSet = null;
					
					String sql = "";
					String db = (String) session.getAttribute("db");
					
        	try
			{
		        	if(purchaseInvoiceInformationDAO != null && purchaseProductInfoList != null)
		        	{
		        	
							connection = new GetDBConnection().getDBConnection(db);
							connection.setAutoCommit(false);
							
							 java.util.Date date = new java.util.Date();
			        	      long t = date.getTime();	        	     
			        	      java.sql.Time time = new java.sql.Time(t);
			        	      
			        	      int newPurchaseId = 0;
			        	      if(purchaseInvoiceInformationDAO.getPurchaseId() == null || 
			        	    		  purchaseInvoiceInformationDAO.getPurchaseId().equals("NA") 
			        	    		  || purchaseInvoiceInformationDAO.getPurchaseId().equals(""))
			        	      {
			        	    		sql = "SELECT "
			    							+ "purchasenumber "
			    							+ "FROM "
			    							+ "purchaseinfo "
			    							+ "ORDER BY "
			    							+ "purchasenumber "
			    							+ "DESC LIMIT 1;";
			    					
			    				
			    				preparedStatement = connection.prepareStatement(sql);
			    				resultSet = preparedStatement.executeQuery();
			    			
			    				
			    				if(resultSet.next())
			    				{
			    					if(!(resultSet.getString(1) == null))
			    					{
			    						newPurchaseId = Integer.parseInt(resultSet.getString(1));
			    						
			    						
			    						 purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId+1));
			    					}
			    					else
			    					{
			    						newPurchaseId =1;
			    						purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId));
			    					
			    						
			    					}
			    				}
			    				else
			    				{	newPurchaseId =1;
			    					purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId));
			    				}
			        	      }
			            		
			        	    if(resultSet != null)
			          		{
			          			resultSet.close();
			          			resultSet = null;
			          		}
			        	    
			          		if(preparedStatement!= null)
			          		{
			          			preparedStatement.close();
			          			preparedStatement = null;
			          		}
			          		FileInputStream fis = null;
			         		if(this.getInvoiceImage() != null)
			          		{
			          		 fis =  new FileInputStream(this.getInvoiceImage());
			          		}
			          		
			          		String fullUserName = (String) session.getAttribute("userFullName");
				        	
				        	String splitUserName [] = new String[5];
				        	
				        	String entryBy = "";
				        	try
				        	{
				        		splitUserName = fullUserName.split(" ");
				        		entryBy = splitUserName[0];
				        		
				        	}catch(Exception e)
				        	{
				        		entryBy = fullUserName;
				        	}
	          		if(!purchaseInvoiceInformationDAO.isPurchaseSaved())					
	          		{
	          			
			          		
							if(getInvoiceImage() != null)
							{
								
									 sql = "INSERT INTO "
									 		+ "purchaseinfo "
									 		+ "("
									 		+ "purchasenumber,"
											+ "invoicenumber,"
											+ "purchasedate,"								
											+ "purchasetime,"									
											+ "supplierid,"
											+ "suppliername,"
											+ "transportcharges,"
											+ "otherexpense,"
											+ "comments,"
											+ "purchasetotalamount,"
											+ "purchaseamountpaid,"
											+ "totalcgst,"
											+ "totalsgst,"
											+ "totaligst,"
											+ "totalnetamount,"									
											+ "invoicepic,"
											+ "entryBy,"
											+ "paymenttype,"
											+ "purchasedby) "
											+ "VALUES "
											+ "(?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
									
									preparedStatement = connection.prepareStatement(sql);
									
									preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
									preparedStatement.setString(2, purchaseInvoiceInformationDAO.getInvoiceNumber());
									
									preparedStatement.setString(3, purchaseInvoiceInformationDAO.getPurchaseDate());
									preparedStatement.setTime(4, time);
									preparedStatement.setString(5, purchaseInvoiceInformationDAO.getSupplierId());
									preparedStatement.setString(6, purchaseInvoiceInformationDAO.getSupplierName());
									preparedStatement.setString(7, this.getFrightCharges());
									preparedStatement.setString(8, this.getOtherExpense());
									preparedStatement.setString(9, this.getComments());
									preparedStatement.setFloat(10, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
									preparedStatement.setFloat(11, this.getAmountPaid());
									preparedStatement.setFloat(12, purchaseInvoiceInformationDAO.getTotalCGST());
									preparedStatement.setFloat(13, purchaseInvoiceInformationDAO.getTotalSGST());
									preparedStatement.setFloat(14, purchaseInvoiceInformationDAO.getTotalIGST());
									preparedStatement.setFloat(15, purchaseInvoiceInformationDAO.getTotalNettAmount());							
									preparedStatement.setBinaryStream(16, fis,(int)getInvoiceImage().length());
									
									preparedStatement.setString(17, entryBy);
									preparedStatement.setString(18, purchaseInvoiceInformationDAO.getPaymentType());
									preparedStatement.setString(19, purchaseInvoiceInformationDAO.getPurchaseBy());
							}
							else
							{
								 sql = "INSERT INTO "
									 		+ "purchaseinfo "
									 		+ "("
									 		+ "purchasenumber,"
											+ "invoicenumber,"
											+ "purchasedate,"								
											+ "purchasetime,"									
											+ "supplierid,"
											+ "suppliername,"
											+ "transportcharges,"
											+ "otherexpense,"
											+ "comments,"
											+ "purchasetotalamount,"
											+ "purchaseamountpaid,"
											+ "totalcgst,"
											+ "totalsgst,"
											+ "totaligst,"
											+ "totalnetamount,"
											+ "entryBy,"
											+ "paymenttype,"
											+ "purchasedby) "
											+ "VALUES "
											+ "(?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
									
									preparedStatement = connection.prepareStatement(sql);
									
									preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
									preparedStatement.setString(2, purchaseInvoiceInformationDAO.getInvoiceNumber());
									preparedStatement.setString(3, purchaseInvoiceInformationDAO.getPurchaseDate());
									preparedStatement.setTime(4, time);
									preparedStatement.setString(5, purchaseInvoiceInformationDAO.getSupplierId());
									preparedStatement.setString(6, purchaseInvoiceInformationDAO.getSupplierName());
									preparedStatement.setString(7, this.getFrightCharges());
									preparedStatement.setString(8, this.getOtherExpense());
									preparedStatement.setString(9, this.getComments());
									preparedStatement.setFloat(10, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
									preparedStatement.setFloat(11, this.getAmountPaid());
									preparedStatement.setFloat(12, purchaseInvoiceInformationDAO.getTotalCGST());
									preparedStatement.setFloat(13, purchaseInvoiceInformationDAO.getTotalSGST());
									preparedStatement.setFloat(14, purchaseInvoiceInformationDAO.getTotalIGST());
									preparedStatement.setFloat(15, purchaseInvoiceInformationDAO.getTotalNettAmount());
									preparedStatement.setString(16, entryBy);
									preparedStatement.setString(17, purchaseInvoiceInformationDAO.getPaymentType());
									preparedStatement.setString(18, purchaseInvoiceInformationDAO.getPurchaseBy());

							}
		        	}
	          		else
		        	{
		        		 sql = "update purchaseinfo set "
									+ "invoicenumber=?,"								
									+ "purchasetime=?,"									
									+ "supplierid=?,"
									+ "suppliername=?,"
									+ "transportcharges=?,"
									+ "comments=?,"
									+ "otherexpense=?,"
									+ "purchasetotalamount=?,"
									+ "purchaseamountpaid=?,"
									+ "totalcgst=?,"
									+ "totalsgst=?,"
									+ "totaligst=?,"
									+ "totalnetamount=?,"
									+ "entryBy=?,"
									+ "paymenttype=?,"
									+ "purchasedby=? "
									+ "where "
									+ "purchasenumber = '"+purchaseInvoiceInformationDAO.getPurchaseId()+"'";
						 
						 
		        		 	preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, purchaseInvoiceInformationDAO.getInvoiceNumber());
							preparedStatement.setTime(2, time);
							preparedStatement.setString(3, purchaseInvoiceInformationDAO.getSupplierId());
							preparedStatement.setString(4, purchaseInvoiceInformationDAO.getSupplierName());
							preparedStatement.setString(5, this.getFrightCharges());
							preparedStatement.setString(6, this.getComments());
							preparedStatement.setString(7, this.getOtherExpense());								
							preparedStatement.setFloat(8, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
							preparedStatement.setFloat(9, this.getAmountPaid());
							preparedStatement.setFloat(10, purchaseInvoiceInformationDAO.getTotalCGST());
							preparedStatement.setFloat(11, purchaseInvoiceInformationDAO.getTotalSGST());
							preparedStatement.setFloat(12, purchaseInvoiceInformationDAO.getTotalIGST());
							preparedStatement.setFloat(13, purchaseInvoiceInformationDAO.getTotalNettAmount());							
							preparedStatement.setString(14, entryBy);							
							preparedStatement.setString(15, purchaseInvoiceInformationDAO.getPaymentType());					
								
							preparedStatement.setString(16, purchaseInvoiceInformationDAO.getPurchaseBy());
							
							
		        	}
	          		int rowsUpdated = preparedStatement.executeUpdate();
				          		
							if(fis != null)
							{
								fis.close();
								fis = null;
							}	
							
							if(rowsUpdated>0)
							{
								
								if(preparedStatement != null)
								{
									preparedStatement.close();
								}
								
								int rowsToDelete = 0;
								int rowsDeleted = 0;
								
								
								sql = "select "
										+ "count(*) "
										+ "from "
										+ "productpurchaseinfo "
										+ "where purchaseid = '"+purchaseInvoiceInformationDAO.getPurchaseId()+"' "
										+ "and invoicenumber='"+purchaseInvoiceInformationDAO.getInvoiceNumber()+"'";
								
								preparedStatement = connection.prepareStatement(sql);
								
								
								resultSet = preparedStatement.executeQuery();
								
								if(resultSet.next())
								{
									rowsToDelete = resultSet.getInt(1);
								}
								
								
								if(preparedStatement != null)
								{
									preparedStatement.close();
								}
								
								if(rowsToDelete>0)
								{
									sql = "delete "
											+ "from "
											+ "productpurchaseinfo "
											+ "where purchaseid = '"+purchaseInvoiceInformationDAO.getPurchaseId()+"' "
											+ "and invoicenumber='"+purchaseInvoiceInformationDAO.getInvoiceNumber()+"'";
									
									preparedStatement = connection.prepareStatement(sql);
									
									rowsDeleted = preparedStatement.executeUpdate();
								}
								
								
						if(rowsToDelete == rowsDeleted)
						{

								if(purchaseProductInfoList != null)
								{
										if(preparedStatement != null)
										{
											preparedStatement.close();
										}
										
										sql = "insert into "
												+ "productpurchaseinfo "
												+ "("
												+ "invoicenumber,"
												+ "purchaseid,"
												+ "productname,"
												+ "purchaseunit,"
												+ "taxpercentage,"
												+ "purchaserate,"
												+ "quanity,"
												+ "productamount,"
												+ "grossamount,"
												+ "igst,"
												+ "cgst,"
												+ "sgst"
												+ ") "
												+ "values"
												+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
										preparedStatement = connection.prepareStatement(sql);
										
										for(PurchaseProductInfoDAO dao: purchaseProductInfoList)
										{
											preparedStatement.setString(1, invoiceNumber);
											preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
											preparedStatement.setString(3, dao.getProductName());
											preparedStatement.setString(4, dao.getPurchaseUnit());
											preparedStatement.setFloat(5, dao.getTaxPercentage());
											preparedStatement.setFloat(6, dao.getPurchaseRate());
											preparedStatement.setFloat(7, dao.getQuantity());
											preparedStatement.setFloat(8, dao.getAmount());
											preparedStatement.setFloat(9, dao.getNettAmount());
											preparedStatement.setFloat(10, dao.getIgst());
											preparedStatement.setFloat(11, dao.getCgst());
											preparedStatement.setFloat(12, dao.getSgst());
											
											
											preparedStatement.addBatch();
											
										
										}
										
										
										int [] numUpdates=preparedStatement.executeBatch();
										
										
										if(purchaseProductInfoList.size() == numUpdates.length)
										{
											connection.commit();
											purchaseInvoiceInformationDAO.setPurchaseSaved(true);
											result="success";
											addActionMessage("Purchase invoice saved successfully!");
										}
										else
										{
											connection.rollback();
											result="error";
											addActionError("45. Purchase invoice details not saved ! Please try again !");
										}
									}
									else
									{
										connection.rollback();
										result="error";
										addActionError("56. Purchase invoice details not saved ! Please try again !");
									}
									
									
								
						}
						else
						{
							connection.rollback();
							result = "error";
							addActionError("78. Purchase information not saved! Please try again !");
							
						}
								
								
					}else
					{
						connection.rollback();
						result = "error";								
						addActionError("Purchase details not inserted! Please try again!");
					}
						
		        	
		        }else
		        {
		        	result = "error";
		        	addActionError("Purchase details not found!Please try again!");
		        }
		        	
			   }catch (SQLException e) {
					e.printStackTrace();
					result = "error";	
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Purchase details not Saved!");
					
				} catch (IOException e) {
					e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || Purchase details not Saved!");
				}finally 
				{
					if(resultSet != null)
	   				{
	   					try {resultSet.close();}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
			}
		        
		        
		        try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
		    	
		    	unitList = GetListResource.GetUnitList();
		    	
		    	
		    	
		    	 
	       	 float floatTotalPurchaseAmount = 0.0F;
	       	 float floatTotalCGST = 0.0F;
	       	 float floatTotalSGST = 0.0F;
	       	 float floatTotalIGST = 0.0F;
	       	 float floatTotalNettAmount = 0.0F;
	       	 
	       	 for (PurchaseProductInfoDAO pProductInfoDAO : purchaseProductInfoList)
	       	 {
	       		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getAmount();
	       		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
	       		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
	       		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
	       		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
	       	 }
	       	 
	       	 setTotalPurchaseAmount(""+df.format(floatTotalPurchaseAmount));
	       	 setTotalNettAmount(""+df.format(floatTotalNettAmount));
	       	 setTotalCGST(""+df.format(floatTotalCGST));
	       	 setTotalSGST(""+df.format(floatTotalSGST));
	       	 setTotalIGST(""+df.format(floatTotalIGST));
	   		
	       	 setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
	       	 setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
	       	 setSupplierName(purchaseInvoiceInformationDAO.getSupplierDetails());
	       	 setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
	      	this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
	    	
	       	 setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
	       	sessionMap.put("purchaseInformation", purchaseInvoiceInformationDAO);
	       	sessionMap.put("purchaseProductList", purchaseProductInfoList);
			
return result;
}

	@SuppressWarnings("unchecked")
	@Override
	public void validate() {

		 df = new DecimalFormat("0.00");
		purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
		purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
		
		if(getAmountPaid().equals(""))
		{
			addActionError("Please provide amount paid value !");
		}
		
		if(!hasActionErrors())
		{
			if(getAmountPaid()!=null || !getAmountPaid().equals("") )
					{
						Float amtPaid =0.0F; 
						
						
						try
						{
							amtPaid = this.getAmountPaid();
							
							if(amtPaid<0 || amtPaid > purchaseInvoiceInformationDAO.getPurchaseTotalAmount())
							{
								addActionError("Please provide correct amount paid value ! ");
								addActionError("Amount paid cannot be less than '0' and cannot be greter than Total Amount !");
							}
						}catch(NumberFormatException nfe)
						{
							addActionError("Please provide correct value for amount paid !");
						}
					}
			
			
		}
		
		if(!hasActionErrors())
		{
			if(purchaseInvoiceInformationDAO.getPaymentType().equals("CREDIT") && this.getAmountPaid() > 0){
				addActionError("Payment type is credit amount paid cannot be greater than '0'!");
			}
		}
		
		   try {
				taxList = GetListResource.GetTaxList();
				
			} catch (IOException e) {
				
			}
	   	
		 unitList = GetListResource.GetUnitList();
	  	 float floatTotalPurchaseAmount = 0.0F;
	  	 float floatTotalCGST = 0.0F;
	  	 float floatTotalSGST = 0.0F;
	  	 float floatTotalIGST = 0.0F;
	  	 float floatTotalNettAmount = 0.0F;
	  	 
	  	 for (PurchaseProductInfoDAO pProductInfoDAO : purchaseProductInfoList)
	  	 {
	  		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getAmount();
	  		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
	  		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
	  		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
	  		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
	  	 }
	  	 
	  	this.setTotalPurchaseAmount(""+df.format(floatTotalPurchaseAmount));
	  	this.setTotalNettAmount(""+df.format(floatTotalNettAmount));
	  	this.setTotalCGST(""+df.format(floatTotalCGST));
	  	this.setTotalSGST(""+df.format(floatTotalSGST));
	  	this.setTotalIGST(""+df.format(floatTotalIGST));
	  	this.setPurchaseBy(purchaseInvoiceInformationDAO.getPurchaseBy());
	  	this.setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
	  	this.setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
	  	this.setSupplierName(purchaseInvoiceInformationDAO.getSupplierDetails());
	  	this.setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
	  	this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
	
	  	this.setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
	  	sessionMap.put("purchaseInformation", purchaseInvoiceInformationDAO);
	  	sessionMap.put("purchaseProductList", purchaseProductInfoList);
		
	  	this.setPaymentDefaultValue(this.getPaymentDefaultValue());
	}
@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}





public PurchaseInvoiceInformationDAO getPurchaseInvoiceInformationDAO() {
	return purchaseInvoiceInformationDAO;
}





public void setPurchaseInvoiceInformationDAO(PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO) {
	this.purchaseInvoiceInformationDAO = purchaseInvoiceInformationDAO;
}





public List<PurchaseProductInfoDAO> getPurchaseProductInfoList() {
	return purchaseProductInfoList;
}





public void setPurchaseProductInfoList(List<PurchaseProductInfoDAO> purchaseProductInfoList) {
	this.purchaseProductInfoList = purchaseProductInfoList;
}





public Map<String, String> getTaxList() {
	return taxList;
}





public void setTaxList(Map<String, String> taxList) {
	this.taxList = taxList;
}





public Map<String, String> getUnitList() {
	return unitList;
}





public void setUnitList(Map<String, String> unitList) {
	this.unitList = unitList;
}





public String getTotalPurchaseAmount() {
	return totalPurchaseAmount;
}





public void setTotalPurchaseAmount(String totalPurchaseAmount) {
	this.totalPurchaseAmount = totalPurchaseAmount;
}





public Float getAmountPaid() {
	return amountPaid;
}

public void setAmountPaid(Float amountPaid) {
	this.amountPaid = amountPaid;
}

public String getFrightCharges() {
	return frightCharges;
}





public void setFrightCharges(String frightCharges) {
	this.frightCharges = frightCharges;
}





public String getOtherExpense() {
	return otherExpense;
}





public void setOtherExpense(String otherExpense) {
	this.otherExpense = otherExpense;
}





public File getInvoiceImage() {
	return invoiceImage;
}





public void setInvoiceImage(File invoiceImage) {
	this.invoiceImage = invoiceImage;
}





public String getComments() {
	return comments;
}





public void setComments(String comments) {
	this.comments = comments;
}





public DecimalFormat getDf() {
	return df;
}





public void setDf(DecimalFormat df) {
	this.df = df;
}





public String getTotalNettAmount() {
	return totalNettAmount;
}





public void setTotalNettAmount(String totalNettAmount) {
	this.totalNettAmount = totalNettAmount;
}





public String getTotalCGST() {
	return totalCGST;
}





public void setTotalCGST(String totalCGST) {
	this.totalCGST = totalCGST;
}





public String getTotalSGST() {
	return totalSGST;
}





public void setTotalSGST(String totalSGST) {
	this.totalSGST = totalSGST;
}





public String getTotalIGST() {
	return totalIGST;
}





public void setTotalIGST(String totalIGST) {
	this.totalIGST = totalIGST;
}





public String getProductName() {
	return productName;
}





public void setProductName(String productName) {
	this.productName = productName;
}





public String getAmount() {
	return amount;
}





public void setAmount(String amount) {
	this.amount = amount;
}





public String getQuantity() {
	return quantity;
}





public void setQuantity(String quantity) {
	this.quantity = quantity;
}





public String getPurchaseUnit() {
	return purchaseUnit;
}





public void setPurchaseUnit(String purchaseUnit) {
	this.purchaseUnit = purchaseUnit;
}





public String getPurchaseRate() {
	return purchaseRate;
}





public void setPurchaseRate(String purchaseRate) {
	this.purchaseRate = purchaseRate;
}





public String getTaxId() {
	return taxId;
}





public void setTaxId(String taxId) {
	this.taxId = taxId;
}





public String getPurchaseId() {
	return purchaseId;
}





public void setPurchaseId(String purchaseId) {
	this.purchaseId = purchaseId;
}





public String getSupplierName() {
	return supplierName;
}





public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}





public String getInvoiceNumber() {
	return invoiceNumber;
}





public void setInvoiceNumber(String invoiceNumber) {
	this.invoiceNumber = invoiceNumber;
}





public String getInvoiceImageContentType() {
	return invoiceImageContentType;
}





public void setInvoiceImageContentType(String invoiceImageContentType) {
	this.invoiceImageContentType = invoiceImageContentType;
}





public boolean isAddToStock() {
	return addToStock;
}





public void setAddToStock(boolean addToStock) {
	this.addToStock = addToStock;
}





public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}





public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}





public String getCustomerSearchOption() {
	return customerSearchOption;
}





public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}





public String getDefaultValue() {
	return defaultValue;
}





public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}





public static long getSerialversionuid() {
	return serialVersionUID;
}

public String getPurchaseDateTime() {
	return purchaseDateTime;
}

public void setPurchaseDateTime(String purchaseDateTime) {
	this.purchaseDateTime = purchaseDateTime;
}

public String getPaymentType() {
	return paymentType;
}

public void setPaymentType(String paymentType) {
	this.paymentType = paymentType;
}

public Map<String, String> getPaymentTypeList() {
	return paymentTypeList;
}

public void setPaymentTypeList(Map<String, String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}

public String getPaymentDefaultValue() {
	return paymentDefaultValue;
}

public void setPaymentDefaultValue(String paymentDefaultValue) {
	this.paymentDefaultValue = paymentDefaultValue;
}

public String getPurchaseBy() {
	return purchaseBy;
}

public void setPurchaseBy(String purchaseBy) {
	this.purchaseBy = purchaseBy;
}



}
