package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;
import com.stonecrusher.DAO.PurchaseInvoiceInformationDAO;
import com.stonecrusher.DAO.PurchaseProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class SavePurchaseInvoice  extends ActionSupport implements SessionAware,Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3005109908698701102L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private String purchaseDateTime;
	private PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO = null;	
	private List<PurchaseProductInfoDAO> purchaseProductInfoList = null;
	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private String totalPurchaseAmount;
	private Float amountPaid;
	private String frightCharges;
	private String otherExpense;
	private File invoiceImage;
	private String comments;
	private DecimalFormat df;
	private String purchaseBy;
	private String totalNettAmount;
	private String totalCGST;
	private String totalSGST;
	private String totalIGST;
	
	
	private String productName;
	private String amount;
	private String quantity;
	private String purchaseUnit;
	private String purchaseRate;
	private String taxId;

	private String purchaseId;
	private String supplierName;
	private String invoiceNumber;

	private String invoiceImageContentType;
	private boolean addToStock;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String paymentType;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String paymentDefaultValue;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
   
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	private List<String> paymentTypeList2 = new ArrayList<String>();
	private String modeOfPayment;
	
	
	@SuppressWarnings("unchecked")
	public String execute() {
			
			
			String result = "login";
			session=ServletActionContext.getRequest().getSession(false); 
			
		        if(session==null || session.getAttribute("login")==null){ 
		        	addActionMessage(this.getText("message.error.plzloginfirst"));
		        	result = "login";
		        }  
		        else{
		        	
		        	String crusherId = (String) this.getSessionMap().get("crusherId");
		    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		    		
		        	paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        		
		        	
		        	this.setPaymentDefaultValue(this.getPaymentDefaultValue());
		        	

					customerSearchOptionList.put("BYNAME", "BY NAME");
					customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
					customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
					setDefaultValue("BYNAME");
					setCustomerSearchOption("BYNAME");
					
		        	 df = new DecimalFormat("0.00");
		        	
		        	 purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
		        	purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
		        	Connection connection = null;
					PreparedStatement preparedStatement= null;
					ResultSet resultSet = null;
					
					String sql = "";
					String db = (String) session.getAttribute("db");
					
        	try
			{
		        	if(purchaseInvoiceInformationDAO != null && purchaseProductInfoList != null)
		        	{
		        	
						
							connection = GetDBConnection.getDBConnection(db);
							connection.setAutoCommit(false);
							
							 java.util.Date date = new java.util.Date();
			        	      long t = date.getTime();	        	     
			        	      java.sql.Time time = new java.sql.Time(t);
			        	      
			        	      int newPurchaseId = 0;
			        	      if(purchaseInvoiceInformationDAO.getPurchaseId() == null || 
			        	    		  purchaseInvoiceInformationDAO.getPurchaseId().equals("NA") 
			        	    		  || purchaseInvoiceInformationDAO.getPurchaseId().equals(""))
			        	      {
			        	    		sql = "SELECT "
			    							+ "purchase_id "
			    							+ "FROM "
			    							+ "crusher_purchase_master "
			    							+ "WHERE "
			    							+ "crusher_id = ? "
			    							+ "AND "
			    							+ "crusher_code = ? "
			    							+ "ORDER BY "
			    							+ "purchase_id "
			    							+ "DESC LIMIT 1;";
			    					
			    				
			    				preparedStatement = connection.prepareStatement(sql);
			    				preparedStatement.setString(1, crusherId);
			    				preparedStatement.setString(2, crusherCode);
			    				
			    				resultSet = preparedStatement.executeQuery();
			    			
			    				
			    				if(resultSet.next())
			    				{
			    					if(!(resultSet.getString(1) == null))
			    					{
			    						newPurchaseId = Integer.parseInt(resultSet.getString(1));
			    						
			    						
			    						 purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId+1));
			    					}
			    					else
			    					{
			    						newPurchaseId =1;
			    						purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId));
			    					
			    						
			    					}
			    				}
			    				else
			    				{	newPurchaseId =1;
			    					purchaseInvoiceInformationDAO.setPurchaseId(""+(newPurchaseId));
			    				}
			        	      }
			            		
			        	    if(resultSet != null)
			          		{
			          			resultSet.close();
			          			resultSet = null;
			          		}
			        	    
			          		if(preparedStatement!= null)
			          		{
			          			preparedStatement.close();
			          			preparedStatement = null;
			          		}
			          		FileInputStream fis = null;
			         		if(this.getInvoiceImage() != null)
			          		{
			          		 fis =  new FileInputStream(this.getInvoiceImage());
			          		}
			          		
			          		String fullUserName = (String) session.getAttribute("userFullName");
				        	
				        	String splitUserName [] = new String[5];
				        	
				        	String entryBy = "";
				        	try
				        	{
				        		splitUserName = fullUserName.split(" ");
				        		entryBy = splitUserName[0];
				        		
				        	}catch(Exception e)
				        	{
				        		entryBy = fullUserName;
				        	}
				        	
	          		if(!purchaseInvoiceInformationDAO.isViewPurchaseInvoice() && !purchaseInvoiceInformationDAO.isPurchaseSaved())					
	          		{
	          			
			          		
							if(getInvoiceImage() != null)
							{
								
									 sql = "INSERT INTO "
									 		+ "crusher_purchase_master "
									 		+ "("
									 		+ "purchase_id,"
									 		+ "crusher_id,"
					        				+ "crusher_code,"
					        				+ "purchase_invoice_number,"
											+ "purchase_date,"								
											+ "purchase_time,"								
											+ "supplier_id,"
											+ "supplier_name,"
											+ "tarnsportation_charges,"
											+ "other_expenses,"
											+ "comments,"
											+ "purchase_total_amount,"
											+ "purchase_amount_paid,"
											+ "purchase_total_igst_amount,"
											+ "purchase_total_cgst_amount,"
											+ "purchase_total_sgst_amount,"
											+ "purchase_total_nett_amount,"									
											+ "purchase_invoice_pic,"
											+ "purchase_entry_by,"
											+ "payemnt_type,"
											+ "purcahsed_by,"
											+ "purchase_type) "
											+ "VALUES "
											+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
									
									preparedStatement = connection.prepareStatement(sql);
									
									preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
									preparedStatement.setString(2, crusherId);
					        		preparedStatement.setString(3, crusherCode);
					        		
									preparedStatement.setString(4, purchaseInvoiceInformationDAO.getInvoiceNumber());
									
									preparedStatement.setString(5, purchaseInvoiceInformationDAO.getPurchaseDate());
									preparedStatement.setTime(6, time);
									preparedStatement.setString(7, purchaseInvoiceInformationDAO.getSupplierId());
									preparedStatement.setString(8, purchaseInvoiceInformationDAO.getSupplierName());
									preparedStatement.setString(9, this.getFrightCharges());
									preparedStatement.setString(10, this.getOtherExpense());
									preparedStatement.setString(11, this.getComments());
									preparedStatement.setFloat(12, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
									preparedStatement.setFloat(13, this.getAmountPaid());
									preparedStatement.setFloat(14, purchaseInvoiceInformationDAO.getTotalIGST());
									preparedStatement.setFloat(15, purchaseInvoiceInformationDAO.getTotalCGST());
									preparedStatement.setFloat(16, purchaseInvoiceInformationDAO.getTotalSGST());
									preparedStatement.setFloat(17, purchaseInvoiceInformationDAO.getTotalNettAmount());							
									preparedStatement.setBinaryStream(18, fis,(int)getInvoiceImage().length());
									
									preparedStatement.setString(19, entryBy);
									preparedStatement.setString(20, purchaseInvoiceInformationDAO.getPaymentType());
									preparedStatement.setString(21, purchaseInvoiceInformationDAO.getPurchaseBy());
									preparedStatement.setString(22, "REGULER");
									
							}
							else
							{
								
								 sql = "INSERT INTO "
									 		+ "crusher_purchase_master "
									 		+ "("
									 		+ "purchase_id,"
									 		+ "crusher_id,"
					        				+ "crusher_code,"
					        				+ "purchase_invoice_number,"
											+ "purchase_date,"								
											+ "purchase_time,"								
											+ "supplier_id,"
											+ "supplier_name,"
											+ "tarnsportation_charges,"
											+ "other_expenses,"
											+ "comments,"
											+ "purchase_total_amount,"
											+ "purchase_amount_paid,"
											+ "purchase_total_igst_amount,"
											+ "purchase_total_cgst_amount,"
											+ "purchase_total_sgst_amount,"
											+ "purchase_total_nett_amount,"		
											+ "purchase_entry_by,"
											+ "payemnt_type,"
											+ "purcahsed_by,"
											+ "purchase_type,"
											+ "purchase_invoice_pic) "
											+ "VALUES "
											+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
									
									preparedStatement = connection.prepareStatement(sql);
									
									preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
									preparedStatement.setString(2, crusherId);
					        		preparedStatement.setString(3, crusherCode);
					        		preparedStatement.setString(4, purchaseInvoiceInformationDAO.getInvoiceNumber());
									preparedStatement.setString(5, purchaseInvoiceInformationDAO.getPurchaseDate());
									preparedStatement.setTime(6, time);
									preparedStatement.setString(7, purchaseInvoiceInformationDAO.getSupplierId());
									preparedStatement.setString(8, purchaseInvoiceInformationDAO.getSupplierName());
									preparedStatement.setString(9, this.getFrightCharges());
									preparedStatement.setString(10, this.getOtherExpense());
									preparedStatement.setString(11, this.getComments());
									preparedStatement.setFloat(12, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
									preparedStatement.setFloat(13, this.getAmountPaid());
									preparedStatement.setFloat(14, purchaseInvoiceInformationDAO.getTotalIGST());
									preparedStatement.setFloat(15, purchaseInvoiceInformationDAO.getTotalCGST());
									preparedStatement.setFloat(16, purchaseInvoiceInformationDAO.getTotalSGST());
									preparedStatement.setFloat(17, purchaseInvoiceInformationDAO.getTotalNettAmount());
									preparedStatement.setString(18, entryBy);
									preparedStatement.setString(19, purchaseInvoiceInformationDAO.getPaymentType());
									preparedStatement.setString(20, purchaseInvoiceInformationDAO.getPurchaseBy());
									preparedStatement.setString(21, "REGULER");
									preparedStatement.setString(22, null);
									

								
							}
		        	}
	          		else
		        	{
	          			
		        		 sql = "UPDATE crusher_purchase_master "
		        		 		+ "SET "
									+ "purchase_invoice_number=?,"								
									+ "purchase_time=?,"	
									+ "tarnsportation_charges=?,"
									+ "comments=?,"
									+ "other_expenses=?,"
									+ "purchase_total_amount=?,"
									+ "purchase_amount_paid=?,"
									+ "purchase_total_igst_amount=?,"
									+ "purchase_total_cgst_amount=?,"
									+ "purchase_total_sgst_amount=?,"
									+ "purchase_total_nett_amount=?,"
									+ "purchase_entry_by=?,"
									+ "payemnt_type=?,"
									+ "purcahsed_by=? "
									+ "WHERE "
									+ "purchase_id = '"+purchaseInvoiceInformationDAO.getPurchaseId()+"'"
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
						 
						 
		        		 	preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, purchaseInvoiceInformationDAO.getInvoiceNumber());
							preparedStatement.setTime(2, time);
							preparedStatement.setString(3, this.getFrightCharges());
							preparedStatement.setString(4, this.getComments());
							preparedStatement.setString(5, this.getOtherExpense());								
							preparedStatement.setFloat(6, purchaseInvoiceInformationDAO.getPurchaseTotalAmount());
							preparedStatement.setFloat(7, this.getAmountPaid());
							preparedStatement.setFloat(8, purchaseInvoiceInformationDAO.getTotalIGST());
							preparedStatement.setFloat(9, purchaseInvoiceInformationDAO.getTotalCGST());
							preparedStatement.setFloat(10, purchaseInvoiceInformationDAO.getTotalSGST());
							preparedStatement.setFloat(11, purchaseInvoiceInformationDAO.getTotalNettAmount());							
							preparedStatement.setString(12, entryBy);							
							preparedStatement.setString(13, purchaseInvoiceInformationDAO.getPaymentType());					
						    preparedStatement.setString(14, purchaseInvoiceInformationDAO.getPurchaseBy());
							
							preparedStatement.setString(15, crusherId);
							preparedStatement.setString(16, crusherCode);
							
							
		        	}
	          		
	          		int rowsUpdated = preparedStatement.executeUpdate();
				          		
							if(fis != null)
							{
								fis.close();
								fis = null;
							}	
							
							if(rowsUpdated>0)
							{
								
								
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
								sql = "SELECT "
			  							+ "diesel_credit_debit_id,"
			  							+ "product_name,"
			  							+ "adblue_credit_debit_id "
			  							+ "FROM "
			  							+ "crusher_purchase_product_info_master "
			  							+ "WHERE "
					        			+ "purchase_id = ? "
					        			+ "AND "
					        			+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ?";
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setString(1,purchaseInvoiceInformationDAO.getPurchaseId());
					        	preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
								
								
								if(resultSet.next()){
									String dieselCreditDebitId = resultSet.getString(1);
									String productName = resultSet.getString(2);
									String adblueCreditDebitId = resultSet.getString(3);
									
									if(productName.trim().equals("DIESEL"))
									{
										
									
									sql = "SELECT "
											+ "entry_id,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details "
											+ "FROM "
											+ "diesel_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, dieselCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);

									
									resultSet = preparedStatement.executeQuery();
									
									int m = 0;
									if(resultSet.next())
									{
										
										PreparedStatement  insertIntoDeletedPSMT = null;
										
										String inertDeletedSQL = "INSERT "
												+ "INTO "
												+ "diesel_credit_debit_updated_entry_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
												+ "crusher_code,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details,"
												+ "old_quantity,"
												+ "updated_date,"
												+ "updated_time) "
												+ "VALUES "
												+ "(?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
										
										insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
										
										insertIntoDeletedPSMT.setString(1, dieselCreditDebitId);
										insertIntoDeletedPSMT.setString(2, crusherId);
										insertIntoDeletedPSMT.setString(3, crusherCode);
										insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
										insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
										insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
										insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
										insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
										insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
										insertIntoDeletedPSMT.setString(10, entryBy);
										insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
										insertIntoDeletedPSMT.setFloat(12, resultSet.getFloat(7));
										insertIntoDeletedPSMT.setString(13, purchaseInvoiceInformationDAO.getPurchaseDate());
										insertIntoDeletedPSMT.setTime(14,time);
										
										
										  m = insertIntoDeletedPSMT.executeUpdate();
										  
										  String paymentType = resultSet.getString(6);
										  
										  
										  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
											Date parsedDate = null;

											try {
											    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
											} catch (ParseException e) {
											    e.printStackTrace();  
											}

											if (parsedDate != null) {
											     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
											    String formattedDate = outputDateFormat.format(parsedDate); 
								
											    
										 
										    
										    
										  boolean isCloseingBalMaintained = false;
										  
										  if (paymentType.equals("CREDIT")) {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
										  }else {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
											  
										  }
											}
										  
										if(insertIntoDeletedPSMT != null)
										{
											insertIntoDeletedPSMT.close();
											insertIntoDeletedPSMT = null;
										}
										
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "diesel_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, dieselCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									
									
									if(k > 0 )
									{
										sql = "UPDATE "
		        	        					+ "crusher_purchase_product_info_master "
		        	        					+ "SET "
		        	        					+ "diesel_credit_debit_id = ? "
		        	        					+ "WHERE "
		    									+ "purchase_id = ? "
		    									+ "AND "
		    									+ "product_name = ? "
		    									+ "AND "
		    									+ "crusher_id = ? "
		    									+ "AND "
		    									+ "crusher_code = ? ";
		        	        			
		        	        			
			    						preparedStatement = connection.prepareStatement(sql);
			    						
			    						preparedStatement.setString(1, null);
			    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
			    						preparedStatement.setString(3, productName);
			    						preparedStatement.setString(4, crusherId);
			    		        		preparedStatement.setString(5, crusherCode);
			    		        		
			    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
			        				
			    						
			    						
									}
					    		}
								}
									
									
									
									if(productName.trim().equals("ADBLUE") || productName.trim().equals("DEF"))
									{
										
									
									sql = "SELECT "
											+ "entry_id,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details "
											+ "FROM "
											+ "adblue_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, adblueCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);

									
									resultSet = preparedStatement.executeQuery();
									
									int m = 0;
									if(resultSet.next())
									{
										
										PreparedStatement  insertIntoDeletedPSMT = null;
										
										String inertDeletedSQL = "INSERT "
												+ "INTO "
												+ "adblue_credit_debit_updated_entry_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
												+ "crusher_code,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details,"
												+ "old_quantity,"
												+ "updated_date,"
												+ "updated_time) "
												+ "VALUES "
												+ "(?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
										
										insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
										
										insertIntoDeletedPSMT.setString(1, adblueCreditDebitId);
										insertIntoDeletedPSMT.setString(2, crusherId);
										insertIntoDeletedPSMT.setString(3, crusherCode);
										insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
										insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
										insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
										insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
										insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
										insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
										insertIntoDeletedPSMT.setString(10, entryBy);
										insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
										insertIntoDeletedPSMT.setFloat(12, resultSet.getFloat(7));
										insertIntoDeletedPSMT.setString(13, purchaseInvoiceInformationDAO.getPurchaseDate());
										insertIntoDeletedPSMT.setTime(14,time);
										
										
										  m = insertIntoDeletedPSMT.executeUpdate();
										  
										  String paymentType = resultSet.getString(6);
										  
										  
										  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
											Date parsedDate = null;

											try {
											    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
											} catch (ParseException e) {
											    e.printStackTrace();  
											}

											if (parsedDate != null) {
											     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
											    String formattedDate = outputDateFormat.format(parsedDate); 
								
											    
										 
										    
										    
										  boolean isCloseingBalMaintained = false;
										  
										  if (paymentType.equals("CREDIT")) {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
										  }else {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
											  
										  }
											}
										  
										if(insertIntoDeletedPSMT != null)
										{
											insertIntoDeletedPSMT.close();
											insertIntoDeletedPSMT = null;
										}
										
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "adblue_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, adblueCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									
									
									if(k > 0 )
									{
										sql = "UPDATE "
		        	        					+ "crusher_purchase_product_info_master "
		        	        					+ "SET "
		        	        					+ "adblue_credit_debit_id = ? "
		        	        					+ "WHERE "
		    									+ "purchase_id = ? "
		    									+ "AND "
		    									+ "product_name = ? "
		    									+ "AND "
		    									+ "crusher_id = ? "
		    									+ "AND "
		    									+ "crusher_code = ? ";
		        	        			
		        	        			
			    						preparedStatement = connection.prepareStatement(sql);
			    						
			    						preparedStatement.setString(1, null);
			    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
			    						preparedStatement.setString(3, productName);
			    						preparedStatement.setString(4, crusherId);
			    		        		preparedStatement.setString(5, crusherCode);
			    		        		
			    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
			        				
			    						
			    						
									}
					    		}
								}
								
							}
								
								
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
								int rowsToDelete = 0;
								int rowsDeleted = 0;
								
								
								sql = "SELECT "
										+ "count(*) "
										+ "FROM "
										+ "crusher_purchase_product_info_master "
										+ "WHERE "
										+ "purchase_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								
								resultSet = preparedStatement.executeQuery();
								
								String productId = null ;
								String productName = null;
								float quantity = 0 ;
								
								boolean stockMinus = false;
								
								if(resultSet.next())
								{
									rowsToDelete = resultSet.getInt(1);


									

									sql = "SELECT "
											+ "product_id,"
											+ "product_name,"
											+ "purchase_quantity "
											+ "FROM "
											+ "crusher_purchase_product_info_master "
											+ "WHERE "
											+ "purchase_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									
									resultSet = preparedStatement.executeQuery();
									
									
									
									if(resultSet.next())
									{
										productId = resultSet.getString(1);
										productName = resultSet.getString(2);
										quantity = resultSet.getFloat(3);
										
										stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), productId, productName, quantity);
										
										
										
									}
									
									
								}
								
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								if(rowsToDelete>0)
								{
									sql = "DELETE "
											+ "FROM "
											+ "crusher_purchase_product_info_master "
											+ "WHERE purchase_id = '"+purchaseInvoiceInformationDAO.getPurchaseId()+"' "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, crusherId);
									preparedStatement.setString(2, crusherCode);
									
									rowsDeleted = preparedStatement.executeUpdate();
									
									
									if(rowsDeleted > 0)
									{
										
												
									}
									
								}
								
								
						if(rowsToDelete == rowsDeleted)
						{

								if(purchaseProductInfoList != null)
								{
										if(preparedStatement != null)
										{
											preparedStatement.close();
											preparedStatement = null;
										}
										
										sql = "INSERT INTO "
												+ "crusher_purchase_product_info_master "
												+ "("
												+ "purchase_id,"
												+ "crusher_id,"
						        				+ "crusher_code,"
						        				+ "product_id,"
												+ "product_name,"
												+ "purchase_unit,"
												+ "tax_percentage,"
												+ "purchase_rate,"
												+ "purchase_quantity,"
												+ "discount_percentage,"
												+ "discount_amount,"
												+ "purchase_total_amount_before_discount,"
												+ "purchase_total_amount_after_discount,"
												+ "rate_type,"
												+ "purchase_gross_amount,"
												+ "purchase_igst_amount,"
												+ "purchase_cgst_amount,"
												+ "purchase_sgst_amount"
												+ ") "
												+ "values"
												+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
										preparedStatement = connection.prepareStatement(sql);
										boolean stockAdded = false;
										
										for(PurchaseProductInfoDAO dao: purchaseProductInfoList)
										{
											preparedStatement.setString(1, purchaseInvoiceInformationDAO.getPurchaseId());
											preparedStatement.setString(2, crusherId);
							        		preparedStatement.setString(3, crusherCode);
							        		preparedStatement.setString(4, dao.getProductId());
											preparedStatement.setString(5, dao.getProductName());
											preparedStatement.setString(6, dao.getPurchaseUnit());
											preparedStatement.setFloat(7, dao.getTaxPercentage());
											preparedStatement.setFloat(8, dao.getPurchaseRate());
											preparedStatement.setFloat(9, dao.getQuantity());
											preparedStatement.setFloat(10, 0.0F);
											preparedStatement.setFloat(11, 0.0F);
											preparedStatement.setFloat(12, dao.getAmount());
											preparedStatement.setFloat(13, dao.getGrossAmount());
											preparedStatement.setString(14, dao.getRateType());
											preparedStatement.setFloat(15, dao.getNettAmount());
											preparedStatement.setFloat(16, dao.getIgst());
											preparedStatement.setFloat(17, dao.getCgst());
											preparedStatement.setFloat(18, dao.getSgst());
											
											
											preparedStatement.addBatch();
											
											stockAdded = UpdateProductStockDetails.addStockToCurrentStockForPurchase( connection, this.getSessionMap(),dao.getProductId(), dao.getProductName(), dao.getQuantity());
								
										
										}
										
										
										int [] numUpdates=preparedStatement.executeBatch();
										
										 for(PurchaseProductInfoDAO dao: purchaseProductInfoList)
											{
											 
											
										if(dao.getProductName().equals("DIESEL"))
										{
											if(preparedStatement != null)
											{
												preparedStatement.close();
												preparedStatement = null;
											}
											
											float stockConversionRatio = 0.0F;
											PreparedStatement updateStockPSMT= null;
											
											sql = "SELECT "
													+ "in_stock_quantity,"
													+ "stock_conversion_ratio "
													+ "FROM "
													+ "crusher_product_master "
													+ "WHERE "
													+ "product_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											updateStockPSMT = connection.prepareStatement(sql);
											
											updateStockPSMT.setString(1, dao.getProductId());
											updateStockPSMT.setString(2, crusherId);
											updateStockPSMT.setString(3, crusherCode);
											
									
											resultSet = updateStockPSMT.executeQuery();
											
											if(resultSet.next())
											{
												stockConversionRatio = resultSet.getFloat(2);
											}
											
											if(resultSet != null)
											{
												resultSet.close();
												resultSet = null;
											}
											
											
											
										sql = "SELECT "
												+ "entry_id "
												+ "FROM "
												+ "diesel_credit_debit_master "
												+ "WHERE "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? "
												+ "ORDER BY "
												+ "entry_id "
												+ "DESC LIMIT 1;";
										
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, crusherId);
									preparedStatement.setString(2, crusherCode);
									
									resultSet = preparedStatement.executeQuery();
									
									
									
									int dieselCreditDebitEntryId = 1;
									if(resultSet.next())
									{
										if(!(resultSet.getString(1) == null))
										{
											dieselCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
											dieselCreditDebitEntryId = dieselCreditDebitEntryId + 1;
											
										}
										
									}
									else
									{	dieselCreditDebitEntryId =1;
										
									}
									
					        		
					        		
					        		if(resultSet != null)
					        		{
					        			resultSet.close();
					        			resultSet = null;
					        		}
					        		if(preparedStatement!= null)
					        		{
					        			preparedStatement.close();
					        			preparedStatement = null;
					        		}
					        		
					        		
										sql = "INSERT "
												+ "INTO "
												+ "diesel_credit_debit_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
						        				+ "crusher_code,"
						        				+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details,"
												+ "entry_source) "
												+ "VALUES "
												+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
										
										
										preparedStatement = connection.prepareStatement(sql);
										
										preparedStatement.setInt(1, dieselCreditDebitEntryId);
										preparedStatement.setString(2, crusherId);
						        		preparedStatement.setString(3, crusherCode);
						        		preparedStatement.setString(4, dao.getProductId());
										preparedStatement.setString(5, dao.getProductName());
										preparedStatement.setString(6, purchaseInvoiceInformationDAO.getPurchaseDate());
										preparedStatement.setTime(7, time);
										preparedStatement.setString(8, "CREDIT");
										preparedStatement.setFloat(9, (dao.getQuantity() * stockConversionRatio));
										preparedStatement.setString(10, entryBy);
										preparedStatement.setString(11, "CREDITED BY - "+this.getSupplierName().split("-")[1]+" Against Purchase Id: "+purchaseInvoiceInformationDAO.getPurchaseId());
										preparedStatement.setString(12, "ADD PURCHASE");
										
										int rowInsetred = preparedStatement.executeUpdate();
										boolean isCloseingBalMaintained = false;
										
										if(rowInsetred > 0)
										{
											 isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(dao.getProductId(), dao.getProductName(),"CREDIT", purchaseInvoiceInformationDAO.getPurchaseDate(), (dao.getQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
											
										}
										
										if(isCloseingBalMaintained && rowInsetred > 0)
										{
											
											sql = "UPDATE "
			        	        					+ "crusher_purchase_product_info_master "
			        	        					+ "SET "
			        	        					+ "diesel_credit_debit_id = ? "
			        	        					+ "WHERE "
			    									+ "purchase_id = ? "
			    									+ "AND "
			    									+ "product_id = ? "
			    									+ "AND "
			    									+ "crusher_id = ? "
			    									+ "AND "
			    									+ "crusher_code = ? ";
			        	        			
			        	        			
				    						preparedStatement = connection.prepareStatement(sql);
				    						
				    						preparedStatement.setInt(1, dieselCreditDebitEntryId);
				    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
				    						preparedStatement.setString(3, dao.getProductId());
				    						preparedStatement.setString(4, crusherId);
				    		        		preparedStatement.setString(5, crusherCode);
				    		        		
				    					    preparedStatement.executeUpdate();
				        				
				    						
				    						
				    						
				    						
				    						
										}
										
										
										}
										
										
										
										if(dao.getProductName().equals("ADBLUE") || dao.getProductName().equals("DEF"))
										{
											if(preparedStatement != null)
											{
												preparedStatement.close();
												preparedStatement = null;
											}
											
											float stockConversionRatio = 0.0F;
											PreparedStatement updateStockPSMT= null;
											
											sql = "SELECT "
													+ "in_stock_quantity,"
													+ "stock_conversion_ratio "
													+ "FROM "
													+ "crusher_product_master "
													+ "WHERE "
													+ "product_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											updateStockPSMT = connection.prepareStatement(sql);
											
											updateStockPSMT.setString(1, dao.getProductId());
											updateStockPSMT.setString(2, crusherId);
											updateStockPSMT.setString(3, crusherCode);
											
									
											resultSet = updateStockPSMT.executeQuery();
											
											if(resultSet.next())
											{
												stockConversionRatio = resultSet.getFloat(2);
											}
											
											if(resultSet != null)
											{
												resultSet.close();
												resultSet = null;
											}
											
											
											
										sql = "SELECT "
												+ "entry_id "
												+ "FROM "
												+ "adblue_credit_debit_master "
												+ "WHERE "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? "
												+ "ORDER BY "
												+ "entry_id "
												+ "DESC LIMIT 1;";
										
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, crusherId);
									preparedStatement.setString(2, crusherCode);
									
									resultSet = preparedStatement.executeQuery();
									
									
									
									int adblueCreditDebitEntryId = 1;
									if(resultSet.next())
									{
										if(!(resultSet.getString(1) == null))
										{
											adblueCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
											adblueCreditDebitEntryId = adblueCreditDebitEntryId + 1;
											
										}
										
									}
									else
									{	adblueCreditDebitEntryId =1;
										
									}
									
					        		
					        		
					        		if(resultSet != null)
					        		{
					        			resultSet.close();
					        			resultSet = null;
					        		}
					        		if(preparedStatement!= null)
					        		{
					        			preparedStatement.close();
					        			preparedStatement = null;
					        		}
					        		
					        		
										sql = "INSERT "
												+ "INTO "
												+ "adblue_credit_debit_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
						        				+ "crusher_code,"
						        				+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details,"
												+ "entry_source) "
												+ "VALUES "
												+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
										
										
										preparedStatement = connection.prepareStatement(sql);
										
										preparedStatement.setInt(1, adblueCreditDebitEntryId);
										preparedStatement.setString(2, crusherId);
						        		preparedStatement.setString(3, crusherCode);
						        		preparedStatement.setString(4, dao.getProductId());
										preparedStatement.setString(5, dao.getProductName());
										preparedStatement.setString(6, purchaseInvoiceInformationDAO.getPurchaseDate());
										preparedStatement.setTime(7, time);
										preparedStatement.setString(8, "CREDIT");
										preparedStatement.setFloat(9, (dao.getQuantity() * stockConversionRatio));
										preparedStatement.setString(10, entryBy);
										preparedStatement.setString(11, "CREDITED BY - "+this.getSupplierName().split("-")[1]+" Against Purchase Id: "+purchaseInvoiceInformationDAO.getPurchaseId());
										preparedStatement.setString(12, "ADD PURCHASE");
										
										int rowInsetred = preparedStatement.executeUpdate();
										boolean isCloseingBalMaintained = false;
										
										if(rowInsetred > 0)
										{
											 isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(dao.getProductId(), dao.getProductName(),"CREDIT", purchaseInvoiceInformationDAO.getPurchaseDate(), (dao.getQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
											
										}
										
										if(isCloseingBalMaintained && rowInsetred > 0)
										{
											
											sql = "UPDATE "
			        	        					+ "crusher_purchase_product_info_master "
			        	        					+ "SET "
			        	        					+ "adblue_credit_debit_id = ? "
			        	        					+ "WHERE "
			    									+ "purchase_id = ? "
			    									+ "AND "
			    									+ "product_id = ? "
			    									+ "AND "
			    									+ "crusher_id = ? "
			    									+ "AND "
			    									+ "crusher_code = ? ";
			        	        			
			        	        			
				    						preparedStatement = connection.prepareStatement(sql);
				    						
				    						preparedStatement.setInt(1, adblueCreditDebitEntryId);
				    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
				    						preparedStatement.setString(3, dao.getProductId());
				    						preparedStatement.setString(4, crusherId);
				    		        		preparedStatement.setString(5, crusherCode);
				    		        		
				    					    preparedStatement.executeUpdate();
				        				
				    						
				    						
				    						
				    						
				    						
										}
										
										
										}
										
										
											}
										
										
										sql = "SELECT "
					  							+ "credit_debit_id "
					  							+ "FROM "
					  							+ "crusher_purchase_master "
					  							+ "WHERE "
							        			+ "purchase_id = ? "
							        			+ "AND "
							        			+ "supplier_id = ? "
							        			+ "AND "
							        			+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ?";
										
										preparedStatement = connection.prepareStatement(sql);
										
										preparedStatement.setString(1,purchaseInvoiceInformationDAO.getPurchaseId());
							        	preparedStatement.setString(2,purchaseInvoiceInformationDAO.getSupplierId());   
							        	preparedStatement.setString(3, crusherId);
										preparedStatement.setString(4, crusherCode);
										
										resultSet = preparedStatement.executeQuery();
										
										
										if(resultSet.next()){
											String crditDebitId = resultSet.getString(1);
											
											
											
											sql = "SELECT "
													+ "entry_id,"
													+ "account_id,"
													+ "account_number,"
													+ "entry_date,"
													+ "entry_time,"
													+ "entry_type,"
													+ "amount,"
													+ "payment_type,"
													+ "entry_by,"
													+ "entry_details "
													+ "FROM "
													+ "bank_account_credit_debit_master "
													+ "WHERE "
													+ "entry_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											preparedStatement = connection.prepareStatement(sql);
											preparedStatement.setString(1, crditDebitId);
											preparedStatement.setString(2, crusherId);
											preparedStatement.setString(3, crusherCode);

											
											resultSet = preparedStatement.executeQuery();
											
											int m = 0;
											if(resultSet.next())
											{
												
												PreparedStatement  insertIntoDeletedPSMT = null;
												
												String inertDeletedSQL = "INSERT "
														+ "INTO "
														+ "bank_account_credit_debit_updated_entry_master "
														+ "("
														+ "entry_id,"
														+ "crusher_id,"
														+ "crusher_code,"
														+ "account_id,"
														+ "account_number,"
														+ "entry_date,"
														+ "entry_time,"
														+ "entry_type,"
														+ "amount,"
														+ "payment_type,"
														+ "entry_by,"
														+ "entry_details,"
														+ "old_amount,"
														+ "updated_date,"
														+ "updated_time) "
														+ "VALUES "
														+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
												
												insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
												
												insertIntoDeletedPSMT.setString(1, crditDebitId);
												insertIntoDeletedPSMT.setString(2, crusherId);
												insertIntoDeletedPSMT.setString(3, crusherCode);
												insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
												insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
												insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
												insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
												insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
												insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
												insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
												insertIntoDeletedPSMT.setString(11, entryBy);
												insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
												insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
												insertIntoDeletedPSMT.setString(14, purchaseInvoiceInformationDAO.getPurchaseDate());
												insertIntoDeletedPSMT.setTime(15,time);
												
												
												  m = insertIntoDeletedPSMT.executeUpdate();
												  
												  String paymentType = resultSet.getString(6);
												  
												  
												  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
													Date parsedDate = null;

													try {
													    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
													} catch (ParseException e) {
													    e.printStackTrace();  
													}

													if (parsedDate != null) {
													     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
													    String formattedDate = outputDateFormat.format(parsedDate); 
										
													    
												 
												    
												    
												  boolean isCloseingBalMaintained = false;
												  
												  if (paymentType.equals("CREDIT")) {
												   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
												  }else {
													   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
													  
												  }
													}
												  
												if(insertIntoDeletedPSMT != null)
												{
													insertIntoDeletedPSMT.close();
													insertIntoDeletedPSMT = null;
												}
												
											}
											if(resultSet != null)
											{
												resultSet.close();
												resultSet = null;
											}
											if(preparedStatement != null)
											{
												preparedStatement.close();
												preparedStatement = null;
											}
											
											
											if(m>0)
											{
												
												
											
											sql = "DELETE "
													+ "FROM "
													+ "bank_account_credit_debit_master "
													+ "WHERE "
													+ "entry_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											preparedStatement = connection.prepareStatement(sql);
											preparedStatement.setString(1, crditDebitId);
											preparedStatement.setString(2, crusherId);
											preparedStatement.setString(3, crusherCode);
											
											int k = preparedStatement.executeUpdate();
											
											
											if(k > 0 )
											{
												sql = "UPDATE "
				        	        					+ "crusher_purchase_master "
				        	        					+ "SET "
				        	        					+ "credit_debit_id = ? "
				        	        					+ "WHERE "
				    									+ "purchase_id = ? "
				    									+ "AND "
				    									+ "crusher_id = ? "
				    									+ "AND "
				    									+ "crusher_code = ? ";
				        	        			
				        	        			
					    						preparedStatement = connection.prepareStatement(sql);
					    						
					    						preparedStatement.setString(1, null);
					    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
					    						preparedStatement.setString(3, crusherId);
					    		        		preparedStatement.setString(4, crusherCode);
					    		        		
					    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
					        				
					    						
					    						
											}
							    		}
										}
										
										
										
										
										
										if(purchaseProductInfoList.size() == numUpdates.length)
										{
											if(stockAdded)
											{
												
												if(preparedStatement != null)
												{
													preparedStatement.close();
													preparedStatement = null;
												}
												
												
												if(purchaseInvoiceInformationDAO.getPaymentType().equals("CASH"))
												{
													
													
													
													
													
												
												sql = "SELECT "
														+ "entry_id "
														+ "FROM "
														+ "bank_account_credit_debit_master "
														+ "WHERE "
														+ "crusher_id = ? "
														+ "AND "
														+ "crusher_code = ? "
														+ "ORDER BY "
														+ "entry_id "
														+ "DESC LIMIT 1;";
												
											
											preparedStatement = connection.prepareStatement(sql);
											preparedStatement.setString(1, crusherId);
											preparedStatement.setString(2, crusherCode);
											
											resultSet = preparedStatement.executeQuery();
											
											
											String purchaseIdString = purchaseInvoiceInformationDAO.getPurchaseId();

											
											int purchaseIdInt = Integer.parseInt(purchaseIdString);
											
											int bankEntryId = 1;
											if(resultSet.next())
											{
												if(!(resultSet.getString(1) == null))
												{
													bankEntryId = Integer.parseInt(resultSet.getString(1));
													bankEntryId = bankEntryId + 1;
													
												}
												
											}
											else
											{	bankEntryId =1;
												
											}
											
							        		if(resultSet != null)
							        		{
							        			resultSet.close();
							        			resultSet = null;
							        		}
							        		if(preparedStatement!= null)
							        		{
							        			preparedStatement.close();
							        			preparedStatement = null;
							        		}
							        		
							        		String accountNumber = "";
							        		sql = "SELECT "
							        				+ "account_number "
							        				+ "FROM "
							        				+ "crusher_bank_account "
							        				+ "WHERE "
							        				+ "account_id  = ?"
							        				+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
							        			
							        		preparedStatement = connection.prepareStatement(sql);
							        		
							        		preparedStatement.setString(1, this.getAccountId());
							        		preparedStatement.setString(2, crusherId);
											preparedStatement.setString(3, crusherCode);
											
							        		resultSet = preparedStatement.executeQuery();
							        		if(resultSet.next())
							        		{
							        			accountNumber = resultSet.getString(1);
							        		}
							        		
							        		if(resultSet != null)
							        		{
							        			resultSet.close();
							        			resultSet = null;
							        		}
							        		if(preparedStatement!= null)
							        		{
							        			preparedStatement.close();
							        			preparedStatement = null;
							        		}
							        		
							        		
												sql = "INSERT "
														+ "INTO "
														+ "bank_account_credit_debit_master "
														+ "("
														+ "entry_id,"
														+ "crusher_id,"
								        				+ "crusher_code,"
								        				+ "account_id,"
														+ "account_number,"
														+ "entry_date,"
														+ "entry_time,"
														+ "entry_type,"
														+ "amount,"
														+ "payment_type,"
														+ "entry_by,"
														+ "entry_details,"
														+ "entry_source) "
														+ "VALUES "
														+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
												
												preparedStatement = connection.prepareStatement(sql);
												
												preparedStatement.setInt(1, bankEntryId);
												preparedStatement.setString(2, crusherId);
								        		preparedStatement.setString(3, crusherCode);
								        		preparedStatement.setString(4, this.getAccountId());
												preparedStatement.setString(5, accountNumber);
												preparedStatement.setString(6, purchaseInvoiceInformationDAO.getPurchaseDate());
												preparedStatement.setTime(7, time);
												preparedStatement.setString(8, "DEBIT");
												preparedStatement.setFloat(9, this.getAmountPaid());
												preparedStatement.setString(10, this.getModeOfPayment());
												preparedStatement.setString(11, entryBy);
												preparedStatement.setString(12, "PAID BY "+this.getSupplierName()+" Against Purchase amount: "+this.getTotalPurchaseAmount());
												preparedStatement.setString(13, "ADD PURCHASE ");
												
												int rowInsetred = preparedStatement.executeUpdate();
												
												
												boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", purchaseInvoiceInformationDAO.getPurchaseDate(), this.getAmountPaid(), entryBy, connection, this.getSessionMap());
												
												if(isCloseingBalMaintained && rowInsetred > 0)
												{
													
													sql = "UPDATE "
					        	        					+ "crusher_purchase_master "
					        	        					+ "SET "
					        	        					+ "credit_debit_id = ? "
					        	        					+ "WHERE "
					    									+ "purchase_id = ? "
					    									+ "AND "
					    									+ "crusher_id = ? "
					    									+ "AND "
					    									+ "crusher_code = ? ";
					        	        			
					        	        			
						    						preparedStatement = connection.prepareStatement(sql);
						    						
						    						preparedStatement.setInt(1, bankEntryId);
						    						preparedStatement.setString(2, purchaseInvoiceInformationDAO.getPurchaseId());
						    						preparedStatement.setString(3, crusherId);
						    		        		preparedStatement.setString(4, crusherCode);
						    		        		
						    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
						        				
						    						
						    						
						    						if(rowCreditDebitIdInsetred > 0 )
						    						{
						    							connection.commit();
						    							result = "success";
						    							addActionMessage(this.getText("message.success.purchaseAccountDetailsAddedSuccessfully"));
						    						}
														
												}
												else
												{
													result = "error";
													addActionError(this.getText("message.error.errorPurchaseAccountDetailsNotAddedPlzTryAgain"));
												}
												}
												
												
												
												this.getSessionMap().remove("deletedProductInfoList");
												this.getSessionMap().remove("purchaseProductList");
									        	this.getSessionMap().remove("purchaseInformation");
										        	
												connection.commit();
												purchaseInvoiceInformationDAO.setPurchaseSaved(true);
												result="success";
												addActionMessage(this.getText("message.success.purchaseInvoiceSavedSuccessfully"));
											}
											else 
											{
												result="error";
												connection.rollback();
												addActionError(this.getText("message.error.errorWhileAddingStcokPlzTryAgain"));
												
											}
										}
										else
										{
											connection.rollback();
											result="error";
											addActionError("45. "+this.getText("message.error.purchaseInvoiceDetailsNotAddedPlzTryAgain"));
										}
									}
									else
									{
										connection.rollback();
										result="error";
										addActionError("56. "+this.getText("message.error.purchaseInvoiceDetailsNotAddedPlzTryAgain"));
									}
									
									
								
						}
						else
						{
							connection.rollback();
							result = "error";
							addActionError("78. "+this.getText("message.error.purchaseInformationNotSavedPlzTryAgain"));
							
						}
								
								
					}else
					{
						connection.rollback();
						result = "error";								
						addActionError(this.getText("message.error.purchaseDetailsNotInsertedPlzTryAgain"));
					}
						
		        	
		        }else
		        {
		        	result = "error";
		        	addActionError(this.getText("message.error.purchaseDetailsNotFoundPlzTryAgain"));
		        }
		        	
			   }catch (SQLException e) {
					e.printStackTrace();
					result = "error";	
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.purchaseDetailsNotSaved"));
					
				} catch (IOException e) {
					e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.purchaseDetailsNotSaved"));
				}finally 
				{
					if(resultSet != null)
	   				{
	   					try {resultSet.close();}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
			}
		        
		        
		        try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
		    	
		    	unitList = GetListResource.GetUnitList();
		    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
		   		
		    	
		    	
		    	 
	       	 float floatTotalPurchaseAmount = 0.0F;
	       	 float floatTotalCGST = 0.0F;
	       	 float floatTotalSGST = 0.0F;
	       	 float floatTotalIGST = 0.0F;
	       	 float floatTotalNettAmount = 0.0F;
	       	 

        	 for (PurchaseProductInfoDAO pProductInfoDAO : this.getPurchaseProductInfoList())
        	 {
        		
        			
        		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getGrossAmount();
        		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
        		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
        		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
        		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
        	 }
        	 
	       	 setTotalPurchaseAmount(""+df.format(floatTotalPurchaseAmount));
	       	 setTotalNettAmount(""+df.format(floatTotalNettAmount));
	       	 setTotalCGST(""+df.format(floatTotalCGST));
	       	 setTotalSGST(""+df.format(floatTotalSGST));
	       	 setTotalIGST(""+df.format(floatTotalIGST));
	   		
	       	 setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
	       	 setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
	       	 setSupplierName(purchaseInvoiceInformationDAO.getSupplierDetails());
	       	 setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
	      	this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
	      	
	      	
	    	
	       	 setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
	       	sessionMap.put("purchaseInformation", purchaseInvoiceInformationDAO);
	       	sessionMap.put("purchaseProductList", purchaseProductInfoList);
			
return result;
}

	@SuppressWarnings("unchecked")
	@Override
	public void validate() {

		 df = new DecimalFormat("0.00");
		purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
		purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
		
		this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
   		
		paymentTypeList2.add("CASH");
    	paymentTypeList2.add("UPI");
    	paymentTypeList2.add("RTGS");
    	paymentTypeList2.add("NEFT");
    	
		if(this.getPurchaseInvoiceInformationDAO().getPaymentType().equals("CASH"))
		{
			if(this.getAccountId().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectAccount"));
			}
		}
		if(getAmountPaid().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideAmountPaidValue"));
		}
		
		if(!hasActionErrors())
		{
			if(getAmountPaid()!=null || !getAmountPaid().equals("") )
					{
						Float amtPaid =0.0F; 
						
						
						try
						{
							amtPaid = this.getAmountPaid();
							
							if(amtPaid<0 || amtPaid > purchaseInvoiceInformationDAO.getPurchaseTotalAmount())
							{
								addActionError(this.getText("message.error.plzProvideAmountPaidValue"));
								addActionError(this.getText("message.error.amountPaidCannotBeLessThan0andCannotBeGreaterThanTotalAmount"));
							}
						}catch(NumberFormatException nfe)
						{
							addActionError(this.getText("message.error.plzProvideCorrectValueForAmountPaid"));
						}
					}
			
			
		}
		
		if(!hasActionErrors())
		{
			if(purchaseInvoiceInformationDAO.getPaymentType().equals("CREDIT") && this.getAmountPaid() > 0){
				addActionError(this.getText("message.error.paymentTypeIsCreditAmountPaidCannotBeGreaterThan0"));
			}
		}
		
		   try {
				taxList = GetListResource.GetTaxList();
				
			} catch (IOException e) {
				
			}
	   	
		 unitList = GetListResource.GetUnitList();
	  	 float floatTotalPurchaseAmount = 0.0F;
	  	 float floatTotalCGST = 0.0F;
	  	 float floatTotalSGST = 0.0F;
	  	 float floatTotalIGST = 0.0F;
	  	 float floatTotalNettAmount = 0.0F;
	  	 
	  	 for (PurchaseProductInfoDAO pProductInfoDAO : purchaseProductInfoList)
	  	 {
	  		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getAmount();
	  		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
	  		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
	  		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
	  		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
	  	 }
	  	 
	  	this.setTotalPurchaseAmount(""+df.format(floatTotalPurchaseAmount));
	  	this.setTotalNettAmount(""+df.format(floatTotalNettAmount));
	  	this.setTotalCGST(""+df.format(floatTotalCGST));
	  	this.setTotalSGST(""+df.format(floatTotalSGST));
	  	this.setTotalIGST(""+df.format(floatTotalIGST));
	  	this.setPurchaseBy(purchaseInvoiceInformationDAO.getPurchaseBy());
	  	this.setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
	  	this.setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
	  	this.setSupplierName(purchaseInvoiceInformationDAO.getSupplierDetails());
	  	this.setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
	  	this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
	
	  	this.setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
	  	this.getSessionMap().put("purchaseInformation", purchaseInvoiceInformationDAO);
	  	this.getSessionMap().put("purchaseProductList", purchaseProductInfoList);
		
		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    	this.setRateTyprDefaultValue("INCLUDINGGST");
	       
    	
    	
	  	this.setPaymentDefaultValue(this.getPaymentDefaultValue());
	}
@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}





public PurchaseInvoiceInformationDAO getPurchaseInvoiceInformationDAO() {
	return purchaseInvoiceInformationDAO;
}





public void setPurchaseInvoiceInformationDAO(PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO) {
	this.purchaseInvoiceInformationDAO = purchaseInvoiceInformationDAO;
}





public List<PurchaseProductInfoDAO> getPurchaseProductInfoList() {
	return purchaseProductInfoList;
}





public void setPurchaseProductInfoList(List<PurchaseProductInfoDAO> purchaseProductInfoList) {
	this.purchaseProductInfoList = purchaseProductInfoList;
}





public Map<String, String> getTaxList() {
	return taxList;
}





public void setTaxList(Map<String, String> taxList) {
	this.taxList = taxList;
}





public Map<String, String> getUnitList() {
	return unitList;
}





public void setUnitList(Map<String, String> unitList) {
	this.unitList = unitList;
}





public String getTotalPurchaseAmount() {
	return totalPurchaseAmount;
}





public void setTotalPurchaseAmount(String totalPurchaseAmount) {
	this.totalPurchaseAmount = totalPurchaseAmount;
}





public Float getAmountPaid() {
	return amountPaid;
}

public void setAmountPaid(Float amountPaid) {
	this.amountPaid = amountPaid;
}

public String getFrightCharges() {
	return frightCharges;
}





public void setFrightCharges(String frightCharges) {
	this.frightCharges = frightCharges;
}





public String getOtherExpense() {
	return otherExpense;
}





public void setOtherExpense(String otherExpense) {
	this.otherExpense = otherExpense;
}





public File getInvoiceImage() {
	return invoiceImage;
}





public void setInvoiceImage(File invoiceImage) {
	this.invoiceImage = invoiceImage;
}





public String getComments() {
	return comments;
}





public void setComments(String comments) {
	this.comments = comments;
}





public DecimalFormat getDf() {
	return df;
}





public void setDf(DecimalFormat df) {
	this.df = df;
}





public String getTotalNettAmount() {
	return totalNettAmount;
}





public void setTotalNettAmount(String totalNettAmount) {
	this.totalNettAmount = totalNettAmount;
}





public String getTotalCGST() {
	return totalCGST;
}





public void setTotalCGST(String totalCGST) {
	this.totalCGST = totalCGST;
}





public String getTotalSGST() {
	return totalSGST;
}





public void setTotalSGST(String totalSGST) {
	this.totalSGST = totalSGST;
}





public String getTotalIGST() {
	return totalIGST;
}





public void setTotalIGST(String totalIGST) {
	this.totalIGST = totalIGST;
}





public String getProductName() {
	return productName;
}





public void setProductName(String productName) {
	this.productName = productName;
}





public String getAmount() {
	return amount;
}





public void setAmount(String amount) {
	this.amount = amount;
}





public String getQuantity() {
	return quantity;
}





public void setQuantity(String quantity) {
	this.quantity = quantity;
}





public String getPurchaseUnit() {
	return purchaseUnit;
}





public void setPurchaseUnit(String purchaseUnit) {
	this.purchaseUnit = purchaseUnit;
}





public String getPurchaseRate() {
	return purchaseRate;
}





public void setPurchaseRate(String purchaseRate) {
	this.purchaseRate = purchaseRate;
}





public String getTaxId() {
	return taxId;
}





public void setTaxId(String taxId) {
	this.taxId = taxId;
}





public String getPurchaseId() {
	return purchaseId;
}





public void setPurchaseId(String purchaseId) {
	this.purchaseId = purchaseId;
}





public String getSupplierName() {
	return supplierName;
}





public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}





public String getInvoiceNumber() {
	return invoiceNumber;
}





public void setInvoiceNumber(String invoiceNumber) {
	this.invoiceNumber = invoiceNumber;
}





public String getInvoiceImageContentType() {
	return invoiceImageContentType;
}





public void setInvoiceImageContentType(String invoiceImageContentType) {
	this.invoiceImageContentType = invoiceImageContentType;
}





public boolean isAddToStock() {
	return addToStock;
}





public void setAddToStock(boolean addToStock) {
	this.addToStock = addToStock;
}





public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}





public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}





public String getCustomerSearchOption() {
	return customerSearchOption;
}





public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}





public String getDefaultValue() {
	return defaultValue;
}





public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}





public static long getSerialversionuid() {
	return serialVersionUID;
}

public String getPurchaseDateTime() {
	return purchaseDateTime;
}

public void setPurchaseDateTime(String purchaseDateTime) {
	this.purchaseDateTime = purchaseDateTime;
}

public String getPaymentType() {
	return paymentType;
}

public void setPaymentType(String paymentType) {
	this.paymentType = paymentType;
}

public Map<String, String> getPaymentTypeList() {
	return paymentTypeList;
}

public void setPaymentTypeList(Map<String, String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}

public String getPaymentDefaultValue() {
	return paymentDefaultValue;
}

public void setPaymentDefaultValue(String paymentDefaultValue) {
	this.paymentDefaultValue = paymentDefaultValue;
}

public String getPurchaseBy() {
	return purchaseBy;
}

public void setPurchaseBy(String purchaseBy) {
	this.purchaseBy = purchaseBy;
}

public Map<String, String> getRateTypeList() {
	return rateTypeList;
}

public void setRateTypeList(Map<String, String> rateTypeList) {
	this.rateTypeList = rateTypeList;
}

public String getRateTyprDefaultValue() {
	return rateTyprDefaultValue;
}

public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
	this.rateTyprDefaultValue = rateTyprDefaultValue;
}

public String getRateType() {
	return rateType;
}

public void setRateType(String rateType) {
	this.rateType = rateType;
}

public String getAccountId() {
	return accountId;
}

public void setAccountId(String accountId) {
	this.accountId = accountId;
}

public Map<String, String> getAccountList() {
	return accountList;
}

public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}

public List<String> getPaymentTypeList2() {
	return paymentTypeList2;
}

public void setPaymentTypeList2(List<String> paymentTypeList2) {
	this.paymentTypeList2 = paymentTypeList2;
}

public String getModeOfPayment() {
	return modeOfPayment;
}

public void setModeOfPayment(String modeOfPayment) {
	this.modeOfPayment = modeOfPayment;
}



}
