package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class SaveAndPrintQuotation extends ActionSupport implements SessionAware{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4205886934505595095L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private BillInformationDAO quotationInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String billNumber;
	private String billDateTime;
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private String chalanNumber;
	private String totalPaybleAmount;
	private Float amountPaid;
	private Float transportCharge;
	private String returnAmount;
	private String alternateMobileNumber;
	private boolean sendSMS;
	private boolean billSaved;
	private String addSideBarJs;

    private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	
	@SuppressWarnings("unchecked")
	public String execute() {
		
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	

	        	String billInfoTable = "quotation_info";
	        	String billInfoProductTable = "product_quotation_info";
	        	String ownerMessageProductName = "";
	        	String ownerMessageProductNameMarathi = "";
	        	String ownerMessageProductQty = "";
	        	String ownerMessageProductRate = "";
	        	String ownerMessageTotalAmt = "";
	        	String messageProductDetailsLine = "";
	        	String messageProductDetailsLineMar = "";
	        	String ownerMessageCustBal = "";
	        	String ownerMessageDestination = "";
	        	String ownerMessageVehicleMake = "";
	        	String ownerMessageVehicleNumber = "";
	        	
	          	
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String billedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		billedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		billedBy =fullUserName;
	        	}
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	
	        		String billDateTime = "";
	        		
	        		billDateTime = this.getQuotationInfoDAO().getBillDate();
	        		
	        		if(billDateTime == null || billDateTime == "" )
	        		{
	        			Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			        	billDateTime = dateFormat.format(d);
	        			
	        		}
	        		
	        	
		        	
		        Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("quotationProductList"));
	        	
	        	this.setQuotationInfoDAO((BillInformationDAO) this.getSessionMap().get("quotationInformation"));
	        	
	        	//System.out.print("Is Bill Saved : "+this.getBillInfoDAO().isBillSaved());
	       	
	        	
	        
	        	
	        	if(!this.getQuotationInfoDAO().isBillSaved())	        	
	        	{
	        		/*System.out.println("In Save Bill");
	        		
		        	Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");*/
		        	//String billDateTime = dateFormat.format(d);	        	
		        	
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	String materialNameForTripEntry = "";
		        	float materialQuantityForTripEntry = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		materialNameForTripEntry = infoDAO.getProductName();
		        		materialQuantityForTripEntry = infoDAO.getQuantity();
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	ownerMessageTotalAmt = ""+floatTotalAmtAfterDiscount;
	        	try
	        	{
	        		
	        		  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	connection.setAutoCommit(false);
	        	
	        	String [] custNameDetails= new String [5];
	        	try
	        	{
	        		String [] custNameDetails2 = this.getQuotationInfoDAO().getCustomerName().split("-");
	        		
	        		
	        		if(custNameDetails2.length == 2)
	        		{
	        			custNameDetails= new String [3];
	        			
	        			custNameDetails[0] = "1";
		        		custNameDetails[1] = custNameDetails2[0];
		        		custNameDetails[2] =  custNameDetails2[1];
	        		}
	        		
	        		else if(custNameDetails2.length < 2)
	        		{
	        			custNameDetails= new String [3];
	        			
	        			custNameDetails[0] = "1";
		        		custNameDetails[1] = this.getQuotationInfoDAO().getCustomerName();
		        		custNameDetails[2] = "9999999999";
	        		}
	        		else if(custNameDetails2.length > 2)
	        		{
	        			custNameDetails= new String [3];
	        			custNameDetails[0] = custNameDetails2[0];
		        		custNameDetails[1] = custNameDetails2[1];
		        		custNameDetails[2] =  custNameDetails2[2];
	        		}
	        		else if(custNameDetails2.length < 1)
	        		{
	        			custNameDetails= new String [3];
	        			custNameDetails[0] = "1";
		        		custNameDetails[1] = this.getQuotationInfoDAO().getCustomerName();
		        		custNameDetails[2] = "9999999999";
	        		}
	        		
	        		this.getQuotationInfoDAO().setCustomerName(custNameDetails[0]+"-"+custNameDetails[1]+"-"+custNameDetails[2]);
	    	        
	        	}
	        	catch (Exception e) {
	        		//e.printStackTrace();
	        		custNameDetails[0] = "1";
	        		custNameDetails[1] = this.getQuotationInfoDAO().getCustomerName();
	        		custNameDetails[2] = "9999999999";
	        		
	        		this.getQuotationInfoDAO().setCustomerName(custNameDetails[0]+"-"+custNameDetails[1]+"-"+custNameDetails[2]);
				}
	        	String [] custData = new String [5];
        		
        		String custId = "1";
        		
        		String customerId = "";
				String customerName = "";
				
				try
				{
					custId = custNameDetails[0];
					customerId = custNameDetails[0];
					customerName = custNameDetails[1];
					
				}catch(Exception e)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCustomerIdAndName"));
				}
        		
        		if(this.getQuotationInfoDAO().getBillNumber().equalsIgnoreCase("NA"))
				{
        		
					
					
					
        			sql = "SELECT quotationnumber "
        				    + "FROM " + billInfoTable + " "
        				    + "WHERE crusher_id = ? "
        				    + "AND crusher_code = ? "
        				    + "ORDER BY quotationnumber DESC LIMIT 1";

        		
        			
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
			
				int newBillNumber = 0;
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						newBillNumber = Integer.parseInt(resultSet.getString(1));
						
						
						this.getQuotationInfoDAO().setBillNumber(""+(newBillNumber+1));
					}
					else
					{
						newBillNumber =1;
						this.getQuotationInfoDAO().setBillNumber(""+(newBillNumber));
					
						
					}
				}
				else
				{	newBillNumber =1;
					this.getQuotationInfoDAO().setBillNumber(""+(newBillNumber));
				}
				}
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		
	        	if(getReturnAmount() == null || getReturnAmount().equals(""))
	        	{
	        		
	        		float amountPaid = 0.0F;
	        		try
	        		{
	        			amountPaid =this.getAmountPaid();
	        			
	        			this.setReturnAmount(""+(floatTotalAmtAfterDiscount-amountPaid));
	        		}
	        		catch(Exception e)
	        		{}
	        		
	        	}
	        	int countBillInfoInserted = 0;
	        	int countBillInfoUpdated = 0;
	        	
	        	int vehicleDetailsInserted = 0;
	        	int vehicleDetailsUpdated = 0;
	        	
	        	String vehicleOwnerName = "";
				String ownerMobileNumber = "";
				String vehicleDriverName = "";
				String driverMobileNumber = "";
				
	        	float transportChargeFloat = 0.0F;
	        	

        		String user = (String) this.getSessionMap().get("userFullName");
	        	String shortName = "";
	        	
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
	        	if(!this.getQuotationInfoDAO().isBillInformationInserted())
	        	{
	        		
	        		
	        		
	        		try{
	        			transportChargeFloat = this.getQuotationInfoDAO().getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		
	        	sql = "INSERT INTO "
	        			+  billInfoTable
	        			+ "( "
	        			+ "quotationnumber,"	        			
	        			+ "crusher_id,"	        			
	        			+ "crusher_code,"	        			
	        			+ "quotationtime,"
	        			+ "quotationdate,"
	        			+ "customername,"
	        			+ "transportcharges,"
	        			+ "comments,"
	        			+ "quotationtotalamount,"
	        			+ "custid, "
	        			+ "quotation_by,"
	        			+ "discount_type ) "
    					+ "VALUES "
    					+ "(?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?)";
	        			
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	
	        	
	        	
	        	preparedStatement.setString(1,this.getQuotationInfoDAO().getBillNumber());
	        	preparedStatement.setString(2,crusherId);
	        	preparedStatement.setString(3,crusherCode);
	           	preparedStatement.setTime(4, time);
	        	preparedStatement.setString(5,this.getQuotationInfoDAO().getBillDate());
	        	preparedStatement.setString(6,this.getQuotationInfoDAO().getCustomerName());
	        	preparedStatement.setFloat(7,this.getQuotationInfoDAO().getTransportCharge());
	        	preparedStatement.setString(8,this.getQuotationInfoDAO().getComments());
	        	preparedStatement.setString(9,""+(floatTotalAmtAfterDiscount+this.getQuotationInfoDAO().getTransportCharge()));
	        	preparedStatement.setString(10,custId);
	        	preparedStatement.setString(11,billedBy);
	        	preparedStatement.setString(12, this.getQuotationInfoDAO().getDiscountType());
	        	
	        	countBillInfoInserted = preparedStatement.executeUpdate();
	        	  			
				    			if(preparedStatement != null)
				    			{
				    				preparedStatement.close();
				    				preparedStatement = null;
				    				
				    			}
				    			
				    		
    						
	        	}
	        	
	        	
	        	
	        	if(countBillInfoInserted>0)
	        	{
	        		
	        		
	        		
	        	
	        			int listSize = this.getProductInfoList().size();
	        					
	        			
	        			sql = "INSERT INTO "+billInfoProductTable+" "
	        					+ "("
	        					+ "quotationnumber,"
	        					+ "crusher_id,"	        			
	    	        			+ "crusher_code,"	        			
	    	        			+ "productname,"
	        					+ "salesunit,"
	        					+ "taxpercentage,"
	        					+ "salesrate,"
	        					+ "quanity,"
	        					+ "discountpercentage,"
	        					+ "discountrupees,"
	        					+ "productamount,"
	        					+ "productamtafterdiscount,"
	        					+ "grossamount,"
	        					+ "igst,"
	        					+ "cgst,"
	        					+ "sgst,"
	        					+ "productnamemarathi)"
	        					+ "values "
	        					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			for(BillProductInfoDAO productInfoDAO : this.getProductInfoList())
	        			{
	        			
	        				
	        				DecimalFormat df= new DecimalFormat("##.##");
	        				ownerMessageProductName = productInfoDAO.getProductName();
	        				ownerMessageProductQty =  df.format(productInfoDAO.getQuantity());
	        				ownerMessageProductRate = df.format(productInfoDAO.getSalesRate());
	        				
	        				
	        				
	        			String marLine = productInfoDAO.getProductNameMarathi()+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			String s =	ownerMessageProductName+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			if(listSize==1)
	        			{
	        				messageProductDetailsLine = messageProductDetailsLine + s;        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine;
	        			}else
	        			{
		        			messageProductDetailsLine = messageProductDetailsLine + s + "\n";        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine + "\n";
	        			}
	        			
	        			
	        			
	        			
	        			preparedStatement.setString(1, this.getQuotationInfoDAO().getBillNumber());
	        			preparedStatement.setString(2,crusherId);
	    	        	preparedStatement.setString(3,crusherCode);
	    	            preparedStatement.setString(4, productInfoDAO.getProductName());
	        			preparedStatement.setString(5, productInfoDAO.getSalesUnit());
	        			preparedStatement.setString(6, productInfoDAO.getTaxId());
	        			preparedStatement.setFloat(7, productInfoDAO.getSalesRate());
	        			preparedStatement.setFloat(8, productInfoDAO.getQuantity());
	        			preparedStatement.setFloat(9, productInfoDAO.getDiscountPecentage());
	        			preparedStatement.setFloat(10, productInfoDAO.getDiscountRupees());
	        			preparedStatement.setFloat(11, productInfoDAO.getAmount());
	        			preparedStatement.setFloat(12, productInfoDAO.getAmountAfterDiscount());
	        			preparedStatement.setFloat(13, productInfoDAO.getGrossAmount());
	        			preparedStatement.setFloat(14, productInfoDAO.getIgst());
	        			preparedStatement.setFloat(15, productInfoDAO.getCgst());
	        			preparedStatement.setFloat(16, productInfoDAO.getSgst());
	        			preparedStatement.setString(17, productInfoDAO.getProductNameMarathi());
	        			
	        			 preparedStatement.addBatch();
	        			
	        			ownerMessageProductNameMarathi = productInfoDAO.getProductNameMarathi();
	        			
	        			listSize--;
	        			}
	        			
	        			
	        			int [] rowInstredCount = preparedStatement.executeBatch();
	        			
	        			if(rowInstredCount.length == this.getProductInfoList().size())
	        			{
	        				if(countBillInfoInserted > 0)
	        				{
	        					this.getQuotationInfoDAO().setBillInformationInserted(true);
	        				}
	        				
	        				
	    	        		this.getQuotationInfoDAO().setBillSaved(true);
	    	        		this.setBillSaved(true);
	    	        		this.setBillDateTime(this.getQuotationInfoDAO().getBillDate());
	    	        		this.setCustomerName(this.getQuotationInfoDAO().getCustomerName());
	    	        		this.setBillNumber(this.getQuotationInfoDAO().getBillNumber());
	    	        		this.setBillType(this.getQuotationInfoDAO().getBillType());
	    	        		this.setAlternateMobileNumber(this.getQuotationInfoDAO().getCustomerMobile());
	    	        		this.setSendSMS(this.getQuotationInfoDAO().isSendSMS());
	    	        		this.setTotalAmount(""+(floatTotalAmount+this.getQuotationInfoDAO().getTransportCharge()));	        	
	    	        		this.setTotalDiscount(""+(floatTotalDiscount+this.getQuotationInfoDAO().getTransportCharge()));
	    	        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getQuotationInfoDAO().getTransportCharge()));
	    		        	
	    	          	this.setDefaultValue(this.getQuotationInfoDAO().getPaymentType());
	    		        	

	    		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
	    		        	
	    		        	unitList = GetListResource.GetUnitList();
	    		       	
	    	        		addActionMessage(this.getText("message.success.quotationDetailsSavedSuccessfully"));
	    	        		
	    	        		this.getSessionMap().put("quotationInformation", this.getQuotationInfoDAO());
	    	        		this.getSessionMap().put("quotationProductList", this.getProductInfoList());
	    	        		
	    	        		
				        	
									connection.commit();
									result = SUCCESS;
	    	        		
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.quotationNotSavedProperly"));
	        			}
	        			
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.sryQuotationDetailsNotSaved"));
	        	}
	        	
	        	
	        	
	        	
	        	
    			
	        		
	        	}
	        	catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					try {connection.rollback();} catch (SQLException e1) {}
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 "+this.getText("message.error.quotationDetailsNotSavedSuccessfully"));
				} catch (IOException e) {
					//e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||2 "+this.getText("message.error.quotationDetailsNotSavedSuccessfully"));
				}finally {
					if(resultSet != null)
	   				{
	   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
					}
	        	}
	        	else
	        	{
	        		
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	
		        	
	        		this.getSessionMap().put("quotationProductList", this.getProductInfoList());
	        		
	        		setCustomerName(this.getQuotationInfoDAO().getCustomerName());
	        		setBillNumber(this.getQuotationInfoDAO().getBillNumber());
	        		setBillType(this.getQuotationInfoDAO().getBillType());
	        		setTransportCharge(this.getQuotationInfoDAO().getTransportCharge());
	        		//System.out.println(getAlternateMobileNumber());
	        		
	        		setAlternateMobileNumber(this.getQuotationInfoDAO().getCustomerMobile());
	        		setSendSMS(this.getQuotationInfoDAO().isSendSMS());
	        		float transportCharge = 0.0F;
	        		
		        	if(!this.getQuotationInfoDAO().getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = this.getQuotationInfoDAO().getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
		        		}
		        	}
		        	
		        	if(!hasActionErrors())
		        	{
			        	setTotalAmount(""+(floatTotalAmount));	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	else
		        	{
		        		setTotalAmount(""+floatTotalAmount);	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	
	        		
		        	setDefaultValue(this.getQuotationInfoDAO().getPaymentType());
		        	

		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	this.getSessionMap().put("quotationInformation", this.getQuotationInfoDAO());
	        		this.getSessionMap().put("quotationProductList", this.getProductInfoList());
	        		result = "success";
	        		addActionError(this.getText("message.error.quotationAlreadySaved"));
	        	}
	        	
	        }
	       // System.out.print(result);
	        return result;
		
	}
	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("quotationProductList");		        	
    	quotationInfoDAO = (BillInformationDAO) this.getSessionMap().get("quotationInformation");
    	
    	this.setAddSideBarJs("FALSE");
    	
    	 discountTypeList.put("", "Select Discount Type");
	      discountTypeList.put("By Quantity", "By Quantity");
	      discountTypeList.put("By Percentage", "By Percentage");
	      discountTypeList.put("By Direct Amount", "By Direct Amount");
			
	
		
	 	
    	float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
    	{
    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
    		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
    		
    	}
    	
    	this.setTransportCharge(this.getQuotationInfoDAO().getTransportCharge());
    	this.setCustomerName(this.getQuotationInfoDAO().getCustomerName());
    	this.setBillNumber(this.getQuotationInfoDAO().getBillNumber());
    	this.setBillType(this.getQuotationInfoDAO().getBillType());
    	this.setBillDateTime(this.getQuotationInfoDAO().getBillDate());
    	this.setChalanNumber(this.getQuotationInfoDAO().getChalanNumber());
		float transportCharge = 0.0F;
		if(!this.getQuotationInfoDAO().getTransportCharge().equals("")){
    		
    		try
    		{
    			transportCharge = this.getQuotationInfoDAO().getTransportCharge();
    		}catch(NumberFormatException nfe)
    		{
    			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
    		}
    	}
    	
    	
		this.setTotalAmount(""+(floatTotalAmount+transportCharge));	        	
		this.setTotalDiscount(""+floatTotalDiscount);
		this.setTotalPaybleAmount(""+(floatTotalAmount+transportCharge));
		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+transportCharge));
        	//addActionMessage("Product added successfully to list !");
    	
    	
		
    	this.setDefaultValue(this.getQuotationInfoDAO().getPaymentType());
    	

    	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
    	
    	unitList = GetListResource.GetUnitList();
     	session=ServletActionContext.getRequest().getSession(false); 
  	
		this.getSessionMap().put("quotationInformation", this.getQuotationInfoDAO());
		this.getSessionMap().put("quotationProductList", this.getProductInfoList());
	
	}
	
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public BillInformationDAO getQuotationInfoDAO() {
		return quotationInfoDAO;
	}
	public void setQuotationInfoDAO(BillInformationDAO quotationInfoDAO) {
		this.quotationInfoDAO = quotationInfoDAO;
	}
	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}
	
	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public void setTotalPaybleAmount(String totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	
	


	public Float getAmountPaid() {
		return amountPaid;
	}
	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}
	public String getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}



	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}



	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	public boolean isBillSaved() {
		return billSaved;
	}
	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}
	public String getBillDateTime() {
		return billDateTime;
	}
	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getChalanNumber() {
		return chalanNumber;
	}
	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}
	public Float getTransportCharge() {
		return transportCharge;
	}
	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public String getDiscountType() {
		return discountType;
	}
	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}
	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}
	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}

	
	

	
}

