package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.BoulderInwardInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetNewIdForNewEntry;
import com.opensymphony.xwork2.ActionSupport;

public class GenerateBoulderInwardBillType1 extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2266192387070061026L;
	private SessionMap<String,Object> sessionMap;  
	
	private String fromDate;
	private String toDate;
	private String boulderSupplierId;
	private String vehicleId;
	private List<BoulderInwardInfoDAO> boulderInwardList = new ArrayList<BoulderInwardInfoDAO>();
	
	
	private int totalTrips;
	private String boulderSuppName;
	private Float mtonQuantity = 0.0f;
	private Float brassQuantity = 0.0f;
	
	private Float mtonRate;
	private Float brassRate;
	
	private Float mtonQtyAmount;
	private Float brassQtyAmount;
	
	private Float totalBillAmount;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
				
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					this.setBrassQtyAmount(this.getBrassRate() * this.getBrassQuantity());
					this.setMtonQtyAmount(this.getMtonRate() * this.getMtonQuantity());
					
					this.setTotalBillAmount(this.getBrassQtyAmount() + this.getMtonQtyAmount());
					
					
					int newId = GetNewIdForNewEntry.getNewIdForNewEntry("boulder_inward_bill_info", "entry_id", this.getSessionMap(), connection);
			
					Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        
				  java.util.Date date = new java.util.Date();
        	      long t = date.getTime();	        	     
        	      java.sql.Time time = new java.sql.Time(t);
        	      
        	      String fullUserName = (String) this.getSessionMap().get("userFullName");
	  	        	
	  	        	String splitUserName [] = new String[5];
	  	        	
	  	        	String entryBy = "";
	  	        	try
	  	        	{
	  	        		splitUserName = fullUserName.split(" ");
	  	        		entryBy = splitUserName[0];
	  	        		
	  	        	}catch(Exception e)
	  	        	{
	  	        		entryBy =fullUserName;
	  	        	}
				
					sql = "INSERT INTO "
							+ "boulder_inward_bill_info "
							+ "("
							+ "entry_id,"
							+ "crusher_id,"
							+ "crusher_code,"
							+ "entry_date,"
							+ "entry_time,"
							+ "bill_calculation_from_date,"
							+ "bill_calculation_to_date,"
							+ "boulder_supp_id,"
							+ "boulder_supp_name,"
							+ "total_trip_count,"
							+ "brass_quantity,"
							+ "brass_rate,"
							+ "brass_amount,"
							+ "mton_quantity,"
							+ "mton_rate,"
							+ "mton_amount,"
							+ "total_bill_amount,"
							+ "entry_by,"
							+ "details) "
							+ "VALUES "
							+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,STR_TO_DATE(?,'%d-%m-%Y')"
							+ ",STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setInt(1, newId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, dateFormat.format(d));
					preparedStatement.setTime(5, time);
					preparedStatement.setString(6, this.getFromDate());
					preparedStatement.setString(7, this.getToDate());
					preparedStatement.setString(8, boulderSuppDetails[0]);
					preparedStatement.setString(9, boulderSuppDetails[1]);
					preparedStatement.setInt(10, this.getTotalTrips());
					preparedStatement.setFloat(11, this.getBrassQuantity());
					preparedStatement.setFloat(12, this.getBrassRate());
					preparedStatement.setFloat(13, this.getBrassQtyAmount());
					preparedStatement.setFloat(14, this.getMtonQuantity());
					preparedStatement.setFloat(15, this.getMtonRate());
					preparedStatement.setFloat(16, this.getMtonQtyAmount());
					preparedStatement.setFloat(17, this.getBrassQtyAmount() + this.getMtonQtyAmount());
					preparedStatement.setString(18, entryBy);
					preparedStatement.setString(19, "Bill Calculated for "+this.getFromDate()
					+" to "+this.getToDate()+", total trips - "+this.getTotalTrips());
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						
						
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						
						sql = "SELECT "
								+ "indetails.entry_id,"
								+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
								+ "indetails.vehicle_id,"
								+ "indetails.vehicle_number,"
								+ "indetails.boulder_quantity,"
								+ "indetails.boulder_quantity_unit,"
								+ "indetails.inward_from,"
								+ "indetails.inward_to,"
								+ "indetails.entry_by,"
								+ "indetails.bill_generated_status,"
								+ "vemap.boulder_supplier_id "
								+ "FROM "
								+ "boulder_inward_details AS indetails "
								+ "INNER JOIN "
								+ "boulder_supplier_vehicle_mapping_master AS vemap "
								+ "ON "
								+ "indetails.vehicle_id = vemap.vehicle_id "
								+ "WHERE "
								+ "indetails.crusher_id = ? "
								+ "AND "
								+ "indetails.crusher_code = ? "
								+ "AND "
								+ "vemap.crusher_id = ? "
								+ "AND "
								+ "vemap.crusher_code = ? "
								+ "AND "
								+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "vemap.boulder_supplier_id = ? "
								+ "AND "
								+ "indetails.inward_from = 'QUARRY' ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
						preparedStatement.setString(7, boulderSuppDetails[0]);
						
						resultSet = preparedStatement.executeQuery();
						
						
						String updateInwardStatusSQL = "UPDATE boulder_inward_details "
								+ "SET "
								+ "bill_generated_status = 'YES' "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "AND "
								+ "inward_date = STR_TO_DATE(?,'%d-%m-%Y') ";
						
						PreparedStatement updateInwardStatusPSMT = connection.prepareStatement(updateInwardStatusSQL);
						
						while(resultSet.next())
						{
						
							updateInwardStatusPSMT.setString(1, resultSet.getString(1));
							updateInwardStatusPSMT.setString(2, crusherId);
							updateInwardStatusPSMT.setString(3, crusherCode);
							updateInwardStatusPSMT.setString(4, resultSet.getString(2));
							
							updateInwardStatusPSMT.addBatch();
						
						}
						
						int [] rowUpdated = updateInwardStatusPSMT.executeBatch();
						
						
						if(rowUpdated.length == this.getTotalTrips())
						{
							connection.commit();
							result = SUCCESS;
							addActionMessage("Bill Generated Successfully!");
						}
						else
						{
							connection.rollback();
							result = ERROR;
							addActionError("Bill not generated! Please try again!");
						}
					}
					else
					{
						connection.rollback();
						result = ERROR;
						addActionError("Bill not generated! Please try again!");
					}
						
					
					
					
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = "error";
					
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong 1!");
				}
				catch (Exception e) {
					e.printStackTrace();
					
					try {
						connection.rollback();
					} catch (SQLException e1) {}
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong 2!");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        
	       return result;
	}
	
	@Override
	public void validate() {
		
	
		if(this.getBrassRate() == null)
		{
			addActionError("Please provide correct brass rate!");
		}
		else if(this.getBrassRate() < 0)
		{
			addActionError("Please provide correct brass rate!");
		}
		
		if(!hasActionErrors())
		{
			if(this.getMtonRate() == null)
			{
				addActionError("Please provide correct MTON Rate!");
			}
			else if(this.getMtonRate() < 0)
			{
				addActionError("Please provide correct MTON Rate!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalBillAmount() == null)
			{
				addActionError("Please provide total bill amount!");
			}
			else if(this.getTotalBillAmount() < 0)
			{
				addActionError("Please provide total bill amount!");
			}
		}
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}
	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}
	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}
	public String getVehicleId() {
		return vehicleId;
	}
	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}
	public List<BoulderInwardInfoDAO> getBoulderInwardList() {
		return boulderInwardList;
	}
	public void setBoulderInwardList(List<BoulderInwardInfoDAO> boulderInwardList) {
		this.boulderInwardList = boulderInwardList;
	}
	public int getTotalTrips() {
		return totalTrips;
	}
	public void setTotalTrips(int totalTrips) {
		this.totalTrips = totalTrips;
	}
	public String getBoulderSuppName() {
		return boulderSuppName;
	}
	public void setBoulderSuppName(String boulderSuppName) {
		this.boulderSuppName = boulderSuppName;
	}
	public Float getMtonQuantity() {
		return mtonQuantity;
	}
	public void setMtonQuantity(Float mtonQuantity) {
		this.mtonQuantity = mtonQuantity;
	}
	public Float getBrassQuantity() {
		return brassQuantity;
	}
	public void setBrassQuantity(Float brassQuantity) {
		this.brassQuantity = brassQuantity;
	}
	public Float getMtonRate() {
		return mtonRate;
	}
	public void setMtonRate(Float mtonRate) {
		this.mtonRate = mtonRate;
	}
	public Float getBrassRate() {
		return brassRate;
	}
	public void setBrassRate(Float brassRate) {
		this.brassRate = brassRate;
	}
	public Float getMtonQtyAmount() {
		return mtonQtyAmount;
	}
	public void setMtonQtyAmount(Float mtonQtyAmount) {
		this.mtonQtyAmount = mtonQtyAmount;
	}
	public Float getBrassQtyAmount() {
		return brassQtyAmount;
	}
	public void setBrassQtyAmount(Float brassQtyAmount) {
		this.brassQtyAmount = brassQtyAmount;
	}
	public Float getTotalBillAmount() {
		return totalBillAmount;
	}
	public void setTotalBillAmount(Float totalBillAmount) {
		this.totalBillAmount = totalBillAmount;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

}



