package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class CalculateAndAddLaborSalaryDetails extends ActionSupport implements SessionAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7942440388806883989L;
	private String LaborIdName;
	private String fromDate;
	private String toDate;
	private SessionMap<String,Object> sessionMap;
	private Integer noOfDaysAbsentDays;
	private Integer noOfOverTime;
	private Integer noOfHalfDays;
	private Integer noOfDaysInMonth;
	private Integer noOfFullDays;
	private Float additionalDeduction;
	private Float additionalPayment;
	private String totalSalary;
	private String comments;
	private String addSideBarJs;
	private String key;
	private boolean salarySaved;
	
	
	public String execute() {
		 
		String result = "login";
	      if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					
					String user = (String)this.getSessionMap().get("userFullName");
					String shortName = "";
					
					try
					{
						shortName = user.split(" ")[0];
					}catch(Exception e)
					{
						shortName = user;
					}
					
					
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "entry_id "
							+ "FROM "
							+ "crusher_employee_salary_calculation_details "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "entry_id "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 1;
				
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId =resultSet.getInt(1);
						
						
						entryId = entryId+1;
					}
					else
					{
						entryId =1;
					}
				}
					
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	    		
				java.util.Date date = new java.util.Date();
      	      long t = date.getTime();	        	     
      	      java.sql.Time time = new java.sql.Time(t);
				
					String [] laborDetails = this.getLaborIdName().split("-");
					
					String laborId = laborDetails[0];
					String laborName = laborDetails[1];
					
					sql = "INSERT "
							+ "INTO "
							+ "crusher_employee_salary_calculation_details "
							+ "("
							+ "entry_id,"
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "entry_date,"
							+ "entry_time,"
							+ "salary_from_date,"
							+ "salary_to_date,"
							+ "employee_id,"
							+ "employee_name,"
							+ "no_of_day_in_month,"
							+ "no_of_absent_days,"
							+ "no_of_over_time,"
							+ "no_of_half_days,"
							+ "no_of_full_days_present,"
							+ "additional_deduction_amount,"
							+ "additional_payment_amount,"
							+ "total_calculated_salary_amount,"
							+ "comments,"
							+ "entry_by) "
							+ "VALUES "
							+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,STR_TO_DATE(?,'%d-%m-%Y'),STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, entryId);
					preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		preparedStatement.setString(4, dateFormat.format(d));
					preparedStatement.setTime(5, time);
					preparedStatement.setString(6, this.getFromDate());
					preparedStatement.setString(7, this.getToDate());
					preparedStatement.setString(8, laborId);
					preparedStatement.setString(9, laborName);
					preparedStatement.setInt(10, this.getNoOfDaysInMonth());
					preparedStatement.setInt(11, this.getNoOfDaysAbsentDays());
					preparedStatement.setInt(12, this.getNoOfOverTime());
					preparedStatement.setInt(13, this.getNoOfHalfDays());
					preparedStatement.setInt(14, this.getNoOfFullDays());
					preparedStatement.setFloat(15, this.getAdditionalDeduction());
					preparedStatement.setFloat(16, this.getAdditionalPayment());
					preparedStatement.setString(17, this.getTotalSalary());
					preparedStatement.setString(18, this.getComments());
					preparedStatement.setString(19, shortName);
					
					int rowCount = preparedStatement.executeUpdate();
					
					if(rowCount > 0)
					{
						this.setKey(EncryptionDecryption.encrypt(entryId+"#"+laborId));
						this.setSalarySaved(true);
						result = SUCCESS;
						
						this.setLaborIdName("");
						this.setNoOfDaysInMonth(0);
						this.setNoOfDaysAbsentDays(0);
						this.setNoOfFullDays(0);
						this.setNoOfHalfDays(0);
						this.setNoOfOverTime(0);
						this.setAdditionalDeduction(0f);
						this.setAdditionalPayment(0f);
						this.setTotalSalary("0");
						
						addActionMessage(this.getText("message.success.salaryDetailsAddedSuccessfully"));
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
						
					}
					
					
				}catch (SQLException e) {
					e.printStackTrace();
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				} catch (IOException e) {
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				}finally {
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{						
						try {connection.close();connection = null;}catch (SQLException e) {}
					}
				}
	        }
	      
	      return result;
	}
	@Override
	public void validate() {
		this.setAddSideBarJs("FALSE");
		
		if(this.getFromDate() == null || this.getFromDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectFromDate"));
		}
		
		if(!hasActionErrors()){
			if(this.getToDate() == null || this.getToDate().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectToDate"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideLaborDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalSalary() == null || this.getTotalSalary().equals(""))
			{
				addActionError(this.getText("message.error.plzProviAllOtherDetails"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			String isEntryAdded = "false";
			
			String [] result = new String[2];
			String condition = "AND salary_from_date = STR_TO_DATE('"+this.getFromDate()+"','%d-%m-%Y')";
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_employee_salary_calculation_details", "employee_id", condition , this.getLaborIdName().split("-")[0]);
			
			isEntryAdded = result[0];
			
			if(isEntryAdded.equals("true"))
			{
				addActionError(this.getText("message.error.salaryDetailsAlreadyAddedForThisEmployeeForThisDates"));
			}				
			
		}
	}
	

	public String getLaborIdName() {
		return LaborIdName;
	}


	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}


	public Integer getNoOfDaysAbsentDays() {
		return noOfDaysAbsentDays;
	}


	public void setNoOfDaysAbsentDays(Integer noOfDaysAbsentDays) {
		this.noOfDaysAbsentDays = noOfDaysAbsentDays;
	}


	public Integer getNoOfOverTime() {
		return noOfOverTime;
	}


	public void setNoOfOverTime(Integer noOfOverTime) {
		this.noOfOverTime = noOfOverTime;
	}


	public Integer getNoOfHalfDays() {
		return noOfHalfDays;
	}


	public void setNoOfHalfDays(Integer noOfHalfDays) {
		this.noOfHalfDays = noOfHalfDays;
	}


	public Integer getNoOfDaysInMonth() {
		return noOfDaysInMonth;
	}


	public void setNoOfDaysInMonth(Integer noOfDaysInMonth) {
		this.noOfDaysInMonth = noOfDaysInMonth;
	}


	public Integer getNoOfFullDays() {
		return noOfFullDays;
	}


	public void setNoOfFullDays(Integer noOfFullDays) {
		this.noOfFullDays = noOfFullDays;
	}


	public Float getAdditionalDeduction() {
		return additionalDeduction;
	}


	public void setAdditionalDeduction(Float additionalDeduction) {
		this.additionalDeduction = additionalDeduction;
	}


	public Float getAdditionalPayment() {
		return additionalPayment;
	}


	public void setAdditionalPayment(Float additionalPayment) {
		this.additionalPayment = additionalPayment;
	}


	public String getTotalSalary() {
		return totalSalary;
	}


	public void setTotalSalary(String totalSalary) {
		this.totalSalary = totalSalary;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public boolean isSalarySaved() {
		return salarySaved;
	}
	public void setSalarySaved(boolean salarySaved) {
		this.salarySaved = salarySaved;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	
}
