package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;


import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.infrawhatsappmsg.SendWhatsAppMessage;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetCustomerTotalCreditAmountById;
import com.stonecrusher.utils.MaintainCloseingBalUtil;


public class BillSaveAndAddNew extends ActionSupport implements SessionAware{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4205886934505595095L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private BillInformationDAO billInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;	
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String billNumber;
	private String billDateTime;
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private String chalanNumber;
	private String totalPaybleAmount;
	private Float amountPaid;
	private Float transportCharge;
	private String returnAmount;
	private String alternateMobileNumber;
	private boolean sendSMS;
	private String addSideBarJs;
	private boolean billSaved;
	
	
	private List<String> paymentTypeList2 = new ArrayList<String>();
	private String modeOfPayment;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();

	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
    private String keyVehicle;
	
	private Boolean isFromVehicleEntryDetails ;
	private boolean viewBill;
    private String discountType;
    private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private Integer totalTrips;
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	@SuppressWarnings("unchecked")
	public String execute() {
		
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	String ownerMessageCustName = "";
	        	String ownerMessageProductName = "";
	        	String ownerMessageProductNameMarathi = "";
	        	String ownerMessageProductQty = "";
	        	String ownerMessageProductRate = "";
	        	String ownerMessageTotalAmt = "";
	        	String messageProductDetailsLine = "";
	        	String messageProductDetailsLineMar = "";
	        	String ownerMessageCustBal = "";
	        	String ownerMessageDestination = "";
	        	String ownerMessageVehicleMake = "";
	        	String ownerMessageVehicleNumber = "";
	        	
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String billedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		billedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		billedBy =fullUserName;
	        	}
	        	
	        	
	        	if((getAmountPaid() == null || getAmountPaid().equals("")) && (getReturnAmount() == null || getReturnAmount().equals("")))
	        	{
	        		
	        		
	        		this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("productList"));		        	
		        	this.setBillInfoDAO((BillInformationDAO) this.getSessionMap().get("billInformation"));
		        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("billvehicleinfo"));
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	this.setCustomerName(this.getBillInfoDAO().getCustomerName());
		        	this.setBillNumber(this.getBillInfoDAO().getBillNumber());
		        	this.setBillType(this.getBillInfoDAO().getBillType());
	        		
		        	this.setTotalAmount(""+floatTotalAmount);	        	
		        	this.setTotalDiscount(""+floatTotalDiscount);
		        	this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()));
		        
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	this.setDefaultValue(this.getBillInfoDAO().getPaymentType());
		        	

		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	
		        	
		        	addActionError(this.getText("message.error.plzProvideAmountPaidAndAmountReturn"));
	        		
	        		this.getSessionMap().put("billInformation", this.getBillInfoDAO());
	        		this.getSessionMap().put("productList", this.getProductInfoList());
	        		result = "error";
		        	
	        	}
	        	else
	        	{
	        		
	        		String billDateTime = "";
	        		
	        		billDateTime = this.getBillInfoDAO().getBillDate();
	        		
	        		if(billDateTime == null || billDateTime == "" )
	        		{
	        			Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			        	billDateTime = dateFormat.format(d);
	        			
	        		}
	        		
	        	
		        	
		        Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("productList"));
	        	
	        	this.setBillInfoDAO((BillInformationDAO) this.getSessionMap().get("billInformation"));
	        	
	        	//System.out.print("Is Bill Saved : "+this.getBillInfoDAO().isBillSaved());
	        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("billvehicleinfo"));
	        	if(!this.getBillInfoDAO().isBillSaved())	        	
	        	{
	        		if(this.getBillInfoDAO().getTransportCharge() == null)
	        		{
	        			this.getBillInfoDAO().setTransportCharge(0.0f);
	        		}
	        		/*System.out.println("In Save Bill");
	        		
		        	Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");*/
		        	//String billDateTime = dateFormat.format(d);	        	
		        	
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	String productId = "";
		        	String materialNameForTripEntry = "";
		        	float materialQuantityForTripEntry = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		productId = infoDAO.getProductId();
		        		materialNameForTripEntry = infoDAO.getProductName();
		        		materialQuantityForTripEntry = infoDAO.getQuantity();
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();		        		
		        	}
		        	
		        	ownerMessageTotalAmt = ""+floatTotalAmtAfterDiscount;
	        	try
	        	{
	        		
	        		  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	connection.setAutoCommit(false);
	        	
	        	String [] custData = new String [5];
        		
        		String custId = "NA";
        		
        		
        		try
        		{
        			custData = this.getBillInfoDAO().getCustomerName().split("-");
        			custId = custData[0];
        		}
        		catch(Exception e)
        		{
        			//e.printStackTrace();
        			custId = "NA";
        		}
        		
        		
        		if(this.getBillInfoDAO().getBillNumber().equalsIgnoreCase("NA"))
				{
        		
        			if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
        			{
        				sql = "SELECT "
    							+ "bill_number "
    							+ "FROM "
    							+ "crusher_bill_info_tax_invoice_master "
    							+ "WHERE "
    							+ "bill_type = 'TAX-INVOICE' "    						
    							+ "AND crusher_id = ? "
    					        + "AND crusher_code = ? "
    							+ "ORDER BY "
    							+ "bill_number  "
    							+ "DESC LIMIT 1;";
        				
        			}else
        			{
        			
					sql = "SELECT "
							+ "bill_number "
							+ "FROM "
							+ "crusher_bill_info_master "
							+ "WHERE "
							+ "bill_type <> 'TAX-INVOICE' "						
							+ "AND crusher_id = ? "
					        + "AND crusher_code = ? "
							+ "ORDER BY "
							+ "bill_number  "
							+ "DESC LIMIT 1;";
					}
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
			
				int newBillNumber = 0;
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						newBillNumber = Integer.parseInt(resultSet.getString(1));
						
						
						this.getBillInfoDAO().setBillNumber(""+(newBillNumber+1));
					}
					else
					{
						newBillNumber =1;
						this.getBillInfoDAO().setBillNumber(""+(newBillNumber));
					
						
					}
				}
				else
				{	newBillNumber =1;
					this.getBillInfoDAO().setBillNumber(""+(newBillNumber));
				}
				}
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		
	        	if(getReturnAmount() == null || getReturnAmount().equals(""))
	        	{
	        		
	        		float amountPaid = 0.0F;
	        		try
	        		{
	        			amountPaid =this.getAmountPaid();
	        			
	        			this.setReturnAmount(""+(floatTotalAmtAfterDiscount-amountPaid));
	        		}
	        		catch(Exception e)
	        		{}
	        		
	        	}
	        	int countBillInfoInserted = 0;
	        	int countBillInfoUpdated = 0;
	        	
	        	int vehicleDetailsInserted = 0;
	        	int vehicleDetailsUpdated = 0;
	        	
	        	String vehicleOwnerName = "";
				String ownerMobileNumber = "";
				String vehicleDriverName = "";
				String driverMobileNumber = "";
				
	        	float transportChargeFloat = 0.0F;
	        	

        		String user = (String) this.getSessionMap().get("userFullName");
	        	String shortName = "";
	        	String [] customerDetails = new String[5];
				String customerId = "";
				String customerName = "";
				
				try
				{
					customerDetails = this.getCustomerName().split("-");
					customerId = customerDetails[0];
					customerName = customerDetails[1];
					
				}catch(Exception e)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCustomerIdAndName"));
				}
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
	        	if(!this.getBillInfoDAO().isBillInformationInserted())
	        	{
	        		
	        		
	        		try{
	        			transportChargeFloat = this.getBillInfoDAO().getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		
	        		String tableBillInfo;
	        		
	        		if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
        			{
	        			tableBillInfo = "crusher_bill_info_tax_invoice_master ";
        			}else {
        				tableBillInfo = "crusher_bill_info_master ";
        			}
        				
	        		
	                sql = "INSERT INTO " + tableBillInfo + " ( "
	        		    + "bill_number,"
	        			+ "crusher_id,"
	        			+ "crusher_code,"	        			
	        			+ "bill_date,"
	        			+ "bill_time,"
	        			+ "payment_type,"
	        			+ "bill_type,"
	        			+ "customer_id,"
	        			+ "customer_name,"
	        			+ "transportation_charges,"
	        			+ "comments,"
	        			+ "bill_total_amount,"
	        			+ "bill_amount_received,"
	        			+ "bill_amount_return,"
	        			+ "cash_amount, "
	        			+ "bank_rtgs_upi_amount,"
	        			+ "billed_by,"
	        			+ "vehicle_id,"
	        			+ "chalan_number,"
	        			+ "bill_status,"
	        			+ "discount_type) "
    					+ "VALUES "
    					+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	String [] custNameDetails= this.getBillInfoDAO().getCustomerName().split("-");
	        	ownerMessageCustName = custNameDetails[1]+"-"+custNameDetails[2];
	        	
	        	preparedStatement.setString(1,this.getBillInfoDAO().getBillNumber());
	        	preparedStatement.setString(2,crusherId);
	        	preparedStatement.setString(3,crusherCode);
	        	preparedStatement.setString(4,this.getBillInfoDAO().getBillDate());		        
	           	preparedStatement.setTime(5, time);
	        	preparedStatement.setString(6,this.getBillInfoDAO().getPaymentType());
	        	preparedStatement.setString(7,this.getBillInfoDAO().getBillType());
	        	preparedStatement.setString(8, custId);
	        	preparedStatement.setString(9,this.getBillInfoDAO().getCustomerName());
	        	preparedStatement.setDouble(10,(double)this.getBillInfoDAO().getTransportCharge());	
	        	preparedStatement.setString(11,this.getBillInfoDAO().getComments());
	        	preparedStatement.setDouble(12,floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge());
	        	preparedStatement.setString(13,""+this.getAmountPaid());
	        	preparedStatement.setDouble(14,Double.parseDouble(this.getReturnAmount()));
	        	preparedStatement.setFloat(15,this.getAmountPaid());
	        	preparedStatement.setFloat(16,0.0F);
	        	preparedStatement.setString(17, billedBy);
	        	preparedStatement.setString(18, this.getBillVehicleInfoDAO().getVehicleId());	        	
	        	preparedStatement.setString(19, this.getBillInfoDAO().getChalanNumber());
	        	preparedStatement.setString(20, "REGULER");
	        	preparedStatement.setString(21, this.getBillInfoDAO().getDiscountType());
	        	countBillInfoInserted = preparedStatement.executeUpdate();
	        	
					        	
				
					        
				    			
				    			if(preparedStatement != null)
				    			{
				    				preparedStatement.close();
				    				preparedStatement = null;
				    				
				    			}
				    			
				    			String tableTripInfo;
				        		
				        		if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
			        			{
				        			tableTripInfo = "crusher_vehicle_trip_tax_invoice_master ";
			        			}else {
			        				tableTripInfo = "crusher_vehicle_trip_master ";
			        			}
			        				
				        				
				                		
				
								sql = "SELECT "
										+ "trip_entry_id "
										+ "FROM "
										+ tableTripInfo
										+ "WHERE "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? "
										+ "ORDER BY "
										+ "trip_entry_id "
										+ "DESC LIMIT 1;";
								
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crusherId);
							preparedStatement.setString(2, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
						
							int newTripId = 1;
							if(resultSet.next())
							{
								if(!(resultSet.getString(1) == null))
								{
									newTripId = Integer.parseInt(resultSet.getString(1));
									
									
									newTripId= newTripId+1;
								}
								else
								{
									newTripId =1;
									
								}
							}
							else
							{	
								newTripId =1;						
							}
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							
							
						
							
						
							
								
							
							sql = "SELECT "
									+ "vehicle_make,"
									+ "vehicle_registration_number,"
									+ "owner_name,"
									+ "owner_mobile_number,"
									+ "driver_name,"
									+ "driver_mobile_number "
									+ "FROM "
									+ "crusher_vehicle_details_master "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
							
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, this.getBillVehicleInfoDAO().getVehicleId());
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							if(resultSet.next())
							{
								ownerMessageVehicleMake = resultSet.getString(1);
								ownerMessageVehicleNumber = resultSet.getString(2);
								vehicleOwnerName = resultSet.getString(3);
								ownerMobileNumber = resultSet.getString(4);
								vehicleDriverName = resultSet.getString(5);
								driverMobileNumber = resultSet.getString(6);
							}
									
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
								int rowAdded = 0;
								
								
                            
				        		
				        		
								sql = "INSERT "
										+ "INTO "
										+ tableTripInfo
										+ "("
										+ "trip_entry_id,"
										+ "crusher_id,"
										+ "crusher_code,"
										+ "trip_date,"
										+ "trip_time,"
										+ "bill_number,"
										+ "vehicle_id,"
										+ "customer_id,"
										+ "customer_name,"
										+ "product_id,"
										+ "product_name,"
										+ "product_quantity,"
										+ "vehicle_km_start,"
										+ "vehicle_km_end,"
										+ "trip_total_km,"
										+ "trip_start_from,"
										+ "trip_end_to,"
										+ "total_trip_count,"
										+ "trip_driver_name,"
										+ "trip_driver_mobile_number,"
										+ "bill_type,"
										+ "transportation_charges,"
										+ "product_empty_weight,"
										+ "product_gross_weight) "
										+ "VALUES "
										+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setInt(1, newTripId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								preparedStatement.setString(4, this.getBillInfoDAO().getBillDate());
								preparedStatement.setTime(5, time);
								preparedStatement.setString(6,this.getBillInfoDAO().getBillNumber());
								preparedStatement.setString(7, this.getBillVehicleInfoDAO().getVehicleId());
								preparedStatement.setString(8, customerId);
								preparedStatement.setString(9, customerName);
								preparedStatement.setString(10, this.getBillVehicleInfoDAO().getProductId());
								preparedStatement.setString(11, this.getBillVehicleInfoDAO().getProductName());
								preparedStatement.setFloat(12, this.getBillVehicleInfoDAO().getProductQuantity());
								preparedStatement.setFloat(13, this.getBillVehicleInfoDAO().getKmStart());
								preparedStatement.setFloat(14, this.getBillVehicleInfoDAO().getKmEnd());
								preparedStatement.setFloat(15, this.getBillVehicleInfoDAO().getTotalKM());
								preparedStatement.setString(16, this.getBillVehicleInfoDAO().getTripFrom());
								preparedStatement.setString(17, this.getBillVehicleInfoDAO().getTripTo());
								preparedStatement.setFloat(18, this.getBillVehicleInfoDAO().getTotalTrips());							
								preparedStatement.setString(19, vehicleDriverName);
								preparedStatement.setString(20, driverMobileNumber);
								preparedStatement.setString(21, this.getBillInfoDAO().getBillType());
								preparedStatement.setFloat(22, this.getBillInfoDAO().getTransportCharge());
                                if(this.getBillVehicleInfoDAO().getVehicleEmptyWeight() != null)
                                {
                                	preparedStatement.setFloat(23, this.getBillVehicleInfoDAO().getVehicleEmptyWeight());
    								
                                }else {
                                	preparedStatement.setFloat(23, 0.0f);
    								
                                }
                                if(this.getBillVehicleInfoDAO().getGrossWeight() != null)
                                {
                                	preparedStatement.setFloat(24, this.getBillVehicleInfoDAO().getGrossWeight());
    									
                                }else {
                                	preparedStatement.setFloat(24, 0.0f);
    								
                                }
								
								vehicleDetailsInserted = preparedStatement.executeUpdate();
			        			
								
	        	
	        	}
	        	else
	        	{

	        		try{
	        			transportChargeFloat = this.getBillInfoDAO().getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		
	        		
	        		
	        		String tableBillInfo;
	        		
	        		if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
        			{
	        			tableBillInfo = "crusher_bill_info_tax_invoice_master ";
        			}else {
        				tableBillInfo = "crusher_bill_info_master ";
        			}
	        		
	        		
	        		
	        		sql = "UPDATE "
	        				+ tableBillInfo
	        				+ "SET "
	        				+ "bill_time=?,"
		        			+ "bill_date=STR_TO_DATE(?,'%d-%m-%Y'),"
		        			+ "payment_type=?,"
		        			+ "bill_type=?,"
		        			+ "transportation_charges=?,"
		        			+ "comments=?,"
		        			+ "bill_total_amount=?,"
		        			+ "bill_amount_received=?,"
		        			+ "bill_amount_return=?,"
		        			+ "chalan_number=?,"
		        			+ "discount_type=? "		        			        			
		        			+ "WHERE "
		        			+ "bill_number = ? "
		        			+ "AND "
		        			+ "customer_id = ? "
		        			+ "AND "
		        			+ "bill_type = ? "
		        			+ "AND "
		        			+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	        		
	        		preparedStatement = connection.prepareStatement(sql);  	
		        	
		        	
		           	preparedStatement.setTime(1, time);
		        	preparedStatement.setString(2, this.getBillInfoDAO().getBillDate());
		        	preparedStatement.setString(3,this.getBillInfoDAO().getPaymentType());
		        	preparedStatement.setString(4,this.getBillInfoDAO().getBillType());
		        	preparedStatement.setFloat(5,this.getBillInfoDAO().getTransportCharge());
		        	preparedStatement.setString(6,this.getBillInfoDAO().getComments());
		        	preparedStatement.setString(7,""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()));
		        	preparedStatement.setFloat(8,this.getAmountPaid());
		        	preparedStatement.setString(9,this.getReturnAmount());
		        	preparedStatement.setString(10, this.getBillInfoDAO().getChalanNumber());
		        	preparedStatement.setString(11,this.getBillInfoDAO().getDiscountType());
		        	preparedStatement.setString(12,this.getBillInfoDAO().getBillNumber());
		        	preparedStatement.setString(13,custId);   
		        	preparedStatement.setString(14, this.getBillInfoDAO().getBillType());
		        	preparedStatement.setString(15, crusherId);
					preparedStatement.setString(16, crusherCode);
					
		        	countBillInfoUpdated = preparedStatement.executeUpdate();
		        	
		        	if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					
                          String tableTripInfo;
	        		
	        		if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
        			{
	        			tableTripInfo = "crusher_vehicle_trip_tax_invoice_master ";
        			}else {
        				tableTripInfo = "crusher_vehicle_trip_master ";
        			}
	        		
	        		
	        		
					
					sql = "UPDATE "
							+ tableTripInfo
							+ "SET "
							+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y'), "
							+ "trip_time = ?, "
							+ "vehicle_id=?, "
							+ "product_id = ?, "
							+ "product_name = ? ,"
							+ "product_quantity = ?, "
							+ "vehicle_km_start = ?, "
							+ "vehicle_km_end = ?, "
							+ "trip_total_km = ?, "
							+ "trip_start_from = ?, "
							+ "trip_end_to = ?, "
							+ "total_trip_count = ?, "
							+ "product_empty_weight = ?, "
							+ "product_gross_weight = ? "
							+ "WHERE "
							+ "bill_number = ? "
							+ "AND "
							+ "bill_type = ? "
							+ "AND "
		        			+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, this.getBillInfoDAO().getBillDate());
					preparedStatement.setTime(2, time);
					preparedStatement.setString(3, this.getBillVehicleInfoDAO().getVehicleId());
					preparedStatement.setString(4, this.getBillVehicleInfoDAO().getProductId());
					preparedStatement.setString(5, this.getBillVehicleInfoDAO().getProductName());
					preparedStatement.setFloat(6, this.getBillVehicleInfoDAO().getProductQuantity());
					preparedStatement.setFloat(7, this.getBillVehicleInfoDAO().getKmStart());
					preparedStatement.setFloat(8, this.getBillVehicleInfoDAO().getKmEnd());
					preparedStatement.setFloat(9, this.getBillVehicleInfoDAO().getTotalKM());
					preparedStatement.setString(10, this.getBillVehicleInfoDAO().getTripFrom());
					preparedStatement.setString(11, this.getBillVehicleInfoDAO().getTripTo());
					preparedStatement.setInt(12, this.getBillVehicleInfoDAO().getTotalTrips());
					
					
					if(this.getBillVehicleInfoDAO().getVehicleEmptyWeight() != null)
                    {
						preparedStatement.setFloat(13, this.getBillVehicleInfoDAO().getVehicleEmptyWeight());
						
                    }else {
                    	preparedStatement.setFloat(13, 0.0f);
						
                    }
                    if(this.getBillVehicleInfoDAO().getGrossWeight() != null)
                    {
                    	preparedStatement.setFloat(14, this.getBillVehicleInfoDAO().getGrossWeight());
    						
                    }else {
                    	preparedStatement.setFloat(14, 0.0f);
						
                    }
                    
					preparedStatement.setString(15, this.getBillInfoDAO().getBillNumber());
					preparedStatement.setString(16, this.getBillInfoDAO().getBillType());
					preparedStatement.setString(17, crusherId);
					preparedStatement.setString(18, crusherCode);
					
					vehicleDetailsUpdated=preparedStatement.executeUpdate();
					
					
					}
	        		
	        	
	        	
	        	
	        	
	        	if((countBillInfoInserted>0 || countBillInfoUpdated > 0) && (vehicleDetailsInserted >0 || vehicleDetailsUpdated >0))
	        	{
	        		
	        		
	        		if(preparedStatement != null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
                   String tableProductInfo;
	        		
	        		if(this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
        			{
	        			tableProductInfo = "crusher_bill_tax_invoice_product_info ";
        			}else {
        				tableProductInfo = "crusher_bill_product_info ";
        			}
        				
	        		
	        		
	        		sql = "SELECT "
	        				+ "product_name "
	        				+ "FROM "
	        				+ tableProductInfo
	        				+ "WHERE "
	        				+ "bill_number = ? "
	        				+ "AND "
	        				+ "bill_type = ?"
	        				+ "AND "
		        			+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	        		
	        		
	        		preparedStatement = connection.prepareStatement(sql);
	        		preparedStatement.setString(1, this.getBillNumber());
	        		preparedStatement.setString(2, this.getBillType());
	        		preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
	        		resultSet = preparedStatement.executeQuery();
	        		
	        		resultSet.last();
	        		int rowCount = resultSet.getRow();
	        		resultSet.beforeFirst();
	        		
	        		
	        		if(rowCount > 0)
	        		{
	        			if(preparedStatement != null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
	        			
	        			sql = "DELETE FROM "+tableProductInfo 
	        					+ "WHERE bill_number = ? "
	        					+ "AND "
	        					+ "bill_type = ? "
	        					+ "AND "
			        			+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			preparedStatement.setString(1, this.getBillNumber());
		        		preparedStatement.setString(2, this.getBillType());
		        		preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						
	        			preparedStatement.executeUpdate(); 	        			
	        			
	        		}
	        			int productInserted = 0;
	        			int listSize = this.getProductInfoList().size();
	        			
	        			for(BillProductInfoDAO productInfoDAO : this.getProductInfoList())
	        			{
	        				if(preparedStatement != null)
	    	        		{
	    	        			preparedStatement.close();
	    	        			preparedStatement = null;
	    	        		}
	        				
	        				DecimalFormat df= new DecimalFormat("##.##");
	        				ownerMessageProductName = productInfoDAO.getProductName();
	        				ownerMessageProductQty =  df.format(productInfoDAO.getQuantity());
	        				ownerMessageProductRate = df.format(productInfoDAO.getSalesRate());
	        				
	        				
	        				
	        			String marLine = productInfoDAO.getProductNameMarathi()+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			String s =	ownerMessageProductName+" x "+ownerMessageProductQty+" x "+ownerMessageProductRate;
	        			if(listSize==1)
	        			{
	        				messageProductDetailsLine = messageProductDetailsLine + s;        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine;
	        			}else
	        			{
		        			messageProductDetailsLine = messageProductDetailsLine + s + "\n";        			
		        			messageProductDetailsLineMar = messageProductDetailsLineMar + marLine + "\n";
	        			}
	        			
	        			
	        			
	        			if ("1".equals(this.getSessionMap().get("royaltyAllowed")) && !"TAX-INVOICE".equals(this.getBillType())) 
	        		
	        			{
	        			   	
	        			    	
	        			sql = "INSERT INTO "+tableProductInfo
	        					+ "("
	        					+ "bill_number,"
	        					+ "crusher_id,"
	        					+ "crusher_code,"
	        					+ "product_id,"
	        					+ "product_name,"
	        					+ "sales_unit,"
	        					+ "tax_percentage,"
	        					+ "sales_rate,"
	        					+ "sale_quantity,"
	        					+ "discount_percentage,"
	        					+ "total_discount_amount,"
	        					+ "product_sale_amount_before_discount,"
	        					+ "product_sale_amount_after_discount,"
	        					+ "product_gross_amount,"
	        					+ "product_igst,"
	        					+ "product_cgst_amount,"
	        					+ "product_sgst_amount,"
	        					+ "product_name_marathi,"
	        					+ "bill_type,"
	        					+ "transport_charge,"
	        					+ "rate_type,"
	        					+ "royalty,"
	        					+ "sale_vehicle_empty_weight,"
	        					+ "sale_vehicle_gross_weight) "
	        					+ "values "
	        					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, this.getBillInfoDAO().getBillNumber());
	        			preparedStatement.setString(2, crusherId);
	        			preparedStatement.setString(3, crusherCode);
	        			preparedStatement.setString(4, productInfoDAO.getProductId());
	        			preparedStatement.setString(5, productInfoDAO.getProductName());
	        			preparedStatement.setString(6, productInfoDAO.getSalesUnit());
	        			preparedStatement.setString(7, productInfoDAO.getTaxId());
	        			preparedStatement.setDouble(8, (double)productInfoDAO.getSalesRate());
	        			preparedStatement.setFloat(9, productInfoDAO.getQuantity());
	        			preparedStatement.setFloat(10, productInfoDAO.getDiscountPecentage());
	        			preparedStatement.setFloat(11, productInfoDAO.getDiscountRupees());
	        			preparedStatement.setDouble(12, (double)productInfoDAO.getAmount());
	        			preparedStatement.setDouble(13, (double)productInfoDAO.getAmountAfterDiscount());
	        			preparedStatement.setDouble(14, (double)productInfoDAO.getGrossAmount());
	        			preparedStatement.setFloat(15, productInfoDAO.getIgst());
	        			preparedStatement.setFloat(16, productInfoDAO.getCgst());
	        			preparedStatement.setFloat(17, productInfoDAO.getSgst());
	        			preparedStatement.setString(18, productInfoDAO.getProductNameMarathi());
	        			preparedStatement.setString(19, this.getBillInfoDAO().getBillType());
	        			preparedStatement.setFloat(20, productInfoDAO.getTransportCharges());
	        			preparedStatement.setString(21, productInfoDAO.getRateType());
	        			preparedStatement.setFloat(22, productInfoDAO.getRoyalty());
	        			
	        			if(productInfoDAO.getVehicleEmptyWeight() != null) {
	        				preparedStatement.setFloat(23, productInfoDAO.getVehicleEmptyWeight());
		        			
	        			}else {
	        				preparedStatement.setFloat(23, 0.0f);
		        			
	        			}
	        			if(productInfoDAO.getGrossWeight() != null)
	        			{
	        				preparedStatement.setFloat(24, productInfoDAO.getGrossWeight());
		        			
	        			}else {
	        				preparedStatement.setFloat(24, 0.0f);
		        			
	        			}
	        			
	        			productInserted = productInserted +  preparedStatement.executeUpdate();
	        			
	        			ownerMessageProductNameMarathi = productInfoDAO.getProductNameMarathi();
	        			
	        			listSize--;
	        			
	        			
	        			    }else {
	        			    	
	        			    	
	        			    	sql = "INSERT INTO "+tableProductInfo
	    	        					+ "("
	    	        					+ "bill_number,"
	    	        					+ "crusher_id,"
	    	        					+ "crusher_code,"
	    	        					+ "product_id,"
	    	        					+ "product_name,"
	    	        					+ "sales_unit,"
	    	        					+ "tax_percentage,"
	    	        					+ "sales_rate,"
	    	        					+ "sale_quantity,"
	    	        					+ "discount_percentage,"
	    	        					+ "total_discount_amount,"
	    	        					+ "product_sale_amount_before_discount,"
	    	        					+ "product_sale_amount_after_discount,"
	    	        					+ "product_gross_amount,"
	    	        					+ "product_igst,"
	    	        					+ "product_cgst_amount,"
	    	        					+ "product_sgst_amount,"
	    	        					+ "product_name_marathi,"
	    	        					+ "bill_type,"
	    	        					+ "transport_charge,"
	    	        					+ "rate_type,"
	    	        					+ "sale_vehicle_empty_weight,"
	    	        					+ "sale_vehicle_gross_weight) "
	    	        					+ "values "
	    	        					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	    	        			
	    	        			preparedStatement = connection.prepareStatement(sql);
	    	        			
	    	        			preparedStatement.setString(1, this.getBillInfoDAO().getBillNumber());
	    	        			preparedStatement.setString(2, crusherId);
	    	        			preparedStatement.setString(3, crusherCode);
	    	        			preparedStatement.setString(4, productInfoDAO.getProductId());
	    	        			preparedStatement.setString(5, productInfoDAO.getProductName());
	    	        			preparedStatement.setString(6, productInfoDAO.getSalesUnit());
	    	        			preparedStatement.setString(7, productInfoDAO.getTaxId());
	    	        			preparedStatement.setString(8, ""+productInfoDAO.getSalesRate());
	    	        			preparedStatement.setFloat(9, productInfoDAO.getQuantity());
	    	        			preparedStatement.setFloat(10, productInfoDAO.getDiscountPecentage());
	    	        			preparedStatement.setFloat(11, productInfoDAO.getDiscountRupees());
	    	        			preparedStatement.setString(12, ""+productInfoDAO.getAmount());
	    	        			preparedStatement.setString(13, ""+productInfoDAO.getAmountAfterDiscount());
	    	        			preparedStatement.setString(14, ""+productInfoDAO.getGrossAmount());
	    	        			preparedStatement.setFloat(15, productInfoDAO.getIgst());
	    	        			preparedStatement.setFloat(16, productInfoDAO.getCgst());
	    	        			preparedStatement.setFloat(17, productInfoDAO.getSgst());
	    	        			preparedStatement.setString(18, productInfoDAO.getProductNameMarathi());
	    	        			preparedStatement.setString(19, this.getBillInfoDAO().getBillType());
	    	        			preparedStatement.setFloat(20, productInfoDAO.getTransportCharges());
	    	        			preparedStatement.setString(21, productInfoDAO.getRateType());
	    	        			
	    	        			
	    	        			if(productInfoDAO.getVehicleEmptyWeight() != null) {
	    	        				preparedStatement.setFloat(22, productInfoDAO.getVehicleEmptyWeight());
	    		        			
	    	        			}else {
	    	        				preparedStatement.setFloat(22, 0.0f);
	    		        			
	    	        			}
	    	        			if(productInfoDAO.getGrossWeight() != null)
	    	        			{
	    	        				preparedStatement.setFloat(23, productInfoDAO.getGrossWeight());
	    		        			
	    	        			}else {
	    	        				preparedStatement.setFloat(23, 0.0f);
	    		        			
	    	        			}
	    	        			
	    	        			
	    	        			productInserted = productInserted +  preparedStatement.executeUpdate();
	    	        			
	    	        			ownerMessageProductNameMarathi = productInfoDAO.getProductNameMarathi();
	    	        			
	    	        			listSize--;
	        			    	
	        			    }
	        			    
	        			    
	        			
	        			}
	        			
	        			
	        			
	        			
	        			String vehicleEntryId = EncryptionDecryption.decrypt(this.getKeyVehicle());
        				
					for(BillProductInfoDAO productInfoDAO : this.getProductInfoList())
        			{
        				if(vehicleEntryId != null && productInfoDAO.getQuantity() != null &&  productInfoDAO.getGrossWeight() != null)
        				{
        					
        						
        				
    	        		sql = "UPDATE "
    	        				+ "crusher_vehicle_entry_details "
    	        				+ "SET "
    	        				+ "bill_no=?,"
    		        			+ "gross_weight=?,"
    		        			+ "material_weight=?,"
    		        			+ "status=? "
    		        			+ "WHERE "
    		        			+ "entry_id = ? "
    		        			+ "AND "
    		        			+ "crusher_id = ? "
    		        			+ "AND "
    		        			+ "crusher_code = ? ";
    	        		
    	        		preparedStatement = connection.prepareStatement(sql);  	
    		        	
    		        	
    		           	preparedStatement.setString(1, this.getBillInfoDAO().getBillNumber());
    		        	preparedStatement.setFloat(2,productInfoDAO.getGrossWeight() );
    		        	preparedStatement.setFloat(3,productInfoDAO.getQuantity());
    		        	preparedStatement.setString(4,"BILL ADDED");
    		        	preparedStatement.setString(5, vehicleEntryId);
    		        	preparedStatement.setString(6, crusherId);
    		        	preparedStatement.setString(7, crusherCode);
    		        	
    		        	
    		        	
    		        	int updated = preparedStatement.executeUpdate();
    		        	
    	        			}
    		        	
        				}
						
						
						
	        			
	        			if(productInserted == this.getProductInfoList().size())
	        			{
	        				if(countBillInfoInserted > 0)
	        				{
	        					this.getBillInfoDAO().setBillInformationInserted(true);
	        				}
	        				
	        				
	    	        		this.setBillDateTime(this.getBillInfoDAO().getBillDate());
	    	        		this.setCustomerName(this.getBillInfoDAO().getCustomerName());
	    	        		this.setBillNumber(this.getBillInfoDAO().getBillNumber());
	    	        		this.setBillType(this.getBillInfoDAO().getBillType());
	    	        		this.setAlternateMobileNumber(this.getBillInfoDAO().getCustomerMobile());
	    	        		this.setSendSMS(this.getBillInfoDAO().isSendSMS());
	    	        		this.setTotalAmount(""+(floatTotalAmount+this.getBillInfoDAO().getTransportCharge()));	        	
	    	        		this.setTotalDiscount(""+(floatTotalDiscount+this.getBillInfoDAO().getTransportCharge()));
	    	        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()));
	    		        	
	    	        		paymentTypeList.put("CASH","CASH");
	    		        	paymentTypeList.put("CREDIT","CREDIT");
	    		        	
	    		        	
	    		        	this.setDefaultValue(this.getBillInfoDAO().getPaymentType());
	    		        	

	    		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
	    		        	
	    		        	unitList = GetListResource.GetUnitList();
	    		        	billTypeList = GetListResource.GetBillTypeList();
	    		        	
	    		    	
	    	        		
	    		        	
	    		        	
							sql = "SELECT "
		  							+ "credit_debit_id "
		  							+ "FROM "
		  							+ "crusher_bill_info_master "
		  							+ "WHERE "
				        			+ "bill_number = ? "
				        			+ "AND "
				        			+ "bill_type = ? "
				        			+ "AND "
				        			+ "customer_id = ? "
				        			+ "AND "
				        			+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
							
							preparedStatement = connection.prepareStatement(sql);
						
							preparedStatement.setString(1,this.getBillInfoDAO().getBillNumber());
							preparedStatement.setString(2,this.getBillInfoDAO().getBillType());
				        	preparedStatement.setString(3,custId);   
				        	preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							
							if(resultSet.next()){
								String crditDebitId = resultSet.getString(1);
								
								
								
								sql = "SELECT "
										+ "entry_id,"
										+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, crditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);

								
								resultSet = preparedStatement.executeQuery();
								
								int m = 0;
								if(resultSet.next())
								{
									
									PreparedStatement  insertIntoDeletedPSMT = null;
									
									String inertDeletedSQL = "INSERT "
											+ "INTO "
											+ "bank_account_credit_debit_updated_entry_master "
											+ "("
											+ "entry_id,"
											+ "crusher_id,"
											+ "crusher_code,"
											+ "account_id,"
											+ "account_number,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "amount,"
											+ "payment_type,"
											+ "entry_by,"
											+ "entry_details,"
											+ "old_amount,"
											+ "updated_date,"
											+ "updated_time) "
											+ "VALUES "
											+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
									
									insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
									
									insertIntoDeletedPSMT.setString(1, crditDebitId);
									insertIntoDeletedPSMT.setString(2, crusherId);
									insertIntoDeletedPSMT.setString(3, crusherCode);
									insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
									insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
									insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
									insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
									insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
									insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
									insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
									insertIntoDeletedPSMT.setString(11, billedBy);
									insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
									insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
									insertIntoDeletedPSMT.setString(14, this.getBillInfoDAO().getBillDate());
									insertIntoDeletedPSMT.setTime(15,time);
									
									
									  m = insertIntoDeletedPSMT.executeUpdate();
									  
									  String paymentType = resultSet.getString(6);
									  
									  
									  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
										Date parsedDate = null;

										try {
										    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
										} catch (ParseException e) {
										    e.printStackTrace();  
										}

										if (parsedDate != null) {
										     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
										    String formattedDate = outputDateFormat.format(parsedDate); 
							
										    
									 
									    
									    
									  boolean isCloseingBalMaintained = false;
									  
									  if (paymentType.equals("CREDIT")) {
									   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
									  }else {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), billedBy, connection, this.getSessionMap());
										  
									  }
										}
									  
									if(insertIntoDeletedPSMT != null)
									{
										insertIntoDeletedPSMT.close();
										insertIntoDeletedPSMT = null;
									}
									
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
								
								if(m>0)
								{
									
									
								
								sql = "DELETE "
										+ "FROM "
										+ "bank_account_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, crditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								int k = preparedStatement.executeUpdate();
								
								
								if(k > 0 )

								{
									
									sql = "UPDATE "
            	        					+ "crusher_bill_info_master "
            	        					+ "SET "
            	        					+ "credit_debit_id = ? "
            	        					+ "WHERE "
            			        			+ "bill_number = ? "
            			        			+ "AND "
            			        			+ "bill_type = ? "
            			        			+ "AND "
            			        			+ "customer_id = ? "
            			        			+ "AND "
            			        			+ "crusher_id = ? "
            								+ "AND "
            								+ "crusher_code = ?";
            	        			
            	        			
    	    						preparedStatement = connection.prepareStatement(sql);
    	    						
    	    						preparedStatement.setString(1, null);
    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
    	    						preparedStatement.setString(3,this.getBillInfoDAO().getBillNumber());
    	    			        	preparedStatement.setString(4,custId);   
    	    			        	preparedStatement.setString(5, crusherId);
    	    						preparedStatement.setString(6, crusherCode);
    	    						
    	    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
    	        				
    	    						
    	    						
    	    						
									
								}
				    		}
						}
							
				
						if(this.getAmountPaid()>0  && !this.getBillInfoDAO().getBillType().equals("TAX-INVOICE"))
						{
							    	
							
						
	    							
	    							sql = "SELECT "
	    									+ "entry_id "
	    									+ "FROM "
	    									+ "bank_account_credit_debit_master "
	    									+ "WHERE "
	    		        					+ "crusher_id = ? "
	    									+ "AND "
	    									+ "crusher_code = ? "
	    							        + "ORDER BY "
	    									+ "entry_id "
	    									+ "DESC LIMIT 1;";
	    							
	    						
	    						preparedStatement = connection.prepareStatement(sql);
	    						preparedStatement.setString(1, crusherId);
	    						preparedStatement.setString(2, crusherCode);
	    						
	    						resultSet = preparedStatement.executeQuery();
	    						
	    						int entryId = 1;
	    					
	    						if(resultSet.next())
	    						{
	    							if(!(resultSet.getString(1) == null))
	    							{
	    								entryId = Integer.parseInt(resultSet.getString(1));
	    								entryId = entryId + 1;
	    								
	    							}
	    							
	    						}
	    						else
	    						{	entryId =1;
	    							
	    						}
	    						
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		String accountNumber = "";
	    		        		sql = "SELECT "
	    		        				+ "account_number "
	    		        				+ "FROM "
	    		        				+ "crusher_bank_account "
	    		        				+ "WHERE "
	    		        				+ "account_id  = ? "
	    		        				+ "AND "
	    		        				+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ?";
	    		        			
	    		        		preparedStatement = connection.prepareStatement(sql);
	    		        		
	    		        		preparedStatement.setString(1, this.getAccountId());
	    		        		preparedStatement.setString(2, crusherId);
	    						preparedStatement.setString(3, crusherCode);
	    						
	    		        		resultSet = preparedStatement.executeQuery();
	    		        		if(resultSet.next())
	    		        		{
	    		        			accountNumber = resultSet.getString(1);
	    		        		}
	    		        		
	    		        		if(resultSet != null)
	    		        		{
	    		        			resultSet.close();
	    		        			resultSet = null;
	    		        		}
	    		        		if(preparedStatement!= null)
	    		        		{
	    		        			preparedStatement.close();
	    		        			preparedStatement = null;
	    		        		}
	    		        		
	    		        		
	    							sql = "INSERT "
	    									+ "INTO "
	    									+ "bank_account_credit_debit_master "
	    									+ "("
	    									+ "entry_id,"
	    									+ "crusher_id,"
	    									+ "crusher_code,"
	    									+ "account_id,"
	    									+ "account_number,"
	    									+ "entry_date,"
	    									+ "entry_time,"
	    									+ "entry_type,"
	    									+ "amount,"
	    									+ "payment_type,"
	    									+ "entry_by,"
	    									+ "entry_details,"
	    									+ "entry_source) "
	    									+ "VALUES "
	    									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
	    							
	    							preparedStatement = connection.prepareStatement(sql);
	    							
	    							preparedStatement.setInt(1, entryId);
	    							preparedStatement.setString(2, crusherId);
	    							preparedStatement.setString(3, crusherCode);
	    							preparedStatement.setString(4, this.getAccountId());
	    							preparedStatement.setString(5, accountNumber);
	    							preparedStatement.setString(6, this.getBillDateTime());
	    							preparedStatement.setTime(7, time);
	    							preparedStatement.setString(8, "CREDIT");
	    							preparedStatement.setFloat(9, this.getAmountPaid());
	    							preparedStatement.setString(10, this.getModeOfPayment());
	    							preparedStatement.setString(11, billedBy);
	    							preparedStatement.setString(12, "PAID BY "+customerName+" AGAINST BILL No: "+this.getBillInfoDAO().getBillNumber());
	    							preparedStatement.setString(13, "ADD BILL ");
	    							
	    							int rowInsetred = preparedStatement.executeUpdate();
	    							
	    							
	    							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"CREDIT", this.getBillDateTime(), this.getAmountPaid(), billedBy, connection, this.getSessionMap());
	    							
	    						
	    							
	    							if(rowInsetred > 0 && isCloseingBalMaintained)
	    							{
	    								

	    								sql = "UPDATE "
	            	        					+ "crusher_bill_info_master "
	            	        					+ "SET "
	            	        					+ "credit_debit_id = ? "
	            	        					+ "WHERE "
	            			        			+ "bill_number = ? "
	            			        			+ "AND "
	            			        			+ "customer_id = ? "
	            			        			+ "AND "
	            			        			+ "bill_type = ? "
	            			        			+ "AND "
	            			        			+ "crusher_id = ? "
	            								+ "AND "
	            								+ "crusher_code = ?";
	            	        			
	            	        			
	    	    						preparedStatement = connection.prepareStatement(sql);
	    	    						
	    	    						preparedStatement.setInt(1, entryId);
	    	    						preparedStatement.setString(2,this.getBillInfoDAO().getBillNumber());
	    	    			        	preparedStatement.setString(3,custId);   
	    	    			        	preparedStatement.setString(4, this.getBillInfoDAO().getBillType());
	    	    			        	preparedStatement.setString(5, crusherId);
	    	    						preparedStatement.setString(6, crusherCode);
	    	    						
	    	    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	    	        				
	    	    						
	    						
	    						if(rowCreditDebitIdInsetred > 0 )
	    						{
	    	    							
	    	    						
	    		    	        		addActionMessage(this.getText("message.success.billDetailsSavedSuccessfully"));
	    		    	        		
	    		    	        	
	    		    	        		this.getSessionMap().remove("billInformation");
	    		    		        	this.getSessionMap().remove("productList");
	    		    		        	this.setProductInfoList(null);
	    		    		        	this.setBillInfoDAO(null);
	    		    		        	this.setBillNumber("NA");
	    		    		        	this.setChalanNumber("NA");
	    		    		        	
	    		    		        	this.setDefaultValue("CREDIT");
	    		    		        	
	    		    		        	try {
	    		    						taxList = GetListResource.GetTaxList();
	    		    						
	    		    					} catch (IOException e) {
	    		    						
	    		    					}
	    		    		        	
	    		    		        	unitList = GetListResource.GetUnitList();
	    		    		        	billTypeList = GetListResource.GetBillTypeList();
	    		    		        	setBillType(billTypeList.get("BILL-OF-SUPPLY"));
	    		    		        	this.setCustomerName("");
	    		    		        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	    		    		        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	    		    		        
	    		    		        	
	    		    		        	this.setRateTyprDefaultValue("INCLUDINGGST");
	    		    		        	
	    		    		        	 discountTypeList.put("", "Select Discount Type");
	    		    				      discountTypeList.put("By Quantity", "By Quantity");
	    		    				      discountTypeList.put("By Percentage", "By Percentage");
	    		    				      discountTypeList.put("By Direct Amount", "By Direct Amount");
	    		    						this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
	    		    						this.setKmStart(0.0f);
	    		    		    			 this.setKmEnd(0.0f);
	    		    		    			 this.setTotalKm(0.0f);
	    		    		    			 this.setTotalTrips(0);
	    		    		    			
	    		    		        	
	    		    	        		
	    		    	        		connection.commit();
	        							
	    	    						result = SUCCESS;
	    	    						
	    	    						
	    	    						
	    	    						
	    	    						boolean sendWhatsAppMessage = false; 
			    						
			    						if(this.getSessionMap().get("sendWhatsAppMessage").equals("TRUE"))
			    						{
			    							sendWhatsAppMessage = true;
			    						}
			    						
			    							
			    						String defaultMessageLang = "MARATHI";
			    						
			    						if(sendWhatsAppMessage)
			    						{
			    							String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
			    							String crusherNameEnglish = (String) this.getSessionMap().get("crushernameenglish");
											
											String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
											
											String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
											
											HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
											
											String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
											
											String [] tokenData = tokenNumberWithUsername.split("#");
											
											String userName = tokenData[0];
											String tokenNumber = tokenData[1];
										
			    							String msg = "";
			    							
			    							String productDetailsMsg = "";
			    							
			    							for(BillProductInfoDAO dao : this.getProductInfoList())
			    							{
			    								productDetailsMsg += "\n"+dao.getProductNameMarathi()+":"+dao.getQuantity()
			    								+" "+dao.getSalesUnit()+" : दर - "+dao.getSalesRate()+" =  रक्कम : "+dao.getAmountAfterDiscount();
			    							}
			    							
			    						 float custBalanceAmount = GetCustomerTotalCreditAmountById.getCustomerTotalCreditAmountById(this.getBillInfoDAO().getCustId(), this.getSessionMap());
			    						 float totalBalanceAmt = 0.0f;
			    						 
			    						 
				    						 if(this.getBillType().equals("CASH"))
				    						 {
				    							 totalBalanceAmt = custBalanceAmount;
				    						 }
				    						 else
				    						 {
				    							 totalBalanceAmt = custBalanceAmount;
				    						 }
			    						 
			    							if(defaultMessageLang.equals("MARATH"))
			    							{
			    								msg = "*"+crusherNameMarathi +"* मधून खरेदी केल्याबद्दल धन्यवाद!";
			    								msg += "\n*बिल तारीख* : "+this.getBillDateTime();
			    								msg += "\n*बिल नं.* : "+this.getBillNumber();
			    								msg += "\n*गाडी क्र.* : "+this.getBillVehicleInfoDAO().getVehicleRCNumber();
			    								msg += "\n*मटेरीअल अनलोडिंगचे ठिकाण* : "+this.getBillVehicleInfoDAO().getTripTo();
			    								msg += "\n*-: तपशील :-*";
			    								msg += productDetailsMsg;
			    								msg += "\n*वाहतूक रक्कम* : "+this.getBillInfoDAO().getTransportCharge();
			    								msg += "\n*एकूण बील रक्कम* : "+ (floatTotalAmtAfterDiscount + this.getBillInfoDAO().getTransportCharge());
			    								msg += "\n*एकूण येणे बाकी* : "+ totalBalanceAmt;
			    								msg += "\n*संपर्क* : "+customerCareNumber;
			    								
			    								
			    								String fileUrl = "https://easycrush.in/printBillWithOutSession?billNumber="+this.getBillInfoDAO().getBillNumber()+"&size=A5&lang=eng&billType=BILL-OF-SUPPLY&crusherId="+crusherId+"&crusherCode="+crusherCode;
			    								
			    								//System.out.println(fileUrl);
			    								
			    								String fileName = "खरेदी बील";
			    								String whatsAppResp = SendWhatsAppMessage.sendMessageWithFile(userName, this.getBillInfoDAO().getCustomerMobile(), msg, tokenNumber, fileUrl, fileName);
			    								
			    								
			    								//System.out.println(whatsAppResp);
			    								
			    								if(whatsAppResp.contains("success"))
			    								{
			    									addActionMessage("WhatsApp Message Sent Successfully!");
			    								}
			    								
			    							}
			    							
			    							
			    							
			    						}
									
									
									
	    	    						}
	    							}
	    							else
	    							{
	    								addActionError(this.getText("message.error.billDetailsNotSaveSuccessfully"));
	    		    	        		
		    		    	        	
	    								this.getBillInfoDAO().setBillSaved(false);
	    		    	        		this.setBillSaved(false);
	    								this.getSessionMap().put("billInformation", this.getBillInfoDAO());
	    		    	        		this.getSessionMap().put("productList", this.getProductInfoList());
	    								connection.rollback();
	    								result = ERROR;
	    							}
	    							
						
	    						}
								else
								{
									if(preparedStatement != null)
    		    	        		{
    		    	        			preparedStatement.close();
    		    	        			preparedStatement = null;
    		    	        		}
    		    	        		
    		    	        		sql = "SELECT "
    		    	        				+ "challan_number "
    		    	        				+ "FROM "
    		    	        				+ "crusher_delivery_challan_master "
    		    	        				+ "WHERE "
    		    	        				+ "challan_number = ? "
    		    	        				+ "AND "
    		    							+ "crusher_id = ? "
    		    							+ "AND "
    		    							+ "crusher_code = ? ";
    		    	        		
    		    	        		preparedStatement = connection.prepareStatement(sql);
    		    	        		preparedStatement.setString(1, this.getBillInfoDAO().getChalanNumber());
									preparedStatement.setString(2, crusherId); 
									preparedStatement.setString(3,crusherCode);
									 
    		    					resultSet = preparedStatement.executeQuery();
    		    	        		
    		    	        		if(resultSet.next())
    		    	        		{
    		    	        			String updateCHallanStatusSQL = "UPDATE "
    		    	        					+ "crusher_delivery_challan_master "
    		    	        					+ "SET "
    		    	        					+ "bill_created = ? "
    		    	        					+ "WHERE "
    		    	        					+ "challan_number = ? "
    		    	        					+ "AND "
        		    							+ "crusher_id = ? "
        		    							+ "AND "
        		    							+ "crusher_code = ?";
    		    	        			
    		    	        			PreparedStatement updateChallanStatusPSMT = connection.prepareStatement(updateCHallanStatusSQL);
    		    	        			
    		    	        			updateChallanStatusPSMT.setBoolean(1, true);
    		    	        			updateChallanStatusPSMT.setString(2, this.getBillInfoDAO().getChalanNumber());
    		    	        			updateChallanStatusPSMT.setString(3, crusherId);
    		    	        			updateChallanStatusPSMT.setString(4, crusherCode);
    		    	    				
    		    	        			updateChallanStatusPSMT.executeUpdate();
    		    	        			
    		    	        			
    		    	        		}
    		    	        		
    		    	        		
    		    	        		this.getSessionMap().remove("productList");
    		    					this.getSessionMap().remove("billInformation");
    		    					this.getSessionMap().remove("deletedProductList");
    		    					this.getSessionMap().remove("purchaseProductList");
    		    					this.getSessionMap().remove("purchaseInformation");
    		    					this.getSessionMap().remove("finishedProductInfoList");
    		    					this.getSessionMap().remove("deletedProductInfoList");
    		    					this.getSessionMap().remove("billvehicleinfo");
    		    					this.getSessionMap().remove("challanProductList");
    		    					this.getSessionMap().remove("challanInformation");
    		    					this.getSessionMap().remove("challanVehicleinfo");
    		    					this.getSessionMap().remove("quotationInformation");
    		    					this.getSessionMap().remove("quotationProductList");
    		    					this.getSessionMap().remove("RMCProductList");
    		    					this.getSessionMap().remove("RMCBillInformation");
    		    					this.getSessionMap().remove("RMCBillvehicleinfo");
    		    		        	this.setProductInfoList(null);
    		    		        	this.setBillInfoDAO(null);
    		    		        	this.setBillNumber("NA");
    		    		        	this.setChalanNumber("NA");
    		    		        	
    		    		        	this.setDefaultValue("CREDIT");
    		    		        	
    		    		        	try {
    		    						taxList = GetListResource.GetTaxList();
    		    						
    		    					} catch (IOException e) {
    		    						
    		    					}
    		    		        	
    		    		        	unitList = GetListResource.GetUnitList();
    		    		        	billTypeList = GetListResource.GetBillTypeList();
    		    		        	setBillType(billTypeList.get("BILL-OF-SUPPLY"));
    		    		        	this.setCustomerName("");
    		    		        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    		    		        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    		    		        
    		    		        	
    		    		        	this.setRateTyprDefaultValue("INCLUDINGGST");
    		    		        	
    		    		        	 discountTypeList.put("", "Select Discount Type");
    		    				      discountTypeList.put("By Quantity", "By Quantity");
    		    				      discountTypeList.put("By Percentage", "By Percentage");
    		    				      discountTypeList.put("By Direct Amount", "By Direct Amount");
    		    						this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
    		    						
    		    						this.setKmStart(0.0f);
    		    		    			 this.setKmEnd(0.0f);
    		    		    			 this.setTotalKm(0.0f);
    		    		    			 this.setTotalTrips(0);
    		    		    			
    		    		        	
    								connection.commit();
    								
									addActionMessage(this.getText("message.success.billDetailsSavedSuccessfully"));
    		    	        		
									result = SUCCESS;
								
								
								
		    						boolean sendWhatsAppMessage = false; 
		    						
		    						if(this.getSessionMap().get("sendWhatsAppMessage").equals("TRUE"))
		    						{
		    							sendWhatsAppMessage = true;
		    						}
		    						
		    							
		    						String defaultMessageLang = "MARATHI";
		    						
		    						if(sendWhatsAppMessage)
		    						{
		    							String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
		    							String crusherNameEnglish = (String) this.getSessionMap().get("crushernameenglish");
										
										String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
										
										String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
										
										HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
										
										String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
										
										String [] tokenData = tokenNumberWithUsername.split("#");
										
										String userName = tokenData[0];
										String tokenNumber = tokenData[1];
									
		    							String msg = "";
		    							
		    							String productDetailsMsg = "";
		    							
		    							for(BillProductInfoDAO dao : this.getProductInfoList())
		    							{
		    								productDetailsMsg += "\n"+dao.getProductNameMarathi()+":"+dao.getQuantity()
		    								+" "+dao.getSalesUnit()+" : दर - "+dao.getSalesRate()+" =  रक्कम : "+dao.getAmountAfterDiscount();
		    							}
		    							
		    						 float custBalanceAmount = GetCustomerTotalCreditAmountById.getCustomerTotalCreditAmountById(this.getBillInfoDAO().getCustId(), this.getSessionMap());
		    						 float totalBalanceAmt = 0.0f;
		    						 
		    						 
			    						 if(this.getBillType().equals("CASH"))
			    						 {
			    							 totalBalanceAmt = custBalanceAmount;
			    						 }
			    						 else
			    						 {
			    							 totalBalanceAmt = custBalanceAmount;
			    						 }
		    						 
		    							if(defaultMessageLang.equals("MARATHI"))
		    							{
		    								msg = "*"+crusherNameMarathi +"* मधून खरेदी केल्याबद्दल धन्यवाद!";
		    								msg += "\n*बिल तारीख* : "+this.getBillDateTime();
		    								msg += "\n*बिल नं.* : "+this.getBillNumber();
		    								msg += "\n*गाडी क्र.* : "+this.getBillVehicleInfoDAO().getVehicleRCNumber();
		    								msg += "\n*मटेरीअल अनलोडिंगचे ठिकाण* : "+this.getBillVehicleInfoDAO().getTripTo();
		    								msg += "\n*-: तपशील :-*";
		    								msg += productDetailsMsg;
		    								msg += "\n*वाहतूक रक्कम* : "+this.getBillInfoDAO().getTransportCharge();
		    								msg += "\n*एकूण बील रक्कम* : "+ (floatTotalAmtAfterDiscount + this.getBillInfoDAO().getTransportCharge());
		    								msg += "\n*एकूण येणे बाकी* : "+ totalBalanceAmt;
		    								msg += "\n*संपर्क* : "+customerCareNumber;
		    								
		    								
		    								String fileUrl = "https://easycrush.in/printBillWithOutSession?billNumber="+this.getBillInfoDAO().getBillNumber()+"&size=A5&lang=eng&billType=BILL-OF-SUPPLY&crusherId="+crusherId+"&crusherCode="+crusherCode;
		    								
		    								//System.out.println(fileUrl);
		    								String fileName = "खरेदी बील";
		    								String whatsAppResp = SendWhatsAppMessage.sendMessageWithFile(userName, this.getBillInfoDAO().getCustomerMobile(), msg, tokenNumber, fileUrl, fileName);
		    								
		    								
		    								//System.out.println(whatsAppResp);
		    								
		    								if(whatsAppResp.contains("success"))
		    								{
		    									addActionMessage("WhatsApp Message Sent Successfully!");
		    								}
		    								
		    							}
		    							
		    							
		    							
		    						}
								
								
								
								
								}
	    						
	    						
	    	        			
	    	        		
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.billNotSavedProperly"));
	        			}
	        			
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.sryBillDetailsNotSaved"));
	        	}
	        	
	        	
	        	
	        	
	        	
    			
	        		
	        	}
	        	catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					try {connection.rollback();} catch (SQLException e1) {}
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 "+this.getText("message.error.billDetailsNotSaveSuccessfully"));
				} catch (Exception e) {
					e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||2 "+this.getText("message.error.billDetailsNotSaveSuccessfully"));
				}finally {
					if(resultSet != null)
	   				{
	   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
					}
	        	}
	        	else
	        	{
	        		
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	
		        	
	        		this.getSessionMap().put("productList", this.getProductInfoList());
	        		
	        		setCustomerName(this.getBillInfoDAO().getCustomerName());
	        		setBillNumber(this.getBillInfoDAO().getBillNumber());
	        		setBillType(this.getBillInfoDAO().getBillType());
	        		setTransportCharge(this.getBillInfoDAO().getTransportCharge());
	        		//System.out.println(getAlternateMobileNumber());
	        		
	        		setAlternateMobileNumber(this.getBillInfoDAO().getCustomerMobile());
	        		setSendSMS(this.getBillInfoDAO().isSendSMS());
	        		float transportCharge = 0.0F;
	        		
		        	if(!this.getBillInfoDAO().getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = this.getBillInfoDAO().getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
		        		}
		        	}
		        	
		        	if(!hasActionErrors())
		        	{
			        	setTotalAmount(""+(floatTotalAmount));	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	else
		        	{
		        		setTotalAmount(""+floatTotalAmount);	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	this.getSessionMap().remove("productList");
					this.getSessionMap().remove("billInformation");
					this.getSessionMap().remove("deletedProductList");
					this.getSessionMap().remove("purchaseProductList");
					this.getSessionMap().remove("purchaseInformation");
					this.getSessionMap().remove("finishedProductInfoList");
					this.getSessionMap().remove("deletedProductInfoList");
					this.getSessionMap().remove("billvehicleinfo");
					this.getSessionMap().remove("challanProductList");
					this.getSessionMap().remove("challanInformation");
					this.getSessionMap().remove("challanVehicleinfo");
					this.getSessionMap().remove("quotationInformation");
					this.getSessionMap().remove("quotationProductList");
					this.getSessionMap().remove("RMCProductList");
					this.getSessionMap().remove("RMCBillInformation");
					this.getSessionMap().remove("RMCBillvehicleinfo");
		        	this.setProductInfoList(null);
		        	this.setBillInfoDAO(null);
		        	this.setBillNumber("NA");
		        	this.setChalanNumber("NA");
		        	
		        	this.setDefaultValue("CREDIT");
		        	
		        	try {
						taxList = GetListResource.GetTaxList();
						
					} catch (IOException e) {
						
					}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	setBillType(billTypeList.get("BILL-OF-SUPPLY"));
		        	this.setCustomerName("");
		        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
		        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
		        
		        	
		        	this.setRateTyprDefaultValue("INCLUDINGGST");
		        	
		        	 discountTypeList.put("", "Select Discount Type");
				      discountTypeList.put("By Quantity", "By Quantity");
				      discountTypeList.put("By Percentage", "By Percentage");
				      discountTypeList.put("By Direct Amount", "By Direct Amount");
						this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
						this.setKmStart(0.0f);
		    			 this.setKmEnd(0.0f);
		    			 this.setTotalKm(0.0f);
		    			 this.setTotalTrips(0);
		    			
		        	result = "success";
	        		addActionError(this.getText("message.error.billAlreadySaved"));
	        	}
	        	}	
	        }
	       // System.out.print(result);
	        return result;
		
	}
	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		this.setProductInfoList((List<BillProductInfoDAO>) this.getSessionMap().get("productList"));		        	
    	this.setBillInfoDAO((BillInformationDAO) this.getSessionMap().get("billInformation"));
    	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("billvehicleinfo"));
 
    	if(!hasActionErrors())
		{
		if(this.getAmountPaid() == null || this.getAmountPaid().equals(""))
		{
			addActionError(this.getText("message.error.amountPaidNullBillCannotSaved"));
		}
		}
		
		if(!hasActionErrors())
		{
			if(this.getReturnAmount() == null || getReturnAmount().equals(""))
			{
				addActionError(this.getText("message.error.returnAmountNullBillCannotSaved"));
			}
		}
		
		
		
		if(!hasActionErrors())
		{
		if(this.getBillInfoDAO().getPaymentType().equals("CASH") && this.getAmountPaid() > 0)
		{
			if(this.getAccountId() == null || this.getAccountId().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectAccountForCreditEntry"));
			}
			
			
		}
		}
		
		if(!hasActionErrors())
		{
			if(this.getBillInfoDAO().getPaymentType().equals("CREDIT"))
			{
				if(this.getAmountPaid()>0)
				{
					addActionError(this.getText("message.error.ModeofpaymentIsCreditAmountPaidShouldBe0"));
				}
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getBillInfoDAO().getPaymentType().equals("CASH"))
			{
				if(this.getAmountPaid()<=0)
				{
					addActionError(this.getText("message.error.modeOfPaymentIsCashAmountPaidShouldNotBe0"));
				}
			}
			
			if(this.getBillInfoDAO().getPaymentType().equals("CASH"))
			{
				if(this.getAmountPaid()!=Float.parseFloat(this.getTotalPaybleAmount()))
				{
					addActionError(this.getText("message.error.modeOfPaymentIsCashAmountPaidCannotLessThanAmountPayable"));
				}
			}
		}

		productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("productList");		        	
    	billInfoDAO = (BillInformationDAO) this.getSessionMap().get("billInformation");
    	
    	float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
    	{
    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
    		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
    		
    	}
    	
    	setTransportCharge(this.getBillInfoDAO().getTransportCharge());
    	setCustomerName(this.getBillInfoDAO().getCustomerName());
		setBillNumber(this.getBillInfoDAO().getBillNumber());
		setBillType(this.getBillInfoDAO().getBillType());
		setBillDateTime(this.getBillInfoDAO().getBillDate());
		setChalanNumber(this.getBillInfoDAO().getChalanNumber());
		float transportCharge = 0.0F;
		if(!this.getBillInfoDAO().getTransportCharge().equals("")){
    		
    		try
    		{
    			transportCharge = this.getBillInfoDAO().getTransportCharge();
    		}catch(NumberFormatException nfe)
    		{
    			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
    		}
    	}
    	
    	
        	setTotalAmount(""+(floatTotalAmount+transportCharge));	        	
        	setTotalDiscount(""+floatTotalDiscount);
        	setTotalPaybleAmount(""+(floatTotalAmount+transportCharge));
        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+transportCharge));
        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
    	
    	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	setDefaultValue(this.getBillInfoDAO().getPaymentType());
    	

    	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
    	
    	unitList = GetListResource.GetUnitList();
    	billTypeList = GetListResource.GetBillTypeList();
    	
    	session=ServletActionContext.getRequest().getSession(false); 
    	
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
		
    	paymentTypeList2.add("CASH");
    	paymentTypeList2.add("UPI");
    	paymentTypeList2.add("RTGS");
    	paymentTypeList2.add("NEFT");
    	paymentTypeList2.add("CHEQUE");
    	
    	  discountTypeList.put("", "Select Discount Type");
	      discountTypeList.put("By Quantity", "By Quantity");
	      discountTypeList.put("By Percentage", "By Percentage");
	      discountTypeList.put("By Direct Amount", "By Direct Amount");
			
	      
    	this.setAddSideBarJs("FALSE");
    	
    	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    	this.setRateTyprDefaultValue("INCLUDINGGST");
    	
    	
		
		this.getSessionMap().put("billInformation", this.getBillInfoDAO());
		this.getSessionMap().put("productList", this.getProductInfoList());
	}
	
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}
	
	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public void setTotalPaybleAmount(String totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	
	


	public Float getAmountPaid() {
		return amountPaid;
	}
	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}
	public String getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}



	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}



	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	public boolean isBillSaved() {
		return billSaved;
	}
	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}
	public String getBillDateTime() {
		return billDateTime;
	}
	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getChalanNumber() {
		return chalanNumber;
	}
	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}
	public Float getTransportCharge() {
		return transportCharge;
	}
	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}

	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}
	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}
	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}
	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}
	public String getModeOfPayment() {
		return modeOfPayment;
	}
	public void setModeOfPayment(String modeOfPayment) {
		this.modeOfPayment = modeOfPayment;
	}
	public String getAccountId() {
		return accountId;
	}
	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}
	public Map<String, String> getAccountList() {
		return accountList;
	}
	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}
	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}
	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}
	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}
	public String getRateType() {
		return rateType;
	}
	public void setRateType(String rateType) {
		this.rateType = rateType;
	}
	public String getKeyVehicle() {
		return keyVehicle;
	}
	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}
	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}
	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}
	public boolean isViewBill() {
		return viewBill;
	}
	public void setViewBill(boolean viewBill) {
		this.viewBill = viewBill;
	}
	public String getDiscountType() {
		return discountType;
	}
	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}
	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}
	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}
	public Float getKmStart() {
		return kmStart;
	}
	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}
	public Float getKmEnd() {
		return kmEnd;
	}
	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}
	public Float getTotalKm() {
		return totalKm;
	}
	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}
	public Integer getTotalTrips() {
		return totalTrips;
	}
	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}
	
	
	

	
}
