package com.stonecrusher.add;


import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;
import com.opensymphony.xwork2.ActionSupport;

public class AddVehicleMaintenanceEntry extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	private File invoiceImage;
	private Float amount;
	private String comments;
	private String entryDate;
	private String vehicleId;
	private String typeOfPayment;
	private String accountId;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String addSideBarJs;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				
				String vehicleDetails [] = this.getVehicleId().split("-");
				
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String entryBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		entryBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		entryBy =fullUserName;
	        	}
	        	
	        	 java.util.Date date = new java.util.Date();
       	      long t = date.getTime();	        	     
       	      java.sql.Time time = new java.sql.Time(t);
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					sql = "SELECT "
							+ "vehicle_expense_entry_id "
							+ "FROM "
							+ "crusher_vehicle_expense_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "vehicle_expense_entry_id "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 1;
			
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId = Integer.parseInt(resultSet.getString(1));
						entryId = entryId + 1;
						
					}
					
				}
				else
				{	entryId =1;
					
				}
				
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		
        		sql = "INSERT INTO "
        				+ "crusher_vehicle_expense_master "
        				+ "("
        				+ "vehicle_expense_entry_id,"
        				+ "crusher_id,"
        				+ "crusher_code,"
        				+ "vehicle_id,"
        				+ "exepense_date,"
        				+ "exepense_time,"
        				+ "exepense_amount,"
        				+ "entry_by,"
        				+ "consupmtion_details) "
        				+ "VALUES "
        				+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?)";
        		
        		preparedStatement = connection.prepareStatement(sql);
        		
        		preparedStatement.setInt(1, entryId);
        		preparedStatement.setString(2, crusherId);
        		preparedStatement.setString(3, crusherCode);
        		preparedStatement.setString(4, vehicleDetails[0]);
        		preparedStatement.setString(5, this.getEntryDate());
        		preparedStatement.setTime(6, time);
        		preparedStatement.setFloat(7, this.getAmount());
        		preparedStatement.setString(8, entryBy);
        		preparedStatement.setString(9, this.getComments().trim().toUpperCase());
        	
        		
        		int k  = preparedStatement.executeUpdate();
        		
        		if(k>0)
        		{
        			if(this.getInvoiceImage() != null)
        			{
        				
        				FileInputStream fis  = null;
        				fis =  new FileInputStream(this.getInvoiceImage());
        				
        				
        				if(preparedStatement!= null)
                		{
                			preparedStatement.close();
                			preparedStatement = null;
                		}
                		
        				
        				sql = "UPDATE "
        						+ "crusher_vehicle_expense_master "
        						+ "SET "
        						+ "expence_image = ? "
        						+ "WHERE "
        						+ "vehicle_expense_entry_id = ? "
        						+ "AND "
        						+ "vehicle_id = ? "
        						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
    							
        				
        				
        				preparedStatement = connection.prepareStatement(sql);
        				
        				preparedStatement.setBinaryStream(1, fis,(int)this.getInvoiceImage().length() );
        				preparedStatement.setInt(2, entryId);
        				preparedStatement.setString(3, vehicleDetails[0]);
        				preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
        				int m = preparedStatement.executeUpdate();
        				
        				if(fis != null)
        				{
        					fis.close();
        					fis = null;
        				}
        				
        				
        			}
        			
        			
        			

        			if(this.getTypeOfPayment().equals("CHEQUE"))
        			{
	        			
	        			if(preparedStatement != null)
	        			{
	        				preparedStatement.close();
	        				preparedStatement = null;
	        			}
	        			
	        			sql = "UPDATE "
	        					+ "cheque_book_details_master "
	        					+ "SET "
	        					+ "cheuqe_pay_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	        					+ "cheque_payee = ?,"
	        					+ "cheque_amount = ?,"
	        					+ "cheque_status = 'GIVEN',"
	        					+ "chaque_status_change_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	        					+ "reason_for_cheque_given = ?,"
	        					+ "status_changed_by = ? "
	        					+ "WHERE "
	        					+ "cheque_number = ? "
	        					+ "AND "
	        					+ "cheque_book_bank_name = ? "
	        					+ "AND "
	        					+ "cheque_book_branch_name = ? "
	        					+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, this.getChequePayDate());
	        			preparedStatement.setString(2, this.getChequePayee().trim().toUpperCase());
	        			preparedStatement.setFloat(3, this.getAmount());
	        			preparedStatement.setString(4, this.getEntryDate());
	        			preparedStatement.setString(5, "VEHICLE Maintenance TO VehicleRegNo "+vehicleDetails[2].trim().toUpperCase());
	        			preparedStatement.setString(6, entryBy);
	        			preparedStatement.setString(7, this.getChequeNumber());
	        			preparedStatement.setString(8, this.getBankName());
	        			preparedStatement.setString(9, this.getBranchName());
	        			preparedStatement.setString(10, crusherId);
        				preparedStatement.setString(11, crusherCode);
        				
	        			int rowCountUpdated = preparedStatement.executeUpdate();
	        			
	        			if(rowCountUpdated > 0)
	        			{
	        				addActionMessage(this.getText("message.success.chequeDetailsUpdatedSuccessfully"));
	        			}
	        			else
	        			{
	        				addActionError(this.getText("message.error.couldNotUpdateChequeDetails"));
	        			}
        			}
        		
        			
        			
        			
        			if(!this.getTypeOfPayment().equals("CHEQUE") && this.getAccountId() != null && !this.getAccountId().trim().equals("")) 
        			
        			{

        				  
        				
        				sql = "SELECT "
								+ "entry_id "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
	        					+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?"
    							+ "ORDER BY "
								+ "entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
					
					int entryAccountId = 1;
				
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryAccountId = Integer.parseInt(resultSet.getString(1));
							entryAccountId = entryAccountId + 1;
							
						}
						
					}
					else
					{	entryAccountId =1;
						
					}
					
	        		
        				
        				if(resultSet != null)
    	        		{
    	        			resultSet.close();
    	        			resultSet = null;
    	        		}
    	        		if(preparedStatement!= null)
    	        		{
    	        			preparedStatement.close();
    	        			preparedStatement = null;
    	        		}
        				
    	        		String accountNumber = "";
    	        		sql = "SELECT "
    	        				+ "account_number "
    	        				+ "FROM "
    	        				+ "crusher_bank_account "
    	        				+ "WHERE "
    	        				+ "account_id  = ? "
    	        				+ "AND "
    	        				+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
    							
    	        			
    	        		preparedStatement = connection.prepareStatement(sql);
    	        		
    	        		preparedStatement.setString(1, this.getAccountId());
    	        		preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
    	        		resultSet = preparedStatement.executeQuery();
    	        		if(resultSet.next())
    	        		{
    	        			accountNumber = resultSet.getString(1);
    	        		}
    	        		

    	        		if(resultSet != null)
    	        		{
    	        			resultSet.close();
    	        			resultSet = null;
    	        		}
    	        		if(preparedStatement!= null)
    	        		{
    	        			preparedStatement.close();
    	        			preparedStatement = null;
    	        		}
    						
    						sql = "INSERT "
    								+ "INTO "
    								+ "bank_account_credit_debit_master "
    								+ "("
    								+ "entry_id,"
    								+ "crusher_id,"
    								+ "crusher_code,"
    								+ "account_id,"
    								+ "account_number,"
    								+ "entry_date,"
    								+ "entry_time,"
    								+ "entry_type,"
    								+ "amount,"
    								+ "payment_type,"
    								+ "entry_by,"
    								+ "entry_details,"
    								+ "entry_source) "
    								+ "VALUES "
    								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
    						
    						preparedStatement = connection.prepareStatement(sql);
    						
    						preparedStatement.setInt(1, entryAccountId);
    						preparedStatement.setString(2, crusherId);
    						preparedStatement.setString(3, crusherCode);
    						preparedStatement.setString(4, this.getAccountId());
    						preparedStatement.setString(5, accountNumber);
    						preparedStatement.setString(6, this.getEntryDate());
    						preparedStatement.setTime(7, time);
    						preparedStatement.setString(8, "DEBIT");
    						preparedStatement.setFloat(9, this.getAmount());
    						preparedStatement.setString(10, this.getTypeOfPayment());
    						preparedStatement.setString(11, entryBy);
    						preparedStatement.setString(12, "VEHICLE Maintenance TO VehicleRegNo "+vehicleDetails[2].trim().toUpperCase());
    						preparedStatement.setString(13, "VEHICLE MAINTENANCE ");
							
    						int rowInsetred = preparedStatement.executeUpdate();
        				
    						
    						boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getEntryDate(), this.getAmount(), entryBy, connection, this.getSessionMap());
							
    						if(rowInsetred > 0 && isCloseingBalMaintained)
    						{
    	        				
    							sql = "UPDATE "
        	        					+ "crusher_vehicle_expense_master "
        	        					+ "SET "
        	        					+ "credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "vehicle_expense_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, entryAccountId);
	    						preparedStatement.setInt(2, entryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	        				
	    						
	    						
	    						if(rowCreditDebitIdInsetred > 0 )
	    						{
	    							connection.commit();
	    	        				result = SUCCESS;
	    	        				addActionMessage(this.getText("message.success.vehicleMaintenance/ExpenceDetailsAddedSuccessfully"));
	    						}
    							
    							
    							
    						}
    						else
    						{
    							connection.rollback();
    							result = ERROR;
    							addActionError(this.getText("message.error.vehicleMaintenance/ExpenceCouldNotAddedPlzTryAgain"));
    						}
        	    		}
        			
        			
        			
        			else
        			{
        				connection.commit();
        				result = SUCCESS;
        				addActionMessage(this.getText("message.success.vehicleMaintenance/ExpenceDetailsAddedSuccessfully"));
					
        			}
					
        			
        			
        			
        		
        		
        		}
        		else
        		{
        			result = ERROR;
        			addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
        		}
        		
        		
        		
				}
				catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					e.printStackTrace();
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
    	this.setAddSideBarJs("FALSE");
    	
		if(this.getEntryDate() == null || this.getEntryDate().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectEntryDate"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleId() == null || this.getVehicleId().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
			}
			else
			{
				try
				{
					String [] vehicleDetails = this.getVehicleId().split("-");
					
					if(vehicleDetails.length <3)
					{
						addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
					}
				}
				catch (Exception e) {
					addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
				}
			}
		}

		if(!hasActionErrors())
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
		if(!hasActionErrors())
    	{
    		if(this.getTypeOfPayment() == null || this.getTypeOfPayment().equals(""))
    		{
    			addActionError(this.getText("message.error.plzProvideTypeOfPayment"));
    		}
    	}
    	
    		
		/*
		 * if(!hasActionErrors()){ if(this.getAccountId() == null ||
		 * this.getAccountId().equals("")) {
		 * addActionError(this.getText("message.error.plzSelectAccountForDebitEntry"));
		 * } }
		 */
    	
	}
	
	public File getInvoiceImage() {
		return invoiceImage;
	}



	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}



	public Float getAmount() {
		return amount;
	}



	public void setAmount(Float amount) {
		this.amount = amount;
	}



	public String getComments() {
		return comments;
	}



	public void setComments(String comments) {
		this.comments = comments;
	}



	public String getEntryDate() {
		return entryDate;
	}



	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeList() {
		return chequeList;
	}

	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	

}



