package com.stonecrusher.add;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;


public class AddProductToQuotation extends ActionSupport implements SessionAware,Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5416864158386161538L;

	
	private HttpSession session;
	private String quotationDateTime;
	private String operator;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private String taxPercentage;
	private Float salesRate;
	private Float quantity;
	private Float discountPercentage;
	private Float discountRupees;
	private Float amount;
	private String billType;
	private Float amountAfterDiscount;
	private Float transportCharge;
	private String comments;
	private boolean sendSMS;
	private String alternateMobileNumber;
	private Float totalPaybleAmount;
	private SessionMap<String,Object> sessionMap;  
	private String amountPaid;
	
	private String quotationNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private List<BillProductInfoDAO> productInfoList ;
	private String defaultValue;
	
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	
	private String removeVaules="false";
	private String addSideBarJs;

	private BillInformationDAO quotationInfoDAO = null;

	private String viewBill;
	
	private boolean billSaved;
    private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	@SuppressWarnings("unchecked")
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	
	      
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		
	    		
	    			
			
	        	productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("quotationProductList");
	        	
	        	quotationInfoDAO = (BillInformationDAO) this.getSessionMap().get("quotationInformation");
	        	
	        	
	        	if(productInfoList == null)
	        	{
	        		productInfoList = new ArrayList<BillProductInfoDAO>();
	        	}
	        	
	        	
	        	
	        	if(this.getQuotationInfoDAO()==null)
	        	{
	        		this.setQuotationInfoDAO(new BillInformationDAO());
	        	}
	        
	        	
	        			
				
	        	BillProductInfoDAO billProductInfoDAO = new BillProductInfoDAO();
	        	
	        
	        	billProductInfoDAO.setProductName(getProductName());
	        	billProductInfoDAO.setProductNameMarathi(getProductMarathiName());
	        	billProductInfoDAO.setSalesUnit(getSalesUnit());
	        	billProductInfoDAO.setTaxId(getTaxPercentage());
	        	billProductInfoDAO.setSalesRate(getSalesRate());
	        	billProductInfoDAO.setQuantity(getQuantity());
	        	billProductInfoDAO.setDiscountPecentage(getDiscountPercentage());
	        	billProductInfoDAO.setDiscountRupees(getDiscountRupees());
	        	billProductInfoDAO.setAmount(getAmount());
	        	
	        	billProductInfoDAO.setAlias(getAlias());
	        	billProductInfoDAO.setAddedToDB(false);
	        	
	        	
	        	float floatAmountAftDiscount = this.getAmountAfterDiscount();
	        	float totalProductDiscount = this.getAmount() - this.getAmountAfterDiscount();
	        	
	        	
	        	float sgst = 0.0F;
	        	float cgst = 0.0F;
	        	float igst = 0.0F;
	        	
				
				
				Map<String,String> taxInfo = GetListResource.GetTaxNamePercentage(this.getTaxPercentage());
	        	
				String taxName = taxInfo.get("TAX-NAME");
				String taxPercentage = taxInfo.get("TAX-PERCENTAGE");
				
				billProductInfoDAO.setTaxName(taxName);
				billProductInfoDAO.setTaxPercentage(taxPercentage);
			
					float floatTaxRate = Float.parseFloat(taxPercentage);	
					
					float basicTax = floatTaxRate+100.0F;
		        	
		        	float grossAmount = (floatAmountAftDiscount / basicTax) * 100.0F;
		        	
		        	float totalTax = floatAmountAftDiscount - grossAmount;
					
					if(taxName.toUpperCase().contains("IGST"))
					{
						igst = totalTax;
					}
					else
					{
						sgst = totalTax/2.0F;
			        	cgst = totalTax/2.0F;
					}
	        	
	        	     
					 DecimalFormat df = new DecimalFormat("0.00");
				        
			        	
		        	 billProductInfoDAO.setProductTotalDiscount(totalProductDiscount);
		        	 billProductInfoDAO.setGrossAmount(Float.valueOf(df.format(grossAmount)));
		        	 billProductInfoDAO.setSgst(Float.valueOf(df.format(sgst)));
		        	 billProductInfoDAO.setCgst(Float.valueOf(df.format(cgst)));
		        	 billProductInfoDAO.setIgst(Float.valueOf(df.format(igst)));
		        	 billProductInfoDAO.setAmountAfterDiscount(floatAmountAftDiscount);
		        	 billProductInfoDAO.setAmount(this.getAmount());
				
				
				
	        	
	        	 this.getProductInfoList().add(billProductInfoDAO);
	        	
	        	float floatTotalAmount = 0.0F;
	        	float floatTotalDiscount = 0.0F;
	        	float floatTotalAmtAfterDiscount = 0.0F;
	        	
	        	
	        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
	        	{
	        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
	        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
	        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
	        		
	        	}
	        
	        	this.getQuotationInfoDAO().setBillDate(this.getQuotationDateTime());
	        	this.getQuotationInfoDAO().setBillNumber(this.getQuotationNumber());	        	
        		this.getQuotationInfoDAO().setPaymentType(this.getPaymentType());
        		this.getQuotationInfoDAO().setBillType(this.getBillType());
        		this.getQuotationInfoDAO().setCustomerName(this.getCustomerName());        		
	        	this.getQuotationInfoDAO().setBillSaved(false);
	        	this.getQuotationInfoDAO().setSendSMS(false);
	        	this.getQuotationInfoDAO().setDiscountType(this.getDiscountType());
	        	
	        	
	        	if(this.getQuotationInfoDAO().getTransportCharge() == null)
	        	{
	        		this.getQuotationInfoDAO().setTransportCharge(0.0F);
	        	}
	        	
	        	this.getQuotationInfoDAO().setTransportCharge(this.getTransportCharge());
	        	this.getQuotationInfoDAO().setComments(this.getComments());
	        	this.setBillSaved(false);
	        	
	        	String custMobNum  = "0";
	        	
	        	if(this.getQuotationInfoDAO().getCustomerMobile() == null || this.getQuotationInfoDAO().getCustomerMobile().equals(""))
	        	{
	        	
		        	String [] custData = new String[5];
		        	
		        	try
		        	{
		        		custData = this.getCustomerName().split("-");
		        		custMobNum = custData[2];
		        		if(!(custMobNum.length() == 10))
		        		{
		        			this.getQuotationInfoDAO().setSendSMS(false);
		        		}
		        		
		        	}
		        	catch(Exception e)
		        	{
		        		if(getAlternateMobileNumber().length()==10)
		        		{
		        			custMobNum = getAlternateMobileNumber();
		        			this.getQuotationInfoDAO().setSendSMS(true);
		        		}
		        		else
		        		{
		        			this.getQuotationInfoDAO().setSendSMS(false);
		        		}
		        	}
	        	this.getQuotationInfoDAO().setCustomerMobile(custMobNum.trim());
	        	}
	        	//System.out.println("view : "+viewBill);
	        	
	        	
	        	
       			
	        	float transportCharge = 0.0F;
	        	if(this.getTransportCharge() == null )
	        	{
	        		this.setTransportCharge(0.0F);
	        		this.getQuotationInfoDAO().setTransportCharge(0.0F);
	        	}
	        	if(this.getTransportCharge() != null || !this.getTransportCharge().equals(""))
	        	{
	        		
	        		try
	        		{
	        			transportCharge = this.getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{
	        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
	        		}
	        	}
	        	
	        	if(!hasActionErrors())
	        	{
		        	this.setTotalAmount(""+(floatTotalAmount+this.getQuotationInfoDAO().getTransportCharge()));	        	
		        	this.setTotalDiscount(""+floatTotalDiscount+this.getQuotationInfoDAO().getTransportCharge());
		        	this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getQuotationInfoDAO().getTransportCharge()));
		        	this.
		        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
	        	}
	        	else
	        	{
	        		this.setTotalAmount(""+(floatTotalAmount+this.getQuotationInfoDAO().getTransportCharge()));	        	
	        		this.setTotalDiscount(""+floatTotalDiscount+this.getQuotationInfoDAO().getTransportCharge());
	        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getQuotationInfoDAO().getTransportCharge()));
		        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
	        	}
	        	removeVaules= "true";
	        	
	        	
	        	
	        	
	        	this.getSessionMap().put("quotationInformation", this.getQuotationInfoDAO());
	        	this.getSessionMap().put("quotationProductList",  this.getProductInfoList());
	        	
	        	
	        	result = SUCCESS;
	        	
	        	this.setProductName("");
	        	this.setProductMarathiName("");
	        	this.setQuantity(0.0F);
	        	this.setSalesRate(0.0F);
	        	this.setAmount(0.0F);
	        	this.setDiscountRupees(0.0F);
	        	this.setAmountAfterDiscount(0.0F);
	        	this.setTransportCharge(this.getQuotationInfoDAO().getTransportCharge());
	        	this.setSalesUnit("");
	        	//this.setTaxPercentage("");
	        
	        	this.setAmountPaid("0.0");
	        }
	     
	        return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		
		session=ServletActionContext.getRequest().getSession(false); 
		List<BillProductInfoDAO> productInfoListTest = (List<BillProductInfoDAO>) this.getSessionMap().get("quotationProductList");
		this.setAddSideBarJs("FALSE");
		
		discountTypeList.put("", "Select Discount Type");
	      discountTypeList.put("By Quantity", "By Quantity");
	      discountTypeList.put("By Percentage", "By Percentage");
	      discountTypeList.put("By Direct Amount", "By Direct Amount");
			
  	
		//String checkCustName = (String) sessionMap.get("checkCustName");
    	
    	if(productInfoListTest == null)
    	{    	
    		this.setDefaultValue("CASH");
    	}
    	else
    	{
    		this.setDefaultValue(getPaymentType());
    	}
    	
    	
    	
    	

    	try {
			taxList = GetListResource.GetTaxList();
			
		} catch (IOException e) {
			
		}
    	
    	unitList = GetListResource.GetUnitList();
    	//setBillType(billTypeList.get("CASH-MEMO"));
    	
    	if(this.getCustomerName() == null || this.getProductName().equals("") 
				|| this.getSalesUnit().equals("") || this.getTaxPercentage().equals("") )
		{
			addActionError(this.getText("message.error.filedsMarkedWithAstrickAreMandetory1"));
		}
		if(!hasActionErrors())
		{
			
			if(this.getSalesRate() == null 
					|| this.getQuantity() == null 
					|| this.getDiscountPercentage() == null 
					|| this.getDiscountRupees() == null
					|| this.getAmount() ==null)
			{
				addActionError(this.getText("message.error.filedsMarkedWithAstrickAreMandetory2"));
			}
		}
		if(!hasActionErrors())
		{
			if(getCustomerName().equals("Customer_Not_Found"))
			{
				addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
			}
		}
		if(getCustomerName().equals("Customer_Not_Found"))
		{
			addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
		}
	
		
		if(!hasActionErrors())
		{

			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", "NA", getProductName().split("-")[1]);
			
			isCustomerAdded = result[0];
			
			if(!isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productNameGivenNotFoundPlzProvideCorrectProductName"));
			}	
			
		}
		
		quotationInfoDAO = (BillInformationDAO) this.getSessionMap().get("quotationInformation");
		/*if(!hasActionErrors())
		{
			if(this.getBillInfoDAO() == null)
			{
				String isChalanNumberAdded = "false";
				
				String [] result = new String[2];
				
				result = new CheckAlreadyAvailable().checkAvaibility("billinfo", "chalan_number", "NA", this.getChalanNumber());
				
				isChalanNumberAdded = result[0];
				
				if(isChalanNumberAdded.equals("true"))
				{
					addActionError("This chalan number is already added! Please change chalan number!");
				}	
			}*/
			/*if(this.getBillInfoDAO() != null && this.getBillInfoDAO().getBillNumber().equals("NA"))
			{
				String isChalanNumberAdded = "false";
				
				String [] result = new String[2];
				
				result = new CheckAlreadyAvailable().checkAvaibility("billinfo", "chalan_number", "NA", this.getChalanNumber());
				
				isChalanNumberAdded = result[0];
				
				if(isChalanNumberAdded.equals("true"))
				{
					addActionError("This chalan number is already added! Please change chalan number!");
				}	
			}
			
			
		}*/
		
		if(!hasActionErrors())
		{
			if(this.getSalesRate() == null || this.getSalesRate().equals(""))
			{
				
					addActionError(this.getText("message.error.plzProvideCorrectSalesRate"));
				
			}
		}
		

					if(!hasActionErrors())
					{
		
		    			
		    			if(this.getDiscountType() == null || this.getDiscountType().equals(""))
		    			{
		    				
		    					addActionError(this.getText("message.error.plzProvideDiscountType"));
		    				
		    			}
		    		}
		    		
		    	
		  
		  
		  
		if(!hasActionErrors())
		{
			//System.out.println(this.getQuantity());
			if(this.getQuantity() == null || this.getQuantity().equals(""))
			{
				
					addActionError(this.getText("message.error.plzprovideCorrectQuantity"));
				
			}
		}
		if(!hasActionErrors())
		{
			if(this.getDiscountPercentage() == null ||  this.getDiscountPercentage().equals(""))
			{
				
					addActionError(this.getText("message.error.plzProvideCorrectDiscountPercentage"));
				
			}
		}
		if(!hasActionErrors())
		{
			if(this.getDiscountRupees() == null || this.getDiscountRupees().equals(""))
			{
				
					addActionError(this.getText("message.error.plzprovideCorrectDiscountRupees"));
				
			}
		}
		
		if(productInfoListTest !=null)
		{
			if(!productInfoListTest.isEmpty())
			{
				for(BillProductInfoDAO infoDAO:productInfoListTest)
				{
					
					
					if(infoDAO.getProductName().equals(this.productName))
					{
						addActionError(this.getText("message.error.productIsAlreadyAddedToList"));
						productInfoList = productInfoListTest;
					}
					
				}
			}
			else
			{
				productInfoList = productInfoListTest;
			}
		}
		
		
		
		float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	if(productInfoList == null)
    	{
    		productInfoList = (List<BillProductInfoDAO>) session.getAttribute("quotationProductList");
    	}
    	
    	if(productInfoList !=null)
    	{
	    	for(BillProductInfoDAO infoDAO : productInfoList)
	    	{
	    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
	    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
	    		
	    		
	    	}
	    	floatTotalDiscount = floatTotalAmount - floatTotalAmtAfterDiscount;
	    	
	    	this.setTotalAmount(""+floatTotalAmount);
	    	this.setTotalDiscount(""+floatTotalDiscount);
	    	this.setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
    	}
    	if(getCustomerName().equals("Customer_Not_Found"))
    	{
    		addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
    	}
    	
    	
    	
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	


	public String getQuotationDateTime() {
		return quotationDateTime;
	}

	public void setQuotationDateTime(String quotationDateTime) {
		this.quotationDateTime = quotationDateTime;
	}

	public String getOperator() {
		return operator;
	}


	public void setOperator(String operator) {
		this.operator = operator;
	}


	public String getPaymentType() {
		return paymentType;
	}


	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}


	public String getCustomerName() {
		return customerName;
	}


	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public String getAlias() {
		return alias;
	}


	public void setAlias(String alias) {
		this.alias = alias;
	}





	public String getSalesUnit() {
		return salesUnit;
	}

	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}

	

	public String getTaxPercentage() {
		return taxPercentage;
	}

	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}

	public Float getSalesRate() {
		return salesRate;
	}

	public void setSalesRate(Float salesRate) {
		this.salesRate = salesRate;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getDiscountPercentage() {
		return discountPercentage;
	}

	public void setDiscountPercentage(Float discountPercentage) {
		this.discountPercentage = discountPercentage;
	}

	public Float getDiscountRupees() {
		return discountRupees;
	}

	public void setDiscountRupees(Float discountRupees) {
		this.discountRupees = discountRupees;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public void setAmountAfterDiscount(Float amountAfterDiscount) {
		this.amountAfterDiscount = amountAfterDiscount;
	}

	public void setTotalPaybleAmount(Float totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	
	public String getQuotationNumber() {
		return quotationNumber;
	}

	public void setQuotationNumber(String quotationNumber) {
		this.quotationNumber = quotationNumber;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}


	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getProductMarathiName() {
		return productMarathiName;
	}

	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}

	
	public Float getAmountAfterDiscount() {
		return amountAfterDiscount;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}

	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getRemoveVaules() {
		return removeVaules;
	}

	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}


	public BillInformationDAO getQuotationInfoDAO() {
		return quotationInfoDAO;
	}

	public void setQuotationInfoDAO(BillInformationDAO quotationInfoDAO) {
		this.quotationInfoDAO = quotationInfoDAO;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	
	public Float getTransportCharge() {
		return transportCharge;
	}

	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getViewBill() {
		return viewBill;
	}

	public void setViewBill(String viewBill) {
		this.viewBill = viewBill;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}

	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}

	public boolean isBillSaved() {
		return billSaved;
	}

	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	public Float getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public String getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(String amountPaid) {
		this.amountPaid = amountPaid;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getDiscountType() {
		return discountType;
	}

	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}

	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}

	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}



	
	

}

