package com.stonecrusher.add;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewVehicleTripEntry extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -351947127661923294L;
	
	
	private HttpSession session;
	
	private String tripDate;
	private String vehicleId;
	private String customerName;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private Float transportationCharges;
	private String addSideBarJs;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private SessionMap<String,Object> sessionMap;  
	
	public String execute(){
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				
				String db = (String) session.getAttribute("db");
				String user = (String) session.getAttribute("userFullName");
				String shortName = "";
				String [] customerDetails = new String[5];
				String customerId = "";
				String customerName = "";
				String customerMobile = "";
				try
				{
					customerDetails = this.getCustomerName().split("-");
					customerId = customerDetails[0];
					customerName = customerDetails[1];
					customerMobile = customerDetails[2];
				}catch(Exception e)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCustomerIdAndName"));
				}
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
				if(!hasActionErrors())
				{
					
					
					 java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
					
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						
						
						
						sql = "SELECT "
								+ "trip_entry_id "
								+ "FROM "
								+ "crusher_vehicle_trip_other_master "
								+ "WHERE "
						        + "crusher_id = ? " 
						        + "AND "
						        + "crusher_code = ? " 
						        + "ORDER BY "
								+ "trip_entry_id "										
								+ "DESC LIMIT 1;";
						
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId); 
					preparedStatement.setString(2, crusherCode); 

					
					resultSet = preparedStatement.executeQuery();
				
					int newTripId = 1;
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							newTripId = Integer.parseInt(resultSet.getString(1));
							
							
							newTripId= newTripId+1;
						}
						else
						{
							newTripId =1;
							
						}
					}
					else
					{	
						newTripId =1;						
					}
					
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
						int rowAdded = 0;
						
						sql = "INSERT "
								+ "INTO "
								+ "crusher_vehicle_trip_other_master "
								+ "("
								+ "crusher_id,"
								+ "crusher_code,"
								+ "trip_entry_id,"
								+ "trip_date,"
								+ "trip_time,"
								+ "vehicle_id,"
								+ "customer_id,"
								+ "customer_name,"
								+ "product_id,"
								+ "product_name,"
								+ "product_quantity,"
								+ "vehicle_km_start,"
								+ "vehicle_km_end,"
								+ "trip_total_km,"
								+ "trip_start_from,"
								+ "trip_end_to,"
								+ "total_trip_count,"
								+ "transportation_charges ) "
								+ "VALUES "
								+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setInt(3, newTripId);
						preparedStatement.setString(4, this.getTripDate());
						preparedStatement.setTime(5, time);
						preparedStatement.setString(6, this.getVehicleId());
						preparedStatement.setString(7, customerId);
						preparedStatement.setString(8, customerName);
						preparedStatement.setString(9,this.getMaterialName().split("-")[0]);
						preparedStatement.setString(10,this.getMaterialName().split("-")[1]);						
						preparedStatement.setFloat(11, this.getMaterialVolume());
						preparedStatement.setFloat(12, this.getKmStart());
						preparedStatement.setFloat(13, this.getKmEnd());
						preparedStatement.setFloat(14, this.getTotalKm());
						preparedStatement.setString(15, this.getTripFrom());
						preparedStatement.setString(16, this.getTripTo());
						preparedStatement.setInt(17, this.getTotalTrips());
						preparedStatement.setFloat(18, this.getTransportationCharges());
						
						rowAdded = preparedStatement.executeUpdate();
						
						if(rowAdded > 0)
						{
							this.setVehicleId("");
		       				this.setCustomerName("");
		       				this.setMaterialName("");
		       				this.setMaterialVolume(0.0F);
		       				this.setKmStart(0.0F);
		       				this.setKmEnd(0.0F);
		       				this.setTotalKm(0.0F);
		       				this.setTripFrom("");
		       				this.setTripTo("");
		       				this.setTotalTrips(0);
		       				this.setTransportationCharges(0.0F);
		       				result = "success";
							addActionMessage(this.getText("message.success.vehicleTripDetailsAddedSuccessfully"));
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							sql = "SELECT "
			    					+ "vehicle_id,"
			    					+ "vehicle_make,"
			    					+ "vehicle_registration_number "
			    					+ "FROM "
			    					+ "crusher_vehicle_details_master "
			    					+ "WHERE "
							        + "crusher_id = ? " 
							        + "AND "
							        + "crusher_code = ?";
			    			
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			preparedStatement.setString(1, crusherId); 
							preparedStatement.setString(2, crusherCode); 

							resultSet = preparedStatement.executeQuery();


			    			while(resultSet.next())
			    			{
			    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
			    			}
							
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.errorVehicleTripDetailsNotAddedPlzTryAgaian"));
						}
						
						
					}catch (SQLException e) {
						result = "error";
						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.vehicleTripDetailsNotAdded"));
					} catch (Exception e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.vehicleTripDetailsNotAdded"));
					}finally {
						if(resultSet != null)
						{

							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        }else
	        {
	        	result = "error";
	        	
	        }
	        
	        
	     }
	        return result;
	}

	@Override
	public void validate() {
		
		if(this.getVehicleId()!= null)
		{
			if(this.getVehicleId().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectVehicle"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getCustomerName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCustomerName"));
			}
			else
			{
				try
				{
					String [] custDetails = this.getCustomerName().split("-");
					
					String custId = custDetails[0];
					String custName = custDetails[1];


					String isCustomerAdded = "false";
					
					String [] result = new String[2];
					String condition  = "AND customer_name = '"+custName+"'";
					result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "customer_id", condition, custId);
					
					isCustomerAdded = result[0];
					
					if(isCustomerAdded.equals("false"))
					{
						addActionError(this.getText("message.error.customerNameProvidedByYouIsNotAvailable"));
					}		
					
				}catch(Exception e)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
				}
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getMaterialName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideMaterialName"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getMaterialVolume() == null || this.getMaterialVolume().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectMaterialVolume"));
			}
			else if(this.getMaterialVolume() <= 0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectMaterialVolume"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getKmStart() == null || this.getKmStart().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectStartKm"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getKmEnd() == null || this.getKmEnd().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideCorrectEndKm"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalKm() == null || this.getTotalKm().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideCorrectTotalLm"));
			}
			else if(this.getTotalKm() <=0 )
			{
				addActionError(this.getText("message.error.plzprovideCorrectTotalLm"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTripFrom().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideTripFromDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTripTo().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideTripToDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalTrips() == null || this.getTotalTrips().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectTotalTripFigure"));
			}
			else if(this.getTotalTrips() <= 0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectTotalTripFigure"));
			}
				
		}
		
		
		
		if(!hasActionErrors())
		{
			if(this.getTransportationCharges() == null || this.getTransportationCharges().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectTransportCharges"));
			}
			else if(this.getTransportationCharges() < 0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectTransportCharges"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			String isMaterialAdded = "false";
			
			String [] result = new String[2];
			String condition  = "NA";
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", condition, this.getMaterialName().split("-")[1].trim().toUpperCase());
			
			isMaterialAdded = result[0];
			
			if(isMaterialAdded.equals("false"))
			{
				addActionError(this.getText("message.error.materialNameProvidedByYouIsNotAvailable"));
			}		
		}
		session=ServletActionContext.getRequest().getSession(false); 
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String sql = "";
		String db = (String) session.getAttribute("db");
		
		try
		{
			
			
			
		
			connection = GetDBConnection.getDBConnection(db);
			sql = "SELECT "
					+ "vehicle_id,"
					+ "vehicle_make,"
					+ "vehicle_registration_number "
					+ "FROM "
					+ "crusher_vehicle_details_master ";
			
			
			preparedStatement = connection.prepareStatement(sql);
			resultSet = preparedStatement.executeQuery();


			while(resultSet.next())
			{
				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
			}
		}catch (SQLException e) {
			
			addActionError(e.getErrorCode()+" || "+e.getMessage());
		} catch (Exception e) {
			
								
			addActionError(e.getMessage()+" || "+e.getCause());
		}finally {
			if(resultSet != null)
			{

				try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			if(connection != null)
			{
				
				try {connection.close(); connection = null;}catch (SQLException e) {}
			}
			
		}
		
		this.setAddSideBarJs("FALSE");
		
		
	}
	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getTripDate() {
		return tripDate;
	}


	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public String getCustomerName() {
		return customerName;
	}


	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public String getMaterialName() {
		return materialName;
	}


	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}


	public Float getMaterialVolume() {
		return materialVolume;
	}


	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}


	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}


	public Float getKmEnd() {
		return kmEnd;
	}


	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}


	public Float getTotalKm() {
		return totalKm;
	}


	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}


	public String getTripFrom() {
		return tripFrom;
	}


	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}


	public String getTripTo() {
		return tripTo;
	}


	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}


	public Integer getTotalTrips() {
		return totalTrips;
	}


	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	



	


	public Float getTransportationCharges() {
		return transportationCharges;
	}


	public void setTransportationCharges(Float transportationCharges) {
		this.transportationCharges = transportationCharges;
	}


	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
	

}
