package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewVehicleDetailsAndroid extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3861179817044789970L;
	private HttpSession session;
	private String vehicleMake;
	private String vehicleRegistrationNumber;
	private String vehicleOwnerName;
	private String ownerMobileNumber;
	private String vehicleDriverName;
	private String driverMobileNumber;
	private String insuranceCompanyName;
	private String insuranceContactNumber;
	private String insuranceStartDate;
	private String insuranceEndDate;
	private String taxReceiptStartDate;
	private String taxReceiptEndDate;
	private String rtoPassingStartDate;
	private String rtoPassingEndDate;
	private File insurancePDF;
	private File taxReceiptPDF;
	private File rtoPassingPDF;
	private String addSideBarJs;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private SessionMap<String,Object> sessionMap;  
	
	private Float carryingCapacityBrass;
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
				
				String sql = "";
				
				String db = (String) session.getAttribute("db");
				
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						int rowAdded = 0;
						
						
						FileInputStream insuranceFileFis  = null;
						FileInputStream taxReceiptFileFis  = null;
						FileInputStream rtoPassingFileFis = null;
						if(this.getInsurancePDF() != null)
						{
							insuranceFileFis =  new FileInputStream(this.getInsurancePDF());
						}
						if(this.getTaxReceiptPDF() != null)
						{
							taxReceiptFileFis =  new FileInputStream(this.getTaxReceiptPDF());
						}
						
						if(this.getRtoPassingPDF() != null)
						{
							rtoPassingFileFis =  new FileInputStream(this.getRtoPassingPDF());
						}
						
						
						sql = "INSERT "
								+ "INTO "
								+ "crusher_vehicle_details_master "
								+ "(crusher_id,"
								+ "crusher_code,"
								+ "vehicle_make,"
								+ "vehicle_registration_number,"
								+ "owner_name,"
								+ "owner_mobile_number,"
								+ "driver_name,"
								+ "driver_mobile_number,"
								+ "vehicle_insurance_name,"
								+ "vehicle_insurance_company_contact,"
								+ "insurance_start_date,"
								+ "insurance_end_date,"
								+ "tax_receipt_start_date,"
								+ "tax_receipt_end_date,"
								+ "rto_passing_start_date,"
								+ "rto_passing_end_date)"
								+ "VALUES "
								+ "(?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),STR_TO_DATE(?, '%d-%m-%Y'),STR_TO_DATE(?, '%d-%m-%Y'),STR_TO_DATE(?, '%d-%m-%Y'),STR_TO_DATE(?, '%d-%m-%Y'),STR_TO_DATE(?, '%d-%m-%Y'))";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, this.getVehicleMake().trim().toUpperCase());
						preparedStatement.setString(4, this.getVehicleRegistrationNumber().trim().toUpperCase());
						preparedStatement.setString(5, this.getVehicleOwnerName());
						preparedStatement.setString(6, this.getOwnerMobileNumber());
						preparedStatement.setString(7, this.getVehicleDriverName());
						preparedStatement.setString(8, this.getDriverMobileNumber());
						preparedStatement.setString(9, this.getInsuranceCompanyName());
						preparedStatement.setString(10, this.getInsuranceContactNumber());
						preparedStatement.setString(11, this.getInsuranceStartDate());
						preparedStatement.setString(12, this.getInsuranceEndDate());
						preparedStatement.setString(13, this.getTaxReceiptStartDate());
						preparedStatement.setString(14, this.getTaxReceiptEndDate());
						preparedStatement.setString(15, this.getRtoPassingStartDate());
						preparedStatement.setString(16, this.getRtoPassingEndDate());
						//preparedStatement.setBinaryStream(9, insuranceFileFis,(int)this.getInsurancePDF().length() );
					
						
						rowAdded = preparedStatement.executeUpdate();
						
						
						if(rowAdded > 0 )
						{
							if(this.getInsurancePDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "insurance_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, insuranceFileFis,(int)this.getInsurancePDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 
							 preparedStatement.executeUpdate();
							}
							
							if(this.getTaxReceiptPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "tax_receipt_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, taxReceiptFileFis,(int)this.getTaxReceiptPDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 
							 preparedStatement.executeUpdate();
							}
							
							if(this.getRtoPassingPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "rto_passing_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
								
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, rtoPassingFileFis,(int)this.getRtoPassingPDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
						
								result = "success";
								addActionMessage("Vehicle details added successfully!");
							
							
							
						}
						else
						{
							result = "error";
							addActionError("Unable to add vehicle details! Please try again!");
						}
						
						if(insuranceFileFis != null)
			        	{
							insuranceFileFis.close();
							insuranceFileFis = null;
			        	}
						
						if(taxReceiptFileFis != null)
			        	{
							taxReceiptFileFis.close();
							taxReceiptFileFis = null;
			        	}
						

						if(rtoPassingFileFis != null)
			        	{
							rtoPassingFileFis.close();
							rtoPassingFileFis = null;
			        	}
						
					}catch (SQLException e) {
						result = "error";
						//e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Vehicle details not added !");
					} catch (Exception e) {
						//e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || Vehicle details not added !");
					}finally {
						
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
					
	        	
	        }
	        
	        customerSearchOptionList.put("BYNAME", "BY NAME");
        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
			setCustomerSearchOption("BYNAME");
			setDefaultValue("BYNAME");
	        
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		if(this.getVehicleMake().equals(""))
		{
			addActionError("Please provide vehicle make!");
		}
		if(!hasActionErrors())
		{
			if(this.getVehicleRegistrationNumber().equals(""))
			{
				addActionError("Please provide vehicle registration number!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleOwnerName() == null || this.getVehicleOwnerName().equals(""))
			{
				addActionError("Please provide vehicle owner name!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getOwnerMobileNumber() == null || this.getOwnerMobileNumber().equals(""))
			{
				addActionError("Please provide owner mobile number");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleDriverName() == null || this.getVehicleDriverName().equals(""))
			{
				addActionError("Please provide vehicle Driver Name!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getDriverMobileNumber() == null || this.getDriverMobileNumber().equals(""))
			{
				addActionError("Please provide driver mobile number!");
			}
		}
		
		if(!hasActionErrors())
		{
			String isVehicleAdded = "false";
			
			String [] result = new String[2];
			String condition  = "NA";
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_vehicle_details_master", "vehicle_registration_number", condition, this.getVehicleRegistrationNumber().trim().toUpperCase());
			
			isVehicleAdded = result[0];
			
			if(isVehicleAdded.equals("true"))
			{
				addActionError("Vehicle with this registration number is already added!");
			}		
		}
	
		
		
		if(!hasActionErrors())
		{
			if(this.getCarryingCapacityBrass() == null || this.getCarryingCapacityBrass().equals(""))
			{
				addActionError("Please provide correct carrying capacity!");
			}
		}
		
		this.setAddSideBarJs("FALSE");
	} 
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getVehicleMake() {
		return vehicleMake;
	}
	public void setVehicleMake(String vehicleMake) {
		this.vehicleMake = vehicleMake;
	}
	public String getVehicleRegistrationNumber() {
		return vehicleRegistrationNumber;
	}
	public void setVehicleRegistrationNumber(String vehicleRegistrationNumber) {
		this.vehicleRegistrationNumber = vehicleRegistrationNumber;
	}
	public String getInsuranceCompanyName() {
		return insuranceCompanyName;
	}
	public void setInsuranceCompanyName(String insuranceCompanyName) {
		this.insuranceCompanyName = insuranceCompanyName;
	}
	public String getInsuranceContactNumber() {
		return insuranceContactNumber;
	}
	public void setInsuranceContactNumber(String insuranceContactNumber) {
		this.insuranceContactNumber = insuranceContactNumber;
	}
	public String getInsuranceStartDate() {
		return insuranceStartDate;
	}
	public void setInsuranceStartDate(String insuranceStartDate) {
		this.insuranceStartDate = insuranceStartDate;
	}
	public String getInsuranceEndDate() {
		return insuranceEndDate;
	}
	public void setInsuranceEndDate(String insuranceEndDate) {
		this.insuranceEndDate = insuranceEndDate;
	}
	public String getTaxReceiptStartDate() {
		return taxReceiptStartDate;
	}
	public void setTaxReceiptStartDate(String taxReceiptStartDate) {
		this.taxReceiptStartDate = taxReceiptStartDate;
	}
	public String getTaxReceiptEndDate() {
		return taxReceiptEndDate;
	}
	public void setTaxReceiptEndDate(String taxReceiptEndDate) {
		this.taxReceiptEndDate = taxReceiptEndDate;
	}
	public File getInsurancePDF() {
		return insurancePDF;
	}
	public void setInsurancePDF(File insurancePDF) {
		this.insurancePDF = insurancePDF;
	}
	public File getTaxReceiptPDF() {
		return taxReceiptPDF;
	}
	public void setTaxReceiptPDF(File taxReceiptPDF) {
		this.taxReceiptPDF = taxReceiptPDF;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getRtoPassingStartDate() {
		return rtoPassingStartDate;
	}

	public void setRtoPassingStartDate(String rtoPassingStartDate) {
		this.rtoPassingStartDate = rtoPassingStartDate;
	}

	public String getRtoPassingEndDate() {
		return rtoPassingEndDate;
	}

	public void setRtoPassingEndDate(String rtoPassingEndDate) {
		this.rtoPassingEndDate = rtoPassingEndDate;
	}

	public File getRtoPassingPDF() {
		return rtoPassingPDF;
	}

	public void setRtoPassingPDF(File rtoPassingPDF) {
		this.rtoPassingPDF = rtoPassingPDF;
	}

	public String getVehicleOwnerName() {
		return vehicleOwnerName;
	}

	public void setVehicleOwnerName(String vehicleOwnerName) {
		this.vehicleOwnerName = vehicleOwnerName;
	}

	public String getOwnerMobileNumber() {
		return ownerMobileNumber;
	}

	public void setOwnerMobileNumber(String ownerMobileNumber) {
		this.ownerMobileNumber = ownerMobileNumber;
	}

	public String getVehicleDriverName() {
		return vehicleDriverName;
	}

	public void setVehicleDriverName(String vehicleDriverName) {
		this.vehicleDriverName = vehicleDriverName;
	}

	public String getDriverMobileNumber() {
		return driverMobileNumber;
	}

	public void setDriverMobileNumber(String driverMobileNumber) {
		this.driverMobileNumber = driverMobileNumber;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Float getCarryingCapacityBrass() {
		return carryingCapacityBrass;
	}

	public void setCarryingCapacityBrass(Float carryingCapacityBrass) {
		this.carryingCapacityBrass = carryingCapacityBrass;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
	
	
}
