package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewSupplier extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8412376686785327300L;
	
	
	private HttpSession session;
	private String supplierAddDate;
	private String supplierName;
	private String personName;
	private String mobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber;
	private String PANumber;
	private String address;
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				
				String db = (String) session.getAttribute("db");
				
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						if(getGSTINumber().equals(""))
						{
							setGSTINumber("NA");
						}
						if(getTINumber().equals(""))
						{
							setTINumber("NA");
						}
						if(getPANumber().equals(""))
						{
							setPANumber("NA");
						}
						

						sql = "SELECT "
								+ "supplier_id "
								+ "FROM "
								+ "crusher_supplier_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "supplier_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId =resultSet.getInt(1);
							
							
							entryId = entryId+1;
						}
						else
						{
							entryId =1;
						}
					}
						
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
						
						sql = "INSERT INTO crusher_supplier_master "
								+ "("
								+ "supplier_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "add_date,"
								+ "supplier_name,"
								+ "contact_person_name,"
								+ "contact_number,"
								+ "supplier_email,"
								+ "supplier_gstin,"
								+ "supplier_pan,"
								+ "supplier_address) "								
								+ "values "
								+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?)";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setInt(1, entryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, getSupplierAddDate());
						preparedStatement.setString(5, getSupplierName().trim().toUpperCase());
						preparedStatement.setString(6, getPersonName().trim().toUpperCase());
						preparedStatement.setString(7, getMobileNumber().trim());
						preparedStatement.setString(8, getEmail());
						preparedStatement.setString(9, getGSTINumber().trim().toUpperCase());
				
						preparedStatement.setString(10, getPANumber().trim().toUpperCase());
						preparedStatement.setString(11, getAddress().trim().toUpperCase());
					
						int i = preparedStatement.executeUpdate();
						
						if(i>0)
						{
							result = "success";
							addActionMessage(this.getText("message.success.supplierDetailsAddedSuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.errorSupplierDetailsNotAddedPlzTryAgain"));
						}
						
						
					}catch (SQLException e) {
						result = "error";
						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.supplierDetailsNotDetails"));
					} catch (IOException e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.supplierDetailsNotDetails"));
					}finally {
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	
	        	
	        }
	        return result;
	}
	

	public void validate() {
		
		if(getSupplierName().equals("") || getPersonName().equals("") || getMobileNumber().equals("") || getAddress().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}

		if(!hasActionErrors())
		{
			if(!getMobileNumber().equals(""))
			{
				if(getMobileNumber().length() >10)
				{
					addActionError(this.getText("message.error.plzProvideCorrectMobileNumber(10digit)"));
				}
			}
		}
		
		if(!hasActionErrors())
		{
			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_supplier_master", "supplier_name", "NA", getSupplierName());
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.supplierIsAlreadyAddedWithSameName"));
			}				
			
		}
		
		if(!hasActionErrors())
		{
			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_supplier_master", "contact_number", "NA", getMobileNumber());
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.supplierIsAlreadyAddedWithSameContactNumber"));
			}				
			
		}
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getSupplierAddDate() {
		return supplierAddDate;
	}

	public void setSupplierAddDate(String supplierAddDate) {
		this.supplierAddDate = supplierAddDate;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getPersonName() {
		return personName;
	}

	public void setPersonName(String personName) {
		this.personName = personName;
	}

	public String getMobileNumber() {
		return mobileNumber;
	}

	public void setMobileNumber(String mobileNumber) {
		this.mobileNumber = mobileNumber;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getGSTINumber() {
		return GSTINumber;
	}

	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}

	public String getTINumber() {
		return TINumber;
	}

	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}

	public String getPANumber() {
		return PANumber;
	}

	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	

}
