package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewLaborDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7265344080433556418L;
	private SessionMap<String,Object> sessionMap;
	private String customerSearchOption;
	private String defaultValue;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private HttpSession session;
	private String laborName;
	private String laborMobileNumber;
	private String address;
	private String birthDate;
	private String joiningDate;
	private String laborId;
	private File laborImage;
	private String addSideBarJs;
	private String adharNumber;
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				FileInputStream fis  = null;
				if(this.getLaborImage() != null)
				{
				 fis =  new FileInputStream(this.getLaborImage());
				}
			
					try
					{
						int newLaborId = 1;
						int rowAdded = 0;
						connection = GetDBConnection.getDBConnection(db);
						
						sql = "SELECT "
								+ "employee_id "
								+ "FROM "
								+ "crusher_employee_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "employee_id "
								+ "DESC LIMIT 1;";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								newLaborId = Integer.parseInt(resultSet.getString(1))+1;									
							
							}
							else
							{
								newLaborId =1;
							}
						}
						else
						{
							newLaborId =1;
						}
						
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						if(this.getLaborImage() != null)
						{
							sql = "INSERT INTO "
									+ "crusher_employee_master "
									+ "(employee_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "employee_name,"
									+ "employee_mobile_number,"
									+ "employee_address,"
									+ "employee_birth_date,"
									+ "employee_image,"
									+ "joining_date,"
									+ "adhar_number) "
									+ "VALUES "
									+ "(?,?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,STR_TO_DATE(?,'%d-%m-%Y'),?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, newLaborId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getLaborName().trim().toUpperCase());
							preparedStatement.setString(5, this.getLaborMobileNumber().trim());
							preparedStatement.setString(6, this.getAddress().trim().toUpperCase());
							preparedStatement.setString(7, this.getBirthDate());
							preparedStatement.setBinaryStream(8, fis,(int)this.getLaborImage().length() );
							
							if(this.getJoiningDate() == null || this.getJoiningDate().equals("")) {
									preparedStatement.setString(9, null);
								
							}else {
								preparedStatement.setString(9, this.getJoiningDate());
								
							}
							preparedStatement.setString(10, this.getAdharNumber().trim());
							
							rowAdded = preparedStatement.executeUpdate();
						}
						else if(this.getLaborImage() == null)
						{	
								sql = "INSERT INTO "
									+ "crusher_employee_master "
									+ "(employee_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "employee_name,"
									+ "employee_mobile_number,"
									+ "employee_address,"
									+ "employee_birth_date,"
									+ "joining_date,"
									+ "adhar_number)"
									+ "VALUES "
									+ "(?,?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),STR_TO_DATE(?,'%d-%m-%Y'),?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, newLaborId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getLaborName().trim().toUpperCase());
							preparedStatement.setString(5, this.getLaborMobileNumber().trim());
							preparedStatement.setString(6, this.getAddress().trim().toUpperCase());
							preparedStatement.setString(7, this.getBirthDate());
							if(this.getJoiningDate() == null || this.getJoiningDate().equals("")) {
								preparedStatement.setString(8, null);
								
							}else {
								preparedStatement.setString(8, this.getJoiningDate());
								
							}
							preparedStatement.setString(9, this.getAdharNumber().trim());
							
							rowAdded = preparedStatement.executeUpdate();
						}
						
						if(rowAdded > 0)
						{
							this.setLaborId(""+newLaborId);
							addActionMessage(this.getText("message.success.empoyeeDetailsAddedSuccessfully"));
							result = SUCCESS;
						}
						else
						{
							addActionError(this.getText("message.error.empoyeeDetailsNotAddedPlzTryAgain"));
							result =ERROR;
							
						}
					}catch (SQLException e) {
						//e.printStackTrace();
						result =ERROR;				
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.empoyeeDetailsNotAdded"));
					
					} catch (IOException e) {
						//e.printStackTrace();
						result =ERROR;			
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.empoyeeDetailsNotAdded"));
					
					}finally {
						if(resultSet != null)
						{
							try{resultSet.close(); resultSet = null;}catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	if(fis != null)
	        	{
	        		fis.close();
	        		fis = null;
	        	}
	        	
	        }
	        return result;
	}
		
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		
		if(this.getLaborName() == null || this.getLaborName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideEmployeeName"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getLaborMobileNumber() == null || this.getLaborMobileNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideEmployeeMobileNumber"));
			}else if(this.getLaborMobileNumber().length() != 10)
			{
				addActionError(this.getText("message.error.plzProvideEmployeeMobileNumber"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getAddress() == null || this.getAddress().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAddress"));
			}
				
		}
		
		if(!hasActionErrors())
		{
			if(this.getBirthDate() == null || this.getBirthDate().equals(""))
			{
				addActionError(this.getText("message.error.PlzSelectEmployeeBirthDate"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getAdharNumber() == null || this.getAdharNumber().equals(""))
			{
				addActionError("Please Provide Adhar Number !");
			}
		}
		
		
		
		if(!hasActionErrors())
		{
			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			String condition = "NA";
			
			result = new CheckAlreadyAvailable().checkCustomerAvaibilityWithOnlyOneCheck(this.getSessionMap(),"crusher_employee_master", "employee_mobile_number", "employee_name" ,this.getLaborMobileNumber().trim(), this.getLaborName(), condition);
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.employeeIsAlreadyAddedWithSameNameOrMobileNumber"));
			}				
			
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getLaborMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_employee_master", "employee_mobile_number",condition ,this.getLaborMobileNumber().trim() );
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError("Customer Is Already Added With Same Mobile Number !");
				}		
			}
			
		}
		
		
	}
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getLaborMobileNumber() {
		return laborMobileNumber;
	}

	public void setLaborMobileNumber(String laborMobileNumber) {
		this.laborMobileNumber = laborMobileNumber;
	}

	

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}

	public File getLaborImage() {
		return laborImage;
	}

	public void setLaborImage(File laborImage) {
		this.laborImage = laborImage;
	}

	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getJoiningDate() {
		return joiningDate;
	}

	public void setJoiningDate(String joiningDate) {
		this.joiningDate = joiningDate;
	}

	public String getAdharNumber() {
		return adharNumber;
	}

	public void setAdharNumber(String adharNumber) {
		this.adharNumber = adharNumber;
	}

	


}
