package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.bulksmsgateway.AddBulkSMSGatewayResponseToDB;
import com.stonecrusher.bulksmsgateway.SendBulkSMSGatewayMessage;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewCustomerAndroid extends ActionSupport implements SessionAware, ServletRequestAware,ServletResponseAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5130010812118775769L;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;

	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private String custAddDate;
	private String custName;
	private String custNameMarathi;
	private String custMobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber = "NA";
	private String PANumber;
	private String billingAddress;
	private String billingAddressMrathi;
	private String birthDate;
	private Float creditLimit;
	private String custSecondaryMobileNumber;
	private boolean sendSMS;
	private File customerImage;
	private String pinCode;
	
	private String addSideBarJs;
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	

	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    	  }
		      }
		      
		      String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				FileInputStream fis  = null;
				if(this.getCustomerImage() != null)
				{
				 fis =  new FileInputStream(this.getCustomerImage());
				}
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	custAddDate = dateFormat.format(d);
			
					try
					{
						this.setEmail("NA");
						connection = GetDBConnection.getDBConnection(db);
						

						sql = "SELECT "
								+ "customer_id "
								+ "FROM "
								+ "crusher_customer_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "customer_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId =resultSet.getInt(1);
							
							
							entryId = entryId+1;
						}
						else
						{
							entryId =1;
						}
					}
						
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
						if(getGSTINumber().equals(""))
						{
							setGSTINumber("NA");
						}
						if(getTINumber().equals(""))
						{
							setTINumber("NA");
						}
						if(getPANumber().equals(""))
						{
							setPANumber("NA");
						}
						if(getCreditLimit().equals(""))
						{
							setCreditLimit(0.0F);
						}
						if(this.getCustomerImage() != null)
						{
							sql = "INSERT INTO crusher_customer_master "
									+ "("
									+ "customer_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "add_date,"
									+ "customer_name,"
									+ "cust_name_marathi,"
									+ "mobile_number,"
									+ "cust_secondary_mobile,"
									+ "gst_number,"
									+ "pan_number,"
									+ "tin_number,"
									+ "billing_address,"
									+ "billing_address_marathi,"
									+ "birth_date,"
									+ "credit_limit,"
									+ "customer_image,"
									+ "pincode_number,"
									+ "customer_status,"
									+ "customer_type) "
									+ "values "
									+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, entryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getCustAddDate());
							preparedStatement.setString(5, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(6, this.getCustNameMarathi());						
							preparedStatement.setString(7, this.getCustMobileNumber().trim());
							preparedStatement.setString(8, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(9, this.getGSTINumber().trim());
							preparedStatement.setString(10, this.getPANumber().trim().toUpperCase());
							preparedStatement.setString(11, this.getTINumber().trim().toUpperCase());
							preparedStatement.setString(12, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(13, this.getBillingAddressMrathi());
							preparedStatement.setString(14, this.getBirthDate());
							preparedStatement.setFloat(15, this.getCreditLimit());
							preparedStatement.setBinaryStream(16, fis,(int)this.getCustomerImage().length());
							preparedStatement.setString(17, this.getPinCode());
							preparedStatement.setString(18, "ACTIVE");
							preparedStatement.setString(19, "REGULER");
							
						}
						else
						{
							sql = "INSERT INTO crusher_customer_master "
									+ "("
									+ "customer_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "add_date,"
									+ "customer_name,"
									+ "cust_name_marathi,"
									+ "mobile_number,"
									+ "cust_secondary_mobile,"
									+ "gst_number,"
									+ "pan_number,"
									+ "tin_number,"
									+ "billing_address,"
									+ "billing_address_marathi,"
									+ "birth_date,"
									+ "credit_limit,"
									+ "pincode_number,"
									+ "customer_status,"
									+ "customer_type) "
									+ "values "
									+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, entryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getCustAddDate());
							preparedStatement.setString(5, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(6, this.getCustNameMarathi());						
							preparedStatement.setString(7, this.getCustMobileNumber().trim());
							preparedStatement.setString(8, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(9, this.getGSTINumber().trim());
							preparedStatement.setString(10, this.getPANumber().trim().toUpperCase());
							preparedStatement.setString(11, this.getTINumber().trim().toUpperCase());
							preparedStatement.setString(12, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(13, this.getBillingAddressMrathi());
							preparedStatement.setString(14, this.getBirthDate());
							preparedStatement.setFloat(15, this.getCreditLimit());
							preparedStatement.setString(16, this.getPinCode());
							preparedStatement.setString(17, "ACTIVE");
							preparedStatement.setString(18, "REGULER");
							
							
						}
						//System.out.println(preparedStatement.toString());
						int i = preparedStatement.executeUpdate();
						
						
						if(i>0)
						{
							if(this.isSendSMS())
							{
							
							String messageServiceProvider = "BULKSMSGATEWA";
							String templateId = "1507161796092129346";
    	        			//System.out.println("in Send Message");
    	        			String mobileNumber = this.getCustMobileNumber();
    	        			String msg= "";
    	        			
    	        		if(messageServiceProvider.equals("BULKSMSGATEWAY"))
						{
							String messageApiKey = "nileshkadam#nileshk@d@m123";
							String messageSendrId = "NISCCO";
								try
								{
								String [] keyDetails =  messageApiKey.split("#");
								String userName = keyDetails[0];
								String password = keyDetails[1];
								
								
	    	   
	    	        			String resp  = SendBulkSMSGatewayMessage.sendLanguageSms(userName, password, mobileNumber, msg, messageSendrId, templateId);
	    	        			if(resp.contains("failed"))
	    	        			{
	    	        				addActionError("Counldn't send message" + resp);
	    	        			}
	    	        			else
	    	        			{
	    	        				AddBulkSMSGatewayResponseToDB gatewayResponseToDB = new AddBulkSMSGatewayResponseToDB();
	    	        				Map<String,String> responseDetails = gatewayResponseToDB.addBulkSMSGatewayResponseToDB(resp, mobileNumber, messageServiceProvider, messageSendrId, msg, "NEW-CUSTOMER");
	    	        				
	    	        				if(responseDetails != null)
	    	        				{
	    	        					String dbAdded = responseDetails.get("DBADDED");
	    	        					
	    	        					if(dbAdded.equals("TRUE"))
	    	        					{
	    	        						addActionMessage("Message details added!" + responseDetails.get("MESSAGE"));
	    	        					}
	    	        					else
	    	        					{
	    	        						addActionError("Message details not added! "+responseDetails.get("MESSAGE"));
	    	        					}
	    	        				}
	    	        				
	    	        			}
    									
								}catch (Exception e) {
									addActionError("Couldn't send message to milk supplier!"+e.getMessage()+"|"+e.getCause());
								}
						}
    	        	//
    	        			
							}
						
							
					       
				        		 result = SUCCESS;
				        		
							addActionMessage("Customer details added successfully !");
						}
						else
						{
							result = "error";
							addActionError("Error ! Customer details not added ! Please try again !");
						}
						
						
						
					}catch (SQLException e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Customer details not added !");
					
					} catch (IOException e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || Customer details not added !");
					
					}finally {
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	if(fis != null)
	        	{
	        		fis.close();
	        		fis = null;
	        	}
	        	
	        }
	        return result;
	}

	
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		
		if(this.getCustName() == null || this.getCustName().equals(""))
		{
			addActionError("Please provide customer name!");
		}
		if(!hasActionErrors())
		{
			if(this.getCustMobileNumber() == null || this.getCustMobileNumber().equals(""))
			{
				addActionError("Please provide customer mobile number!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getBillingAddress() == null || this.getBillingAddress().equals(""))
			{
				addActionError("Please provide billing addresss!");
			}
		}
		if(!hasActionErrors()){
			
			if(this.getCustNameMarathi().equals(""))
			{
				addActionError("Please provide customer name in marathi!");
			}
		}
		if(!hasActionErrors())
		{
			if(this.getBillingAddressMrathi().equals(""))
			{
				addActionError("Please provide address in marathi!");
			}
		}
		if(!hasActionErrors())
		{
			if(!getCustMobileNumber().equals(""))
			{
				if(getCustMobileNumber().length() != 10)
				{
					addActionError("Please Provide correct mobile number ! (10 digit)");
				}
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCustSecondaryMobileNumber().trim().length() != 10)
			{
				addActionError("Please provide correct secondary mobile number!");
			}
		}
		if(!hasActionErrors())
		{
			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			String condition = "NA";
			
			result = new CheckAlreadyAvailable().checkCustomerAvaibilityWithOnlyOneCheck(this.getSessionMap(), "crusher_customer_master", "mobile_number", "customer_name" ,this.getCustMobileNumber().trim(), this.getCustName(), condition);
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError("Customer is already added with same name OR mobile number!");
			}				
			
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getCustMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "mobile_number",condition ,this.getCustMobileNumber().trim() );
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError("Customer Is Already Added With Same Mobile Number !");
				}		
			}
			
		}
		
		if(!hasActionErrors())
		{
			if( this.getCreditLimit() == null || getCreditLimit().equals(""))
			{
				addActionError("Please provide correct credit limit amount !");
				
			}else if(this.getCreditLimit() < 0)
			{
				addActionError("Please provide correct credit limit amount  !");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCustomerImage() != null)
				{
					int sizeOfImage =(int)this.getCustomerImage().length();
					
					if(sizeOfImage >  300000)
					{
						addActionError("Size of image large than 300Kb! Please reduce size of image!");
					}
				}
		}
		

		
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getCustAddDate() {
		return custAddDate;
	}


	public void setCustAddDate(String custAddDate) {
		this.custAddDate = custAddDate;
	}


	public String getCustName() {
		return custName;
	}


	public void setCustName(String custName) {
		this.custName = custName;
	}


	public String getCustMobileNumber() {
		return custMobileNumber;
	}


	public void setCustMobileNumber(String custMobileNumber) {
		this.custMobileNumber = custMobileNumber;
	}


	public String getEmail() {
		return email;
	}


	public void setEmail(String email) {
		this.email = email;
	}


	public Float getCreditLimit() {
		return creditLimit;
	}


	public void setCreditLimit(Float creditLimit) {
		this.creditLimit = creditLimit;
	}


	public String getGSTINumber() {
		return GSTINumber;
	}


	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}


	public String getTINumber() {
		return TINumber;
	}


	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}


	public String getPANumber() {
		return PANumber;
	}


	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}


	


	public String getCustNameMarathi() {
		return custNameMarathi;
	}


	public void setCustNameMarathi(String custNameMarathi) {
		this.custNameMarathi = custNameMarathi;
	}


	public String getBillingAddress() {
		return billingAddress;
	}


	public void setBillingAddress(String billingAddress) {
		this.billingAddress = billingAddress;
	}


	public String getBillingAddressMrathi() {
		return billingAddressMrathi;
	}


	public void setBillingAddressMrathi(String billingAddressMrathi) {
		this.billingAddressMrathi = billingAddressMrathi;
	}


	public String getBirthDate() {
		return birthDate;
	}


	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}


	public File getCustomerImage() {
		return customerImage;
	}


	public void setCustomerImage(File customerImage) {
		this.customerImage = customerImage;
	}


	public String getCustSecondaryMobileNumber() {
		return custSecondaryMobileNumber;
	}


	public void setCustSecondaryMobileNumber(String custSecondaryMobileNumber) {
		this.custSecondaryMobileNumber = custSecondaryMobileNumber;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public boolean isSendSMS() {
		return sendSMS;
	}


	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}


	public String getPinCode() {
		return pinCode;
	}


	public void setPinCode(String pinCode) {
		this.pinCode = pinCode;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	
	public HttpServletRequest getRequest() {
		return request;
	}
	
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	
	public HttpServletResponse getResponse() {
		return response;
	}
	
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	
	@Override
	public void setServletResponse(HttpServletResponse httpServletResponse) {
		this.response = httpServletResponse;
	}
	
	@Override
	public void setServletRequest(HttpServletRequest httpServletRequest) {
		this.request = httpServletRequest;
	}


	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	
	

}

