package com.stonecrusher.add;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.bulksmsgateway.AddBulkSMSGatewayResponseToDB;
import com.stonecrusher.bulksmsgateway.SendBulkSMSGatewayMessage;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.infrawhatsappmsg.CheckBalance;
import com.stonecrusher.infrawhatsappmsg.SendWhatsAppMessage;
import com.stonecrusher.resource.CheckAlreadyAvailable;


public class AddNewCustomer  extends ActionSupport implements SessionAware,ServletRequestAware,ServletResponseAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5130010812118775769L;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;

	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private String custAddDate;
	private String custName;
	private String custNameMarathi;
	private String custMobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber = "NA";
	private String PANumber;
	private String billingAddress;
	private String billingAddressMrathi;
	private String birthDate;
	private Float creditLimit;
	private String custSecondaryMobileNumber;
	private boolean sendSMS;
	private File customerImage;
	private String pinCode;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	private String addSideBarJs;
	private File compressedImage;
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	

	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    	  }
		      }
		      

	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	       
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				FileInputStream fis  = null;
				FileInputStream compreessedFis = null;
				
				if(this.getCustomerImage() != null)
				{
				 fis =  new FileInputStream(this.getCustomerImage());

					
				 BufferedImage originalImage = ImageIO.read(fis);
				 
				 Image newResizedImage = originalImage
			              .getScaledInstance(600, 600, Image.SCALE_SMOOTH);
				 
				 
				 BufferedImage newImage = this.toBufferedImage(newResizedImage, 1);
								 
			
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			ImageIO.write(newImage, "jpg", outStream); 
			InputStream isNew = new ByteArrayInputStream(outStream.toByteArray());
			
			
			this.setCompressedImage(new File("new.jpeg"));
				
			copyInputStreamToFile(isNew, this.getCompressedImage());
				 
				 
				 compreessedFis = new FileInputStream(this.getCompressedImage());
				}
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	custAddDate = dateFormat.format(d);
			
					try
					{
						this.setEmail("NA");
						connection = GetDBConnection.getDBConnection(db);
						

						sql = "SELECT "
								+ "customer_id "
								+ "FROM "
								+ "crusher_customer_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "customer_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId =resultSet.getInt(1);
							
							
							entryId = entryId+1;
						}
						else
						{
							entryId =1;
						}
					}
						
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
						if(getGSTINumber().equals(""))
						{
							setGSTINumber("NA");
						}
						if(getTINumber().equals(""))
						{
							setTINumber("NA");
						}
						if(getPANumber().equals(""))
						{
							setPANumber("NA");
						}
						if(getCreditLimit().equals(""))
						{
							setCreditLimit(0.0F);
						}
						if(this.getCustomerImage() != null)
						{
							sql = "INSERT INTO crusher_customer_master "
									+ "("
									+ "customer_id,"
									+ "crusher_id,"
									+ "crusher_code,"
									+ "add_date,"
									+ "customer_name,"
									+ "cust_name_marathi,"
									+ "mobile_number,"
									+ "cust_secondary_mobile,"
									+ "gst_number,"
									+ "pan_number,"
									+ "tin_number,"
									+ "billing_address,"
									+ "billing_address_marathi,"
									+ "birth_date,"
									+ "credit_limit,"
									+ "customer_image,"
									+ "pincode_number,"
									+ "customer_status,"
									+ "customer_type) "
									+ "values "
									+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, entryId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							preparedStatement.setString(4, this.getCustAddDate());
							preparedStatement.setString(5, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(6, this.getCustName().trim().toUpperCase());						
							preparedStatement.setString(7, this.getCustMobileNumber().trim());
							preparedStatement.setString(8, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(9, this.getGSTINumber().trim());
							preparedStatement.setString(10, this.getPANumber().trim().toUpperCase());
							preparedStatement.setString(11, this.getTINumber().trim().toUpperCase());
							preparedStatement.setString(12, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(13, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(14, null);
							preparedStatement.setFloat(15, this.getCreditLimit());
							preparedStatement.setBinaryStream(16, compreessedFis,(int)this.getCompressedImage().length());
							preparedStatement.setString(17, this.getPinCode());
							preparedStatement.setString(18, "ACTIVE");
							preparedStatement.setString(19, "REGULER");
							
						}
						else
						{
							sql = "INSERT INTO crusher_customer_master "
									+ "("
									+ "customer_id,"
									+ "crusher_id,"
									+ "crusher_code,"
									+ "add_date,"
									+ "customer_name,"
									+ "cust_name_marathi,"
									+ "mobile_number,"
									+ "cust_secondary_mobile,"
									+ "gst_number,"
									+ "pan_number,"
									+ "tin_number,"
									+ "billing_address,"
									+ "billing_address_marathi,"
									+ "birth_date,"
									+ "credit_limit,"
									+ "pincode_number,"
									+ "customer_status,"
									+ "customer_type) "
									+ "values "
									+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, entryId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							preparedStatement.setString(4, this.getCustAddDate());
							preparedStatement.setString(5, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(6, this.getCustName().trim().toUpperCase());						
							preparedStatement.setString(7, this.getCustMobileNumber().trim());
							preparedStatement.setString(8, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(9, this.getGSTINumber().trim());
							preparedStatement.setString(10, this.getPANumber().trim().toUpperCase());
							preparedStatement.setString(11, this.getTINumber().trim().toUpperCase());
							preparedStatement.setString(12, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(13, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(14,  null);
							preparedStatement.setFloat(15, this.getCreditLimit());
							preparedStatement.setString(16, this.getPinCode());
							preparedStatement.setString(17, "ACTIVE");
							preparedStatement.setString(18, "REGULER");
							
							
						}
						//System.out.println(preparedStatement.toString());
						int i = preparedStatement.executeUpdate();
						
						boolean sendWhatsAppMessage = false; 
						
						if(this.getSessionMap().get("sendWhatsAppMessage").equals("TRUE"))
						{
							sendWhatsAppMessage = true;
						}
						
						
						if(i>0)
						{
							
							if(sendWhatsAppMessage)
							{
								
								String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
								String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
								
								String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
								
								HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
								
								String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
								
								String [] tokenData = tokenNumberWithUsername.split("#");
								
								String userName = tokenData[0];
								String tokenNumber = tokenData[1];
								
								String msg = crusherNameMarathi + " मध्ये तुमचे सहर्ष स्वागत आहे."								
								+ " आम्हाला आपली सेवा करण्याची संधी दिल्याबद्दल आभारी आहोत! "
	        					+ " भविष्यात आपणांस सर्वोत्तम सेवा देण्यासाठी आम्ही कटिबद्ध आहोत.धन्यवाद! संपर्क:"+customerCareNumber;
								
								String whatsAppResp = SendWhatsAppMessage.sendMessageOnly(userName, this.getCustMobileNumber(), msg, tokenNumber);
								
								
								
								
								if(whatsAppResp.contains("success"))
								{
									
									addActionMessage("Whats App Meesage Sent Successfully!");
								}
								//System.out.println(whatsAppResp);
					
							}
							
					        if(requestFromAndroid)
				        	{
				        		result = "android-success";
				        	}else{
				        		 result = SUCCESS;
				        	}	
							addActionMessage(this.getText("message.success.customerDeatailsAddedSuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.errorCustomerDetailsNotAddedPlzTryAgain"));
						}
						
						
						
					}catch (SQLException e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.customerDetailsNotAdded"));
					
					} catch (IOException e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.customerDetailsNotAdded"));
					
					}finally {
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	if(fis != null)
	        	{
	        		fis.close();
	        		fis = null;
	        	}
	        	
	        }
	        return result;
	}

	
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		
		if(getCustName().equals("") || getCustMobileNumber().equals("") || getBillingAddress().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		
		if(!hasActionErrors())
		{
			if(!getCustMobileNumber().equals(""))
			{
				if(getCustMobileNumber().length() >10)
				{
					addActionError(this.getText("message.error.plzProvideCorrectMobileNumber(10digit)"));
				}
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCustSecondaryMobileNumber().trim().length() > 10)
			{
				addActionError(this.getText("message.error.plzProvideCorrectSecondaryMobileNumber"));
			}
		}
		if(!hasActionErrors())
		{
			if(!this.getCustMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				
				result = new CheckAlreadyAvailable().checkCustomerAvaibilityWithOnlyOneCheck(this.getSessionMap(),"crusher_customer_master", "mobile_number", "customer_name" ,this.getCustMobileNumber().trim(), this.getCustName(), condition);
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError(this.getText("message.error.CustomerIsAlreadyAddedWithSameNameOrMobileNumber"));
				}		
			}
			
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getCustMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "mobile_number",condition ,this.getCustMobileNumber().trim() );
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError("Customer Is Already Added With Same Mobile Number !");
				}		
			}
			
		}
		
		
		if(!hasActionErrors())
		{
			if( this.getCreditLimit() == null || getCreditLimit().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectCreditLimit"));
				
			}else if(this.getCreditLimit() < 0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectCreditLimit"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCustomerImage() != null)
				{
					int sizeOfImage =(int)this.getCustomerImage().length();
					
					if(sizeOfImage >  500000)
					{
						addActionError(this.getText("message.error.sizeOfImagelargeThan300kbPlzReduceSizeOfImage"));
					}
				}
		}
		

		customerSearchOptionList.put("BYNAME", "BY NAME");
    	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
    	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
		setCustomerSearchOption("BYNAME");
		setDefaultValue("BYNAME");
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getCustAddDate() {
		return custAddDate;
	}


	public void setCustAddDate(String custAddDate) {
		this.custAddDate = custAddDate;
	}


	public String getCustName() {
		return custName;
	}


	public void setCustName(String custName) {
		this.custName = custName;
	}


	public String getCustMobileNumber() {
		return custMobileNumber;
	}


	public void setCustMobileNumber(String custMobileNumber) {
		this.custMobileNumber = custMobileNumber;
	}


	public String getEmail() {
		return email;
	}


	public void setEmail(String email) {
		this.email = email;
	}


	public Float getCreditLimit() {
		return creditLimit;
	}


	public void setCreditLimit(Float creditLimit) {
		this.creditLimit = creditLimit;
	}


	public String getGSTINumber() {
		return GSTINumber;
	}


	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}


	public String getTINumber() {
		return TINumber;
	}


	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}


	public String getPANumber() {
		return PANumber;
	}


	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}


	


	public String getCustNameMarathi() {
		return custNameMarathi;
	}


	public void setCustNameMarathi(String custNameMarathi) {
		this.custNameMarathi = custNameMarathi;
	}


	public String getBillingAddress() {
		return billingAddress;
	}


	public void setBillingAddress(String billingAddress) {
		this.billingAddress = billingAddress;
	}


	public String getBillingAddressMrathi() {
		return billingAddressMrathi;
	}


	public void setBillingAddressMrathi(String billingAddressMrathi) {
		this.billingAddressMrathi = billingAddressMrathi;
	}


	public String getBirthDate() {
		return birthDate;
	}


	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}


	public File getCustomerImage() {
		return customerImage;
	}


	public void setCustomerImage(File customerImage) {
		this.customerImage = customerImage;
	}


	public String getCustSecondaryMobileNumber() {
		return custSecondaryMobileNumber;
	}


	public void setCustSecondaryMobileNumber(String custSecondaryMobileNumber) {
		this.custSecondaryMobileNumber = custSecondaryMobileNumber;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public boolean isSendSMS() {
		return sendSMS;
	}


	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public String getPinCode() {
		return pinCode;
	}


	public void setPinCode(String pinCode) {
		this.pinCode = pinCode;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	
	public HttpServletRequest getRequest() {
		return request;
	}
	
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	
	public HttpServletResponse getResponse() {
		return response;
	}
	
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	
	@Override
	public void setServletResponse(HttpServletResponse httpServletResponse) {
		this.response = httpServletResponse;
	}
	
	@Override
	public void setServletRequest(HttpServletRequest httpServletRequest) {
		this.request = httpServletRequest;
	}



	public static BufferedImage convertToBufferedImage(Image img) {

        if (img instanceof BufferedImage) {
            return (BufferedImage) img;
        }

        // Create a buffered image with transparency
        BufferedImage bi = new BufferedImage(
                img.getWidth(null), img.getHeight(null),
                BufferedImage.TYPE_INT_ARGB);

        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.drawImage(img, 0, 0, null);
        graphics2D.dispose();

        return bi;
    }

	
	private static void copyInputStreamToFile(InputStream inputStream, File file)
            throws IOException {

        // append = false
        try (FileOutputStream outputStream = new FileOutputStream(file, false)) {
            int read;
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
	}
	
	
	
	public static BufferedImage toBufferedImage(final Image image, final int type) {
		if (image instanceof BufferedImage)
		return (BufferedImage) image;
		if (image instanceof VolatileImage)
		return ((VolatileImage) image).getSnapshot();
		loadImage(image);
		final BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
		final Graphics2D g2 = buffImg.createGraphics();
		g2.drawImage(image, null, null);
		g2.dispose();
		return buffImg;
		}
		  
		private static void loadImage(final Image image) {
		class StatusObserver implements ImageObserver {
		boolean imageLoaded = false;
		public boolean imageUpdate(final Image img, final int infoflags, 
		      final int x, final int y, final int width, final int height) {
		if (infoflags == ALLBITS) {
		synchronized (this) {
		imageLoaded = true;
		notify();
		}
		return true;
		}
		return false;
		}
		}
		final StatusObserver imageStatus = new StatusObserver();
		synchronized (imageStatus) {
		if (image.getWidth(imageStatus) == -1 || image.getHeight(imageStatus) == -1) {
		while (!imageStatus.imageLoaded) {
		try {
		imageStatus.wait();
		} catch (InterruptedException ex) {}
		}
		}
		}
		}

	public File getCompressedImage() {
		return compressedImage;
	}


	public void setCompressedImage(File compressedImage) {
		this.compressedImage = compressedImage;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
		

}
