package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class AddNewChequeBook extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3568185695339898311L;
	
	
	private String chequeBookAddDate;
	private String bankName;
	private String bankBranch;
	private String accountNumber;
	private String accountHolder;
	private Integer chequeNumberStart;
	private Integer chequeNumberEnd;
	
	private HttpSession session;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	public String execute() throws IOException{
		 
		String result = "login";
		this.setSession(ServletActionContext.getRequest().getSession(false)); 
		
	        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSession().getAttribute("db");
				
				
				try
				{
					String user = (String) session.getAttribute("userFullName");
					String shortName = "";
					try
					{
						shortName = user.split(" ")[0];
					}catch(Exception e)
					{
						shortName = user;
					}
					connection = new GetDBConnection().getDBConnection(db);
					
					List<Integer> checkNumberList = new ArrayList<Integer>();
					Integer chequeStart =this.getChequeNumberStart();
					while(chequeStart <= this.getChequeNumberEnd())
					{
						checkNumberList.add(chequeStart);
						chequeStart = chequeStart + 1;
					}
					
					if(checkNumberList.size() > 100 || checkNumberList.size() < 10)
					{
						result = "input";
						addActionError(this.getText("message.error.plzProvideCorrectChequeNumbers"));
					}
					
					else
					{
						sql = "INSERT "
								+ "INTO "
								+ "cheque_book_details_master "
								+ "("
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "cheque_book_add_date,"
								+ "cheque_book_bank_name,"
								+ "cheque_book_branch_name,"
								+ "cheque_book_account_number,"
								+ "cheque_book_account_holder_name,"
								+ "cheque_number,"								
								+ "cheque_status,"
								+ "status_changed_by) "
								+ "VALUES "
								+ "(?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
						
						preparedStatement = connection.prepareStatement(sql);
						
						for(Integer chequeNum : checkNumberList)
						{
							preparedStatement.setString(1, crusherId);
			        		preparedStatement.setString(2, crusherCode);
			        		preparedStatement.setString(3, this.getChequeBookAddDate());
							preparedStatement.setString(4, this.getBankName().trim().toUpperCase());
							preparedStatement.setString(5, this.getBankBranch().trim().toUpperCase());
							preparedStatement.setString(6, this.getAccountNumber().trim().toUpperCase());
							preparedStatement.setString(7, this.getAccountHolder().trim().toUpperCase());
							preparedStatement.setInt(8, chequeNum);
							preparedStatement.setString(9,"ACTIVE");
							preparedStatement.setString(10, shortName);
							
							preparedStatement.addBatch();
						}
						
						
						int [] rowAdded = preparedStatement.executeBatch();
						
						if(rowAdded.length == checkNumberList.size())
						{
							
							result = "success";
							addActionMessage(this.getText("message.success.chequeBookDetailsAddedSuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.coludNotAddAllTheChequeChequeBookNotAdded"));
						}
						
					
					
					
					}

					customerSearchOptionList.put("BYNAME", "BY NAME");
		        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
		        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
					setCustomerSearchOption("BYNAME");
					setDefaultValue("BYNAME");
					
				}catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.chequeBookDetailsNotAdded"));
				} catch (IOException e) {
					
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.chequeBookDetailsNotAdded"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close();} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
        	
	        }
	        
	     return result;   
	}

	@Override
	public void validate() {
		
		if(this.getChequeBookAddDate() .equals(""))
		{
			addActionError(this.getText("message.error.plzProvideChequeAddDate"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getBankName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideBankName"));
			}
			else if(this.getBankName().length() > 99)
			{
				addActionError(this.getText("message.error.nameOfTheBankContainsMoreThan100Characters"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getBankBranch().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideBranchName"));
			}
			else if(this.getBankBranch().length() > 99)
			{
				addActionError(this.getText("message.error.nameOfTheBranchContainsMoreThan100Characters"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getAccountNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideAccountNumber"));
			}
			else if(this.getAccountNumber().length() > 44)
			{
				addActionError(this.getText("message.error.accountNumberContainsMoreThan45Charatcters"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getAccountHolder().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideAccountHolderName"));
			}
			else if(this.getAccountHolder().length() > 99)
			{
				addActionError(this.getText("message.error.accountHolderNameConatinsMoreThan100Characters"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getChequeNumberStart() == null)
			{
				addActionError(this.getText("message.error.plzProvideCorrectChequeNumberStart"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getChequeNumberEnd() == null)
			{
				addActionError(this.getText("message.error.plzProvideCorrectChequeNumberEnd"));
			}
		}
		
	}
	public String getChequeBookAddDate() {
		return chequeBookAddDate;
	}

	public void setChequeBookAddDate(String chequeBookAddDate) {
		this.chequeBookAddDate = chequeBookAddDate;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankBranch() {
		return bankBranch;
	}

	public void setBankBranch(String bankBranch) {
		this.bankBranch = bankBranch;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public String getAccountHolder() {
		return accountHolder;
	}

	public void setAccountHolder(String accountHolder) {
		this.accountHolder = accountHolder;
	}

	public Integer getChequeNumberStart() {
		return chequeNumberStart;
	}

	public void setChequeNumberStart(Integer chequeNumberStart) {
		this.chequeNumberStart = chequeNumberStart;
	}

	public Integer getChequeNumberEnd() {
		return chequeNumberEnd;
	}

	public void setChequeNumberEnd(Integer chequeNumberEnd) {
		this.chequeNumberEnd = chequeNumberEnd;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	
	

}
