package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetNewIdForNewEntry;
import com.opensymphony.xwork2.ActionSupport;

public class AddNewBoulderSupplier extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap; 
	
	private String boulderSuppName;
	private String boulderSuppFirmName;
	private String address;
	private String boulderSuppMobileNumber;
	private String boulderSuppSecondaryMobileNumber;
	private String GSTINumber;
	private String PANumber;
	private Float boulderBrassRate;
	private Float boulderMtonRate;
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					int newId = GetNewIdForNewEntry.getNewIdForNewEntry("crusher_boulder_supplier_master", "boulder_supplier_id", sessionMap, connection);
					
					
					sql = "INSERT INTO "
							+ "crusher_boulder_supplier_master "
							+ "("
							+ "boulder_supplier_id,"
							+ "crusher_id,"
							+ "crusher_code,"
							+ "boulder_supplier_name,"
							+ "boulder_supplier_firm_name,"
							+ "boulder_supplier_address,"
							+ "boulder_supplier_mobile_number,"
							+ "boulder_supplier_gst_number,"
							+ "boulder_supplier_pan_number,"
							+ "boulder_brass_rate,"
							+ "boulder_mton_rate) "
							+ "VALUES "
							+ "(?,?,?,?,?,?,?,?,?,?,?)";
					
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, newId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, this.getBoulderSuppName().trim().toUpperCase());
					preparedStatement.setString(5, this.getBoulderSuppFirmName().trim().toUpperCase());
					preparedStatement.setString(6, this.getAddress().trim().toUpperCase());
					preparedStatement.setString(7, this.getBoulderSuppMobileNumber().trim());
					preparedStatement.setString(8, this.getGSTINumber().trim().toUpperCase());
					preparedStatement.setString(9, this.getPANumber().trim().toUpperCase());
					preparedStatement.setFloat(10, this.getBoulderBrassRate());
					preparedStatement.setFloat(11, this.getBoulderMtonRate());
					
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						addActionMessage("Boulder supplier details added successfully!");
						result = SUCCESS;
					}
					else
					{
						addActionError("Details not added! Please try again!");
						result = ERROR;
					}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	@Override
	public void validate() {
		
		
		if(this.getBoulderSuppName() == null || this.getBoulderSuppName().equals(""))
		{
			addActionError("Please provide boulder supplier name!");
		}
		
		if(!hasActionErrors())
		{
			if(this.getBoulderSuppFirmName() == null || this.getBoulderSuppFirmName().equals(""))
			{
				addActionError("Please provide boulder supplier firm name!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getAddress() == null || this.getAddress().equals(""))
			{
				addActionError("Please provide addess!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getBoulderSuppMobileNumber() == null || this.getBoulderSuppMobileNumber().equals(""))
			{
				addActionError("Please provide boulder supplier mobile number!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getBoulderBrassRate() == null)
			{
				addActionError("Please provide correct boulder brass rate!");
			}
			else if(this.getBoulderBrassRate() <=0 )
			{
				addActionError("Boulder brass rate cannot be less than or equal to 0!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getBoulderMtonRate() == null)
			{
				addActionError("Please provide correct boulder MTON rate!");
			}
			else if(this.getBoulderMtonRate() <=0 )
			{
				addActionError("Boulder MTON rate cannot be less than or equal to 0!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getBoulderSuppMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				result = new CheckAlreadyAvailable().checkCustomerAvaibilityWithOnlyOneCheck(this.getSessionMap(),"crusher_boulder_supplier_master", "boulder_supplier_mobile_number", "boulder_supplier_name" ,this.getBoulderSuppMobileNumber().trim(), this.getBoulderSuppName(), condition);
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError("This boulder supplier is added with same mobile number or name!");
				}		
			}
			
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getBoulderSuppMobileNumber().equals("9999999999")) 
			{
				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				
				String condition = "NA";
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_boulder_supplier_master", "boulder_supplier_mobile_number",condition ,this.getBoulderSuppMobileNumber().trim() );
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("true"))
				{
					addActionError("boulder supplier Is Already Added With Same Mobile Number !");
				}		
			}
			
		}
		
	}
	
	
	
	public String getBoulderSuppName() {
		return boulderSuppName;
	}



	public void setBoulderSuppName(String boulderSuppName) {
		this.boulderSuppName = boulderSuppName;
	}



	public String getBoulderSuppFirmName() {
		return boulderSuppFirmName;
	}



	public void setBoulderSuppFirmName(String boulderSuppFirmName) {
		this.boulderSuppFirmName = boulderSuppFirmName;
	}



	public String getAddress() {
		return address;
	}



	public void setAddress(String address) {
		this.address = address;
	}



	public String getBoulderSuppMobileNumber() {
		return boulderSuppMobileNumber;
	}



	public void setBoulderSuppMobileNumber(String boulderSuppMobileNumber) {
		this.boulderSuppMobileNumber = boulderSuppMobileNumber;
	}



	public String getBoulderSuppSecondaryMobileNumber() {
		return boulderSuppSecondaryMobileNumber;
	}



	public void setBoulderSuppSecondaryMobileNumber(String boulderSuppSecondaryMobileNumber) {
		this.boulderSuppSecondaryMobileNumber = boulderSuppSecondaryMobileNumber;
	}



	public String getGSTINumber() {
		return GSTINumber;
	}



	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}



	public String getPANumber() {
		return PANumber;
	}



	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}




	public Float getBoulderBrassRate() {
		return boulderBrassRate;
	}



	public void setBoulderBrassRate(Float boulderBrassRate) {
		this.boulderBrassRate = boulderBrassRate;
	}



	public Float getBoulderMtonRate() {
		return boulderMtonRate;
	}



	public void setBoulderMtonRate(Float boulderMtonRate) {
		this.boulderMtonRate = boulderMtonRate;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



