package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddNewBankAccount extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2817788565235865992L;
	
	private HttpSession session;
	private String accountHolderName;
	private String accountNumber;
	private String ifscCode;
	private String bankName;
	private String branch;
	private Float openingBalance;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private SessionMap<String,Object> sessionMap;  
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	String date = dateFormat.format(d);
	        	
				String user = (String) session.getAttribute("userFullName");
				String shortName = "";
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
			
					try
					{
					
						connection = GetDBConnection.getDBConnection(db);
						
						
						sql = "SELECT "
								+ "account_id "
								+ "FROM "
								+ "crusher_bank_account "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "account_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int accountId = 1;
				
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							accountId = Integer.parseInt(resultSet.getString(1));
							accountId = accountId + 1;
							
						}
						
					}
					else
					{	accountId =1;
						
					}
					
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
						
						sql = "INSERT "
								+ "INTO "
								+ "crusher_bank_account "
								+ "(account_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "account_holder_name,"
								+ "account_number,"
								+ "ifsc_code,"
								+ "bank_name,"
								+ "branch,"
								+ "opening_balance) "
								+ "VALUES "
								+ "(?,?,?,?,?,?,?,?,?)";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setInt(1, accountId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, this.getAccountHolderName().trim().toUpperCase());
						preparedStatement.setString(5, this.getAccountNumber().trim().toUpperCase());
						preparedStatement.setString(6, this.getIfscCode().trim().toUpperCase());
						preparedStatement.setString(7, this.getBankName());
						preparedStatement.setString(8, this.getBranch());
						preparedStatement.setFloat(9, this.getOpeningBalance());
						
						int k = preparedStatement.executeUpdate();
						
						if(k>0)
						{
							if(!this.getOpeningBalance().equals(0))
							{
								
							
							String accountIdString = String.valueOf(accountId);
							
							
							 boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountIdString, "CREDIT", date, this.getOpeningBalance(), shortName, connection, this.getSessionMap());
							
							}
							result = "success";
							addActionMessage(this.getText("message.success.accountDetailsAddedSuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.sryAccountDetailsNotAddedPlzTryAgain"));
						}
					}catch (SQLException e) {
						
						result = "error";						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.bankDetailsNotAdded"));
					
					} catch (IOException e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.bankDetailsNotAdded"));
					
					}finally {
						if(resultSet != null)
						{
							try{
								resultSet.close();
								resultSet = null;
							}catch(Exception e){}
									
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();connection=null;}catch (SQLException e) {}
						}
						
					}
	        }
	        
	        return result;
	}
	@Override
	public void validate() {

			if(this.getAccountHolderName() == null || this.getAccountHolderName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideAccountHolderName"));
			}
			
			if(!hasActionErrors())
			{
				if(this.getAccountNumber() == null || this.getAccountNumber().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideAccountNumber"));
				}else if(this.getAccountNumber().length() > 15)
				{
					addActionError(this.getText("message.error.plzProvideCorrectAccountNumber"));
				}
					
			}
			
			if(!hasActionErrors())
			{
				if(this.getIfscCode() == null || this.getIfscCode().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideIfscCode"));
				}
			}
			
			if(!hasActionErrors())
			{
				if(this.getBankName() == null || this.getBankName().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideBankName"));
				}
			}
			
			if(!hasActionErrors())
			{
				if(this.getBranch() == null || this.getBranch().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideBranchName"));
				}
			}
			
			if(!hasActionErrors())
			{
				if(this.getOpeningBalance() == null || this.getOpeningBalance().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideCorrectOpeningBalanceAmount"));
				}
			}
			
			String condition = "NA";
			
			if(!hasActionErrors())
			{
				String isAliasAdded = "false";
				
				String [] result = new String[2];
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_bank_account", "account_number", condition , this.getAccountNumber());
				
				isAliasAdded = result[0];
				
				if(isAliasAdded.equals("true"))
				{
					addActionError(this.getText("message.error.accountIsAlreadyAddedWithSameNumber"));
				}				
				
			}

			customerSearchOptionList.put("BYNAME", "BY NAME");
        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
			setCustomerSearchOption("BYNAME");
			setDefaultValue("BYNAME");
			
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getAccountHolderName() {
		return accountHolderName;
	}

	public void setAccountHolderName(String accountHolderName) {
		this.accountHolderName = accountHolderName;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public String getIfscCode() {
		return ifscCode;
	}

	public void setIfscCode(String ifscCode) {
		this.ifscCode = ifscCode;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranch() {
		return branch;
	}

	public void setBranch(String branch) {
		this.branch = branch;
	}

	public Float getOpeningBalance() {
		return openingBalance;
	}

	public void setOpeningBalance(Float openingBalance) {
		this.openingBalance = openingBalance;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}
	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}
	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	
}
