package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.MaintainCloseingBalUtil;
import com.opensymphony.xwork2.ActionSupport;

public class AddDirectStockDetails extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -8003477253420824924L;

	private SessionMap<String,Object> sessionMap;  
	
	private String productName;
	private float productQuantity;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	 
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	         	
	    		Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	 
	        	java.util.Date date = new java.util.Date();
       	      long t = date.getTime();	        	     
       	      java.sql.Time time = new java.sql.Time(t);
       	      
       	   String fullUserName = (String) this.getSessionMap().get("userFullName");
       	
       	String splitUserName [] = new String[5];
       	
       	String entryBy = "";
       	try
       	{
       		splitUserName = fullUserName.split(" ");
       		entryBy = splitUserName[0];
       		
       	}catch(Exception e)
       	{
       		entryBy = fullUserName;
       	}
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					String productId = this.getProductName().split("-")[0];
					String productName = this.getProductName().split("-")[1];
					
					boolean stockAdded = false;
					
				
					stockAdded = UpdateProductStockDetails.addStockToCurrentStockForPurchase( connection, this.getSessionMap(),productId, productName, this.getProductQuantity());
					
					
					
					if(stockAdded)
					{
						
						

						if(productName.trim().equals("DIESEL"))
						{
							
							float stockConversionRatio = 0.0F;
							PreparedStatement updateStockPSMT= null;
							
							sql = "SELECT "
									+ "in_stock_quantity,"
									+ "stock_conversion_ratio "
									+ "FROM "
									+ "crusher_product_master "
									+ "WHERE "
									+ "product_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							updateStockPSMT = connection.prepareStatement(sql);
							
							updateStockPSMT.setString(1, productId);
							updateStockPSMT.setString(2, crusherId);
							updateStockPSMT.setString(3, crusherCode);
							
					
							resultSet = updateStockPSMT.executeQuery();
							
							if(resultSet.next())
							{
								stockConversionRatio = resultSet.getFloat(2);
							}
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							
							
						sql = "SELECT "
								+ "entry_id "
								+ "FROM "
								+ "diesel_credit_debit_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					
					
					int dieselCreditDebitEntryId = 1;
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							dieselCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
							dieselCreditDebitEntryId = dieselCreditDebitEntryId + 1;
							
						}
						
					}
					else
					{	dieselCreditDebitEntryId =1;
						
					}
					
	        		
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
						sql = "INSERT "
								+ "INTO "
								+ "diesel_credit_debit_master "
								+ "("
								+ "entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "product_id,"
								+ "product_name,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "quantity,"
								+ "entry_by,"
								+ "entry_details,"
								+ "entry_source) "
								+ "VALUES "
								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
						
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setInt(1, dieselCreditDebitEntryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, productId);
						preparedStatement.setString(5, productName);
						preparedStatement.setString(6, dateFormat.format(d));
						preparedStatement.setTime(7, time);
						preparedStatement.setString(8, "CREDIT");
						preparedStatement.setFloat(9, (this.getProductQuantity() * stockConversionRatio));
						preparedStatement.setString(10, entryBy);
						preparedStatement.setString(11, "DIRECT STOCK ADDED QUANTITY: "+(this.getProductQuantity() * stockConversionRatio));
						preparedStatement.setString(12, "ADD DIRECT STOCK ");
						
						int rowInsetred = preparedStatement.executeUpdate();
						
						if(rowInsetred > 0)
						{
							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(productId, productName,"CREDIT", dateFormat.format(d), (this.getProductQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
							
						}
						}
						
						
						
						
						
						if(productName.trim().equals("ADBLUE") || productName.trim().equals("DEF"))
						{
							
							float stockConversionRatio = 0.0F;
							PreparedStatement updateStockPSMT= null;
							
							sql = "SELECT "
									+ "in_stock_quantity,"
									+ "stock_conversion_ratio "
									+ "FROM "
									+ "crusher_product_master "
									+ "WHERE "
									+ "product_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							updateStockPSMT = connection.prepareStatement(sql);
							
							updateStockPSMT.setString(1, productId);
							updateStockPSMT.setString(2, crusherId);
							updateStockPSMT.setString(3, crusherCode);
							
					
							resultSet = updateStockPSMT.executeQuery();
							
							if(resultSet.next())
							{
								stockConversionRatio = resultSet.getFloat(2);
							}
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							
							
						sql = "SELECT "
								+ "entry_id "
								+ "FROM "
								+ "adblue_credit_debit_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					
					
					int adblueCreditDebitEntryId = 1;
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							adblueCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
							adblueCreditDebitEntryId = adblueCreditDebitEntryId + 1;
							
						}
						
					}
					else
					{	adblueCreditDebitEntryId =1;
						
					}
					
	        		
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
						sql = "INSERT "
								+ "INTO "
								+ "adblue_credit_debit_master "
								+ "("
								+ "entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "product_id,"
								+ "product_name,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "quantity,"
								+ "entry_by,"
								+ "entry_details,"
								+ "entry_source) "
								+ "VALUES "
								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
						
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setInt(1, adblueCreditDebitEntryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, productId);
						preparedStatement.setString(5, productName);
						preparedStatement.setString(6, dateFormat.format(d));
						preparedStatement.setTime(7, time);
						preparedStatement.setString(8, "CREDIT");
						preparedStatement.setFloat(9, (this.getProductQuantity() * stockConversionRatio));
						preparedStatement.setString(10, entryBy);
						preparedStatement.setString(11, "DIRECT STOCK ADDED QUANTITY: "+(this.getProductQuantity() * stockConversionRatio));
						preparedStatement.setString(12, "ADD DIRECT STOCK ");
						
						int rowInsetred = preparedStatement.executeUpdate();
						
						if(rowInsetred > 0)
						{
							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(productId, productName,"CREDIT", dateFormat.format(d), (this.getProductQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
							
						}
						}
						
						
						this.setProductName("");
						this.setProductQuantity(0.0f);

						
						result = SUCCESS;
						addActionMessage(this.getText("message.success.directStockDetailsAddedSuccessfully"));
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.directStockDetailsNotAddedPlzTryAgain"));
					}
					
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		if(this.getProductName() == null || this.getProductName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideProductName"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getProductQuantity() == 0 )
			{
				addActionError(this.getText("message.error.plzProvideQuantity"));
			}
		}
	}
	

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}


	public float getProductQuantity() {
		return productQuantity;
	}

	public void setProductQuantity(float productQuantity) {
		this.productQuantity = productQuantity;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



