package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.resource.GetNewIdForNewEntry;
import com.opensymphony.xwork2.ActionSupport;

public class AddBoulderInward extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -6173991972900640682L;
	private SessionMap<String,Object> sessionMap;  
	

	private String inwardDate;
	private String vehicleId;
	private HashMap<String,String> inwardUnitList = new HashMap<String,String>();
	private HashMap<String,String> inwardFromList  = new HashMap<String,String>();
	private HashMap<String,String> inwardToList = new HashMap<String,String>();
	
	private String inwardUnit;
	private String toPlace;
	private String fromPlace;
	
	private String addSideBarJs;
	
	private Float quantity;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				this.setAddSideBarJs("FALSE");
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					String [] vehicleDetails = this.getVehicleId().split("-");
					
					int newId = GetNewIdForNewEntry.getNewIdForNewEntry("boulder_inward_details", "entry_id", this.getSessionMap(), connection);
			
					
						Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        
					  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        	      
	        	      String fullUserName = (String) this.getSessionMap().get("userFullName");
	  	        	
	  	        	String splitUserName [] = new String[5];
	  	        	
	  	        	String entryBy = "";
	  	        	try
	  	        	{
	  	        		splitUserName = fullUserName.split(" ");
	  	        		entryBy = splitUserName[0];
	  	        		
	  	        	}catch(Exception e)
	  	        	{
	  	        		entryBy =fullUserName;
	  	        	}
	  	        	
					sql = "INSERT INTO "
							+ "boulder_inward_details "
							+ "("
							+ "entry_id,"
							+ "crusher_id,"
							+ "crusher_code,"
							+ "entry_date,"
							+ "entry_time,"
							+ "inward_date,"
							+ "vehicle_id,"
							+ "vehicle_number,"
							+ "boulder_quantity,"
							+ "boulder_quantity_unit,"
							+ "inward_from,"
							+ "inward_to,"
							+ "entry_by) "
							+ "VALUES "
							+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
					
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, newId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, dateFormat.format(d));
					preparedStatement.setTime(5, time);
					preparedStatement.setString(6, this.getInwardDate());
					preparedStatement.setString(7, vehicleDetails[0]);
					preparedStatement.setString(8, vehicleDetails[2]);
					preparedStatement.setFloat(9, this.getQuantity());
					preparedStatement.setString(10, this.getInwardUnit());
					preparedStatement.setString(11, this.getFromPlace());
					preparedStatement.setString(12, this.getToPlace());
					preparedStatement.setString(13, entryBy);
					
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						addActionMessage("Inward added successfully!");
						result = SUCCESS;
						
						this.setVehicleId("");
						this.setQuantity(0.0f);
					}
					else
					{
						addActionError("Inward not added! Please try again!");
						result = ERROR;
					}
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	       
	        return result;
	}
	
	
public void validate() {
		
		
   	this.setInwardUnitList(GetListResource.GetBoulderInwardUnitList());
	this.setInwardFromList(GetListResource.GetBoulderInwardFromList());
	this.setInwardToList(GetListResource.GetBoulderInwardToList());

		if(!hasActionErrors())
		{
			if(this.getVehicleId() == null || this.getVehicleId().equals(""))
			{
				addActionError("Please provide vehicle details!");
			}else {
				
				
				try
				{
					String [] details = this.getVehicleId().split("-");
					
					if(details.length <2)
					{
						addActionError("Please provide vehicle details correctly!");
					}
				}
				catch(Exception e)
				{
					addActionError("Please provide vehicle details correctly!");
				}
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getQuantity() == null)
			{
				addActionError("Please provide correct quantity!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    	
			Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			
			String sql = "";
			String db = (String)  this.getSessionMap().get("db");
			
			try
			{
				connection = GetDBConnection.getDBConnection(db);
				
				String [] vehicleDetails = this.getVehicleId().split("-");
				
				sql = "SELECT * FROM "
						+ "boulder_supplier_vehicle_mapping_master "
						+ "WHERE "
						+ "vehicle_id =  ? "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, vehicleDetails[0]);
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				if(!resultSet.next())
				{
					addActionError("This vehicleis not mapped! Please map this vehicle for boulder supplier!");
				}
				
			}catch (SQLException e) {
				
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
			}
			catch (Exception e) {
				
				addActionError(e.getMessage() +" || Something Went Wrong !");
			}
			finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
		}
		
		if(hasActionErrors())
		{
			this.setAddSideBarJs("FALSE");
		}
	
	}
	
	public String getVehicleId() {
	return vehicleId;
}


public void setVehicleId(String vehicleId) {
	this.vehicleId = vehicleId;
}


	public HashMap<String, String> getInwardUnitList() {
		return inwardUnitList;
	}



	public void setInwardUnitList(HashMap<String, String> inwardUnitList) {
		this.inwardUnitList = inwardUnitList;
	}



	public HashMap<String, String> getInwardFromList() {
		return inwardFromList;
	}



	public void setInwardFromList(HashMap<String, String> inwardFromList) {
		this.inwardFromList = inwardFromList;
	}



	public HashMap<String, String> getInwardToList() {
		return inwardToList;
	}



	public void setInwardToList(HashMap<String, String> inwardToList) {
		this.inwardToList = inwardToList;
	}



	public String getInwardUnit() {
		return inwardUnit;
	}



	public void setInwardUnit(String inwardUnit) {
		this.inwardUnit = inwardUnit;
	}



	public String getToPlace() {
		return toPlace;
	}



	public void setToPlace(String toPlace) {
		this.toPlace = toPlace;
	}



	public String getFromPlace() {
		return fromPlace;
	}



	public void setFromPlace(String fromPlace) {
		this.fromPlace = fromPlace;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public Float getQuantity() {
		return quantity;
	}



	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getInwardDate() {
		return inwardDate;
	}


	public void setInwardDate(String inwardDate) {
		this.inwardDate = inwardDate;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



