package com.reallinkbilling.printjob;

import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class PrintJobHandler {
	
	//RealLinkBillingPrintHandler

    public static void main(String args[]) throws Exception {
    	BufferedInputStream inputStream = null;
    	
    	//http://vsgugale.com/billtest.pdf
    	System.out.print("args[0]:"+args[0]);
    
    	try {
    		
    		String billNumber = args[0].replace("RealLinkBillingPrintHandler:", "");
    			 inputStream = new BufferedInputStream(
    					new URL("http://localhost:8080/reallinkbilling/billPrintOnly?billNumber="+args[0]).openStream());
    			  FileOutputStream fileOS = new FileOutputStream("e:\\billtest.pdf");
    			    byte data[] = new byte[1024];
    			    int byteContent;
    			    while ((byteContent = inputStream.read(data, 0, 1024)) != -1) {
    			        fileOS.write(data, 0, byteContent);
    			    }
    			} catch (IOException e) {
    			    // handles IO exceptions
    			}
    	FileInputStream fis = new FileInputStream("e:\\billtest.pdf");
        PDDocument document = PDDocument.load(fis);
    	

        PrintService myPrintService = findPrintService();

        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(new PDFPageable(document));
        job.setPrintService(myPrintService);
        job.print();

    }       

    private static PrintService findPrintService() {
    	 DocFlavor psInFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
         
         PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
         PrintService[] services = PrintServiceLookup.lookupPrintServices(psInFormat, aset);
        
          
         // this step is necessary because I have several printers configured
         PrintService myPrinter = null;
         for (int i = 0; i < services.length; i++){
        	 String svcName = services[i].toString();
        	//System.out.println("service found: "+svcName);
                       
             if (svcName.contains("EPSON") || svcName.contains("TVS")){
                 myPrinter = services[i];
                // System.out.println("my printer found: "+svcName);
                 break;
             }
         }
         return myPrinter;
    }
}