/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;

class SimpleFont
extends FontPane {
    public static final String NO_GLYPH = "None";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;

    SimpleFont(PDSimpleFont font) throws IOException {
        Object[][] tableData = this.getGlyphs(font);
        double[] yBounds = this.getYBounds(tableData, 3);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Font", font.getName());
        attributes.put("Encoding", this.getEncodingName(font));
        attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
        attributes.put("Standard 14", Boolean.toString(font.isStandard14()));
        this.view = new FontEncodingView(tableData, attributes, new String[]{"Code", "Glyph Name", "Unicode Character", "Glyph"}, yBounds);
    }

    private Object[][] getGlyphs(PDSimpleFont font) throws IOException {
        Object[][] glyphs = new Object[256][4];
        for (int index = 0; index <= 255; ++index) {
            glyphs[index][0] = index;
            if (font.getEncoding().contains(index) || font.toUnicode(index) != null) {
                String glyphName = font.getEncoding().getName(index);
                glyphs[index][1] = glyphName;
                glyphs[index][2] = font.toUnicode(index);
                glyphs[index][3] = font instanceof PDVectorFont ? ((PDVectorFont)font).getPath(index) : font.getPath(glyphName);
                ++this.totalAvailableGlyph;
                continue;
            }
            glyphs[index][1] = NO_GLYPH;
            glyphs[index][2] = NO_GLYPH;
            glyphs[index][3] = font.getPath(".notdef");
        }
        return glyphs;
    }

    private String getEncodingName(PDSimpleFont font) {
        return font.getEncoding().getClass().getSimpleName();
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }
}

