/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jasper.servlet;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.jasper.EmbeddedServletOptions;
import org.apache.struts2.jasper.Options;
import org.apache.struts2.jasper.compiler.JspRuntimeContext;
import org.apache.struts2.jasper.compiler.Localizer;
import org.apache.struts2.jasper.servlet.JspServletWrapper;

public class JspServlet
extends HttpServlet {
    private Logger log = LoggerFactory.getLogger(JspServlet.class);
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        String engineOptionsName = config.getInitParameter("engineOptionsClass");
        if (engineOptionsName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> engineOptionsClass = loader.loadClass(engineOptionsName);
                Class[] ctorSig = new Class[]{ServletConfig.class, ServletContext.class};
                Constructor<?> ctor = engineOptionsClass.getConstructor(ctorSig);
                Object[] args = new Object[]{config, this.context};
                this.options = (Options)ctor.newInstance(args);
            }
            catch (Throwable e) {
                this.log.warn("Failed to load engineOptionsClass", e, new String[0]);
                this.options = new EmbeddedServletOptions(config, this.context);
            }
        } else {
            this.options = new EmbeddedServletOptions(config, this.context);
        }
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        if (this.log.isDebugEnabled()) {
            this.log.debug(Localizer.getMessage("jsp.message.scratch.dir.is", this.options.getScratchDir().toString()), new String[0]);
            this.log.debug(Localizer.getMessage("jsp.message.dont.modify.servlets"), new String[0]);
        }
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jspUri = null;
        String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
        if (jspFile != null) {
            jspUri = jspFile;
        } else {
            String pathInfo;
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("JspEngine --> " + jspUri, new String[0]);
            this.log.debug("\t     ServletPath: " + request.getServletPath(), new String[0]);
            this.log.debug("\t        PathInfo: " + request.getPathInfo(), new String[0]);
            this.log.debug("\t        RealPath: " + this.context.getRealPath(jspUri), new String[0]);
            this.log.debug("\t      RequestURI: " + request.getRequestURI(), new String[0]);
            this.log.debug("\t     QueryString: " + request.getQueryString(), new String[0]);
            this.log.debug("\t  Request Params: ", new String[0]);
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.log.debug("\t\t " + name + " = " + request.getParameter(name), new String[0]);
            }
        }
        try {
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("JspServlet.destroy()", new String[0]);
        }
        this.rctxt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (null == this.context.getResource(jspUri)) {
                        String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                        if (includeRequestUri != null) {
                            throw new ServletException(Localizer.getMessage("jsp.error.file.not.found", jspUri));
                        }
                        try {
                            response.sendError(404, request.getRequestURI());
                        }
                        catch (IllegalStateException ise) {
                            this.log.error(Localizer.getMessage("jsp.error.file.not.found", jspUri), new String[0]);
                        }
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }
}

